geomap.control.SuggestBox = function (map, options, defaultLabel, defaultId) {
    var self = this;
    geomap.control.SuggestBox.superclass.constructor.apply(self, [map, options, defaultId]);
    self._label = options.label || defaultLabel;
    self._dataUrl = options.dataUrl;

    self.container.html('<div class="form-group ui-widget">' +
                            ' <label for="' + self.uid + '" class="col-sm-2 control-label">' + self._label + '</label>' +
                            ' <div class="col-lg-10 input-group">' +
                            '  <div id="' + self.uid + '" >' +
                            '</div></div>');

    self._suggester = $('#' + self.uid).magicSuggest(
        {
            allowFreeEntries: false,
            displayField: 'title',
            data: self._dataUrl,
            minChars: 2,
            maxSelection: 1,
            preselectSingleSuggestion: false,
            required: true
        }
    );

    $(self._suggester).on('selectionchange', function () {
        var newSelection = self._suggester.getSelectedItems();
        if (!newSelection || newSelection.length == 0) {
            self.val(null);
        } else {
            self.val(newSelection[0]);
        }
    });

    var value = self.map.urlParams[self.id];
    if (value) {
        $.getJSON(self._dataUrl + '?query=' + value, {}, function (data) {
                      if (data && data.length > 0) {
                          self.val(data[0]);
                      } else {
                          self.val(null)
                      }
                  }
        );
    } else {
        self.val(null)
    }

};

extend(geomap.control.SuggestBox, geomap.control.AbstractControl);

mixin(geomap.control.SuggestBox.prototype, geomap.control.HasValue.prototype);

mixin(geomap.control.SuggestBox.prototype, {

    val: function (newValue, fire) {
        var self = this;
        if (newValue || newValue === null) {
            self._fireBeforeChanged(self._value, newValue);
            self._value = newValue;
            self._suggester.clear(true);
            if (self._value) {
                self._suggester.addToSelection(self._value, true);
            }
            self._fireChanged();
        }
        return self._value;
    }

});
