function addressGeocodeHint(modelLangs) {
    var address = $('#id_address').val();
    if (!address) {
        return;
    }

    function makeHelper(input, text) {
        var link = $('<a href="#" style="border-bottom:1px dashed;">' + text + '</a>'),
            p = $('<p class="help"></p>');

        link.on('click', function(e) {
            e.preventDefault();
            input.val(text);
        });

        input.after(p.append(link));
    }

    $.each(modelLangs, function(name, lang) {
        var input = $('#id_address_' + name);

        if (!input.length) {
            return;
        }

        $.ajax({
            url: 'http://geocode-maps.yandex.ru/1.x/',
            dataType: 'jsonp',
            data: {
                lang: lang,
                results: 1,
                format: 'json',
                geocode: address
            },
            success: function(res) {
                var text;
                try {
                    text = res['response']['GeoObjectCollection']['featureMember'][0]['GeoObject']['metaDataProperty']['GeocoderMetaData']['text'];
                } catch(e) {}

                if (text) {
                    makeHelper(input, text);
                }

            }
        });
    });
}
