geomap.ready(function () {

    var map = new geomap.Map('geomap', {

        titleProvider: function () {
            var parts = [this.controls.station.val(), this.controls.threadPath.val()];

            return $.map(parts,function (part) {
                return part ? part.title : null;
            }).join(' | ') + ' - Лимонный геоадмин';
        },
        urlParams: {
            mode: 'stations'
        },
        resourceUrlPrefix: staticUrl,
        controls: [
            { type: 'StationLayers' },
            {
                id: 'station',
                type: 'SuggestBox',
                label: gettext(gettext('Станция')),
                dataUrl: '/admin/geomap/search/station/'
            },
            {
                id: 'buttons-nav',
                type: 'ButtonPanel',
                title: gettext('Навигация'),
                buttons: [
                    { preset: 'threadPath#next' },
                    { preset: 'threadPath#nextUnmapped' },
                    { preset: 'threadPath#selectThread'}
                ]
            },
            {
                id: 'buttons-actions',
                type: 'ButtonPanel',
                title: gettext('Действия'),
                presets: ['threadPath#save', 'threadPath#reset', 'threadPath#route', 'threadPath#remove']
            },
            {
                type: 'ThreadPath',
                dataProvider: function (map, callback) {
                    var station = map.controls.station.val();
                    if (!station) {
                        callback([]);
                        return;
                    }

                    $.getJSON('/admin/lime/station/' + station.id + '/segments/all/', {}, function (data) {
                        geomap.utils.preparePathSegments(data.segments);
                        callback(data.segments);
                    });
                },
                station: {
                    placemark: {
                        optionsProvider: function (station) {
                            return {
                                draggable: true,
                                hideIconOnBalloonOpen: false,
                                iconLayout: 'default#image',
                                iconImageSize: [21, 21],
                                iconImageOffset: [-10, -10],
                                iconImageHref: staticUrl + 'rasp/rainbow/greenDotBig.png'
                            };
                        }
                    }
                }
            }
        ]

    });

    var threadPath = map.controls.threadPath;
    map.controls.station.events.add('changed', function (event) {
        threadPath.refresh();
    });

    map.controls.station.events.add('changed', function (event) {
        var val = map.controls.station.val();
        if (val) {
            map.controls.stationLayers.setRequiredTransportType(val.t_type_code);
        }
    });

    map.controls.station.events.add('beforeChange', function (event) {
        if (!threadPath.checkChanges()) {
            event.originalEvent.cancel();
        }
    });
});
