// Слои карты, https://jira.yandex-team.ru/browse/RASP-13162

function StationLayersControl(options, mediaUrl) {
    var _this = this,
        ids,
        items;

    this.tTypesDict = options.t_types;

    items = [
        { title: gettext('Автобусы'), tTypes: ['bus'], color: 'yellow' },
        { title: gettext('Городской транспорт'), tTypes: ['urban'], color: 'black' },
        { title: gettext('Поезда и пригородные поезда'), tTypes: ['train', 'local_train'], color: 'green' },
        { title: gettext('Псевдо-гортранс'), tTypes: ['pseudo-gortrans'], color: 'grey' },
        { title: gettext('Речной и морской транспорт'), tTypes: ['water'], color: 'blue' },
        { title: gettext('Самолеты и вертолеты'), tTypes: ['plane', 'helicopter'], color: 'orange' }
    ];
    
    items = items.sort(function(o1, o2) {
        if (o1.title == o2.title) {
            return 0;
        }
        return o1.title > o2.title ? 1 : -1;
    });

    var tTypes = $.cookie("station_layers_controll_selected");

    if (tTypes == null || tTypes == '') {
        tTypes = [ options.t_type ];
    } else {
        tTypes = eval(tTypes);
        tTypes.push(options.t_type)
    }

    this.items = $.map(items, function(item) {

        var controlItem = new ymaps.control.ListBoxItem(
            {
                data: {
                    content: "<img src='" + mediaUrl + "rainbow/" + item.color + "Dot.png" + "' > " + item.title,
                    tTypes: item.tTypes
                }
            }, {
                checkbox: true,
                // Свой вид транспорта - это вид, относящийся к тому пакету, в котором работаем. Его нельзя отключить.
                selectOnClick: $.inArray(options.t_type, item.tTypes) == -1
            }
        );

        for (var i = 0; i < tTypes.length; i++)  {
            if($.inArray(tTypes[i], item.tTypes) != -1) {
                controlItem.select();
                break;
            }
        }

        controlItem.events.add(['select', 'deselect'], _this.onChangeLayers, _this);

        return controlItem;

    });

    this._updateTTypes();

    this.control = new ymaps.control.ListBox({
        data: {
            title: gettext('Остановки'),
            content: gettext('Остановки')
        },
        items: this.items
    });

    this.events = new ymaps.event.Manager();

    this._inhibitChange = false;

};

StationLayersControl.prototype = {

    tTypes: [],

    _inhibitChange: true,

    onChangeLayers: function() {

        if(this._inhibitChange)
            return;

        var oldTTypes = this.tTypes,
            changed = false;

        this._updateTTypes();

        if(oldTTypes.length == this.tTypes.length) {

            for(var i = 0; i < oldTTypes.length; i++) {

                if(oldTTypes[i] != this.tTypes[i]) {
                    changed = true;
                    break;
                }

            }

        } else {

            changed = true;

        }

        if(changed) {
            $.cookie("station_layers_controll_selected", JSON.stringify(this.tTypes), { path:"/admin/" });

            this.events.fire('change');
        }
    },

    _updateTTypes: function() {

        this.tTypes = $.map(this.items, function(item) {

            if(item.isSelected()) {
                return item.data.get('tTypes');
            };

            return null;

        });

    },

    getTTypes: function() {
        return this.tTypes;
    },

    setTType: function(tType, dontFireChange) {

        tType = this.tTypesDict.hasOwnProperty(tType) ? this.tTypesDict[tType].code : tType;

        this._inhibitChange = true;

        $.each(this.items, function(i, item) {

            if(!tType || $.inArray(tType, item.data.get('tTypes')) != -1) {
                item.select();
            }

        });

        this._inhibitChange = false;

        if(!dontFireChange) {
            this.onChangeLayers();
        } else {
            this._updateTTypes();
        }

    }

};
