// масштаб карты, с которого начинаю отображаться станции заданного типа
// https://jira.yandex-team.ru/browse/RASP-13310

function StationZoomControl(title, cookieName, options) {
    var _this = this,
        currentZoom = $.cookie(cookieName),
        minZoom = 6,
        maxZoom = 18;
    
    if (currentZoom == null || currentZoom == '' || currentZoom < minZoom) {
        currentZoom = minZoom;
    }

    this.items = [];

    // масштаб карты от 0 до 18, но до minZoom он слишком мелкий
    for (var i = minZoom; i <= maxZoom; ++i) {

        var controlItem = new ymaps.control.ListBoxItem(
            {
                data: {
                    content: i,
                    zoom: i
                }
            }, {
                selectOnClick: true
            }
        );

        if (i == currentZoom) {
            controlItem.select();
        }

        this.items.push(controlItem);

        controlItem.events.add(['click'], function() {
            $.cookie(cookieName, this, { path:"/admin/" });

            for(var i = minZoom; i < maxZoom; ++i) {
                if (this != i) {
                  _this.items[i-minZoom].deselect();
                }
            }

            _this.control.collapse();
            _this.events.fire('change');
        }, i);
    }

    this.control = new ymaps.control.ListBox({
        data: {
            title: title,
            content: title
        },
        items: this.items
    });

    this.events = new ymaps.event.Manager();
}
