// use ymaps Api 2.x
include('../rainbow/statusBar.js');

var WwwStations = function(map, mediaUrl, getActiveTTypeID, options, layersControl, events) {
    include('WwwStation.js');
    include('GorTransStation.js');

    var self, wwwStations,
        stations = {},
        gorTStationsCollection = null,
        settlements = {},
        $callbacks = $('<div></div>'),
        station_majorities = options.station_majorities || [],
        station_types = options.station_types || [],
        statusBar = StatusBar(),
        t_types = options.t_types || [],
        defaultTTypeCode = options.t_type;

    var defaultTTypeId;

    $.each(t_types, function(id, tType) {
        if (tType.code === defaultTTypeCode) {
            defaultTTypeId = id;
            return false;
        }
    });

    wwwStations = self = {

        majoritySelectOptions: function(majority_id) {
            majority_id = majority_id || 4;
            var options = '';

            $.each(station_majorities, function(j, majority) {
                options += '<option value="' + majority.id + '" ' + (majority.id == majority_id ? 'selected="selected"' : '') + '>' + majority.title + '</option>';
            });

            return options;
        },

        tTypeSelectOptions: function(tTypeId) {
            tTypeId = tTypeId || defaultTTypeId;
            var options = '';

            $.each(t_types, function(id, tType) {
                options += '<option value="' + tType.id + '"' +
                    (tType.id == tTypeId ? ' selected="selected"' : '')
                    + '>' + tType.title + '</option>';
            });

            return options;
        },

        stationTypeSelectOptions: function(stationTypeId) {
            stationTypeId = stationTypeId || 11;
            var options = '';

            $.each(station_types, function(index, stationType) {
                options += '<option value="' + stationType.id + '" ' + (stationType.id == stationTypeId ? 'selected="selected"' : '') + '>' + stationType.name + '</option>';
            });

            return options;
        },

        majorityChanger: function(station_id, majority_id) {
            return '<select class="majority-select" data-station_id="' + station_id + '">' +
                this.majoritySelectOptions(majority_id) +
                '</select>' +
                '<input type="button" class="b-save-majority" value="Сохранить"/>';
        },

        getSettlementTitleById: function(id) {
            return settlements[id] && settlements[id].title || id;
        },

        redrawFull: function() {
            $.each(stations || [], function(j, s) {
                s.destruct();
            });
            stations = {};

            self.redraw();
        },

        redraw: function(callback) {

//            clearTimeout(boundsTimeout);

            var center = map.getCenter(),
                bounds = map.getBounds(),
                params = {
                    center: '' + center[0] + ',' + center[1],
                    span: '' + (bounds[1][0] - bounds[0][0]) + ',' + (bounds[1][1] - bounds[0][1]),
                    zoom: map.getZoom()
                };

            if(layersControl) {
                params.t_types = layersControl.getTTypes();

                if(!params.t_types.length)
                    params.t_types = '';
            }

            $.getJSON('/admin/redmap/www_stations/', $.param(params, true), function (data) {
                var newStations = {},
                    newGorTStationsCollection = new ymaps.GeoObjectCollection({}, {
                        iconImageSize: [11, 11],
                        iconImageOffset: [-5, -5],
                        iconImageHref: mediaUrl + 'rainbow/liteGreyDot.png'
                    });

                $.each(data.settlements || [], function(j, s) {
                    settlements[j] = s;
                });

                if(!data.stations) {
                    statusBar.say(gettext('слишком много остановок, увеличьте масштаб'), {wait: 0});
                } else {
                    statusBar.close();
                }

                // gortrans stations
                $.each(data.gort_stations || [], function(j, s) {
                    var pm = GorTransStationPmCreate(s)
                    if(pm) {
                        newGorTStationsCollection.add(pm);
                    }
                });

                if(gorTStationsCollection) {
                    map.geoObjects.remove(gorTStationsCollection);
                }

                gorTStationsCollection = newGorTStationsCollection;
                map.geoObjects.add(gorTStationsCollection);
                // /gortrans stations

                $.each(data.stations || [], function(j, s) {
                    if(s.id in stations) {
                        newStations[s.id] = stations[s.id];
                        newStations[s.id].update(s);
                        delete stations[s.id];
                    } else {
                        newStations[s.id] = WwwStation(s);
                    }
                });
                $.each(stations || [], function(j, s) {
                    s.destruct();
                });
                stations = newStations;

                if(typeof(callback) == 'function') {
                    callback();
                }

                $callbacks.trigger('redraw');
            });
        },

        each: function(fn) {
            $.each(stations, fn);
        },

        add: function(s) {
            if(s.id in stations) {
                stations[s.id].update(s);
            } else {
                stations[s.id] = WwwStation(s);
            }
        },

        bind: function(event, handler) {
            $callbacks.bind(event, handler);
        },

        unbind: function(event, handler) {
            $callbacks.unbind(event, handler);
        },

        getById: function(wwwStationId) {
            return stations[wwwStationId];
        },

        setRightStyle : function() {
            $.each(stations, function(j, s) {
                s.setRightStyle();
            });
        },

        // Интерфейсное удаление
        destructById: function(station_id) {
            if(stations[station_id]) {
                stations[station_id].destruct();
                $callbacks.trigger('destructed', stations[station_id]);
                delete stations[station_id];
            }
        },

        changeMajorityById: function(station_id, majority_id) {
            if(stations[station_id]) {
                stations[station_id].changeMajority(majority_id);
            }
        },

        updateStation: function(station) {
            return $.post('/admin/blue/station/?action=update_station', station,
                function(data) {
                    if (data.status !== 'ok') {
                        alert(gettext('Не удалось обновить станцию'));
                    }

                    return data.station;
                }
            );
        },

        findClosest: function(pm, maxDistance) {
            return findClosest({pm: pm}, maxDistance);
        }

    };

    // ===============================================================
    // Перетаскивание станций нашей базы

    function geoCoords2Pixels(coords) {
        return map.options.get('projection').toGlobalPixels(coords, map.getZoom());
    }

    function findClosest(station, maxDistance) {
        if(!station.pm) {
            return;
        }

        var coords = station.pm.geometry.getCoordinates(),
            pixelCoords = geoCoords2Pixels(coords),
            closest = null,
            distance = null;

        function metric(q, p) {
            return Math.max(Math.abs(q[0] - p[0]), Math.abs(q[1] - p[1]));
        }

        $.each(stations, function(j, v) {
            if(v == station) { return true; }

            var checking = v.pm && geoCoords2Pixels(v.pm.geometry.getCoordinates()),
                d = checking && metric(pixelCoords, checking);

            if(checking && (distance===null || d < distance)) {
                distance = d;
                closest = v;
            }
        });

        if(typeof(maxDistance) != 'undefined' && distance > maxDistance) {
            closest = null;
        }

        return closest;
    }


    $callbacks.bind('stationDrag', function(e, data) {
        var closest = findClosest(data.station, 7);

        if(closest) {
            data.station.setStyle('green');
            data.station.closest = closest;
        } else {
            data.station.setRightStyle();
            data.station.closest = null;
        }
    });

    $callbacks.bind('stationDragEnd', function(e, data) {
        var src = data.station,
            dst = data.station.closest,
            originalCoords = [src.lon, src.lat],
            coords = src.pm.geometry.getCoordinates();

        if(dst) {
            src.setRightStyle();

            if(!confirm(gettext('Объединить станцию') + ' ' + src.id + ' ' + src.title + ' ' + gettext('с') + ' ' + dst.id + ' ' + dst.title + ' ?')) {
                src.update();
                return;
            };

            src.hide();
            $callbacks.trigger('prejoined', {'src': src, 'dst': dst});

            $.post('/admin/redmap/www_station/join/',
                { 'src_id': src.id, 'dst_id': dst.id },
                function (data) {
                    if(data.status == 'ok') {
                        self.destructById(src.id);
                    } else {
                        alert(gettext('Не смогли объединить станции'));
                        src.show();
                        src.update();
                        $callbacks.trigger('joinrollback', {'src': src, 'dst': dst});
                    }
                }, 'json'
            );
        } else {
            if(!confirm(gettext('Переместить станцию') + ' ' + src.title + ' ?')) {
                src.update();
                return;
            };

            src.update({lon: coords[0], lat: coords[1]});
            $callbacks.trigger('moved', {station: src, originalCoords: originalCoords});

            $.post('/admin/redmap/www_station/move/',
                {'station_id': src.id,
                 'lon': src.lon,
                 'lat': src.lat},
                function (data) {
                    if(data.status != 'ok') {
                        alert(gettext('Не смогли переместить станцию') + ' ' + src.title);
                        src.update({lon: originalCoords[0], lat: originalCoords[1]});
                        $callbacks.trigger('moved', {station: src, fromCoords: coords});
                    }
                }, 'json'
            );
        }
    });
    // /Перетаскивание станций нашей базы
    // ===============================================================

    // Смена важности из баллуна
    $('#map').delegate('.b-save-majority', 'click', function() {
        var $select = $(this).prev('SELECT'),
            station_id = $select.attr('data-station_id'),
            majority_id = $select.val();

        self.changeMajorityById(station_id, majority_id);
    });

    events && jQuery.each(events, function() {
        this.add('change', function(e) {
            self.redraw();
        });
    });

    return self;
};
