ymapsUtils = {
    getHashParams: function() {
        var params = {},
            parts = window.location.hash.slice(1).split(',');

        // Хак для вытаскивания значений с запятой
        for(var i = 1; i < parts.length; i++) {
            // Приклепляем кусок без "=" к предыдущему
            if(parts[i].indexOf('=') == -1) {
                parts[i - 1] = parts[i - 1] + ',' + parts.splice(i, 1)[0];
                i--; // уменьшаем счетчик, так как вынули текущий элемент из массива
            }
        }

        $.each(parts, function() {
            var d = this.split('=', 2);

            if(d.length == 2) {
                params[d[0]] = decodeURIComponent(d[1]);
            }
        });

        return params;
    },

    setHashParams: function(newParams, reset) {
        var params = ymapsUtils.getHashParams(),
            hashParams = [];

        if(reset)
            params = {};

        for(name in newParams) {
            var value = newParams[name];

            if(value === undefined || value === null || value == '') {
                delete params[name];
            } else {
                params[name] = value;
            }
        }

        $.each(params, function (k, v) {
            hashParams.push(k + '=' + encodeURIComponent(v));
        });

        window.location.hash = '#' + hashParams.join(',');
    }
};
