function ContextMenu(route, behaviorSelect, behaviorCreating) {
    this.route = route;
    this.behaviorSelect = behaviorSelect;
    this.behaviorCreating = behaviorCreating;

    this.el = $('.b-context-menu');

    this.buttons = {
        beforeSelectBtn: $('.b-context-menu li:first .b-button-select'),
        beforeCreateBtn: $('.b-context-menu li:first .b-button-create'),
        afterSelectBtn: $('.b-context-menu li:last .b-button-select'),
        afterCreateBtn: $('.b-context-menu li:last .b-button-create')
    };
}

$.extend(ContextMenu.prototype, {

    setStation: function(station) {
        this.station = station;
    },

    show: function(offset) {
        this.el
            .css('top', offset.top)
            .css('left', offset.left)
            .show();

        this._bind();
    },

    hide: function() {
        this.el.hide();
        this._unbind();
    },

    _bind: function() {
        var _this = this;

        function makeHandler(control, position, id) {
            return function(e) {
                e.preventDefault();
                control.select();
                _this.route['_' + position] = id;
                _this.hide();
            };
        }

        this.buttons.beforeSelectBtn
            .bind('click', makeHandler(this.behaviorSelect, 'before', this.station.id));

        this.buttons.beforeCreateBtn
            .bind('click', makeHandler(this.behaviorCreating, 'before', this.station.id));

        this.buttons.afterSelectBtn
            .bind('click', makeHandler(this.behaviorSelect, 'after', this.station.id));

        this.buttons.afterCreateBtn
            .bind('click', makeHandler(this.behaviorCreating, 'after', this.station.id));

        $(document).bind('mousedown.contextMenu', $.proxy(this._clickOutsideHandler, this));
    },

    _unbind: function() {
        $(document).unbind('mousedown.contextMenu');

        $.each(this.buttons, function(key, elem) {
            elem.unbind('click');
        });
    },

    _clickOutsideHandler: function(e) {
        if (this.el.is(e.target) || this.el.has(e.target).length > 0) {
            return;
        }

        this.hide();
    }

});
