include('settings.js');

function Route() {
    var self,
        saved = true,
        $routeSelect = $('.b-control-package-route SELECT').eq(0),
        redStations;

    redStations = (function() {
        var self,
            stations = {},
            $list = $('.b-control-route-stations TABLE.list').eq(0),
            originalOrder;

        function resetStationOrder(table, rows) {
            var tbody = $(table.tBodies[0]);

            rows.sort(function(a, b) {
                return a.id - b.id;
            });

            tbody.empty();
            $.each(rows, function(i, row) {
                tbody.append(row);
            });

            $list.tableDnDUpdate();
        }

        $list.tableDnD({
            onDrop: function(table, row) {
                var rows = [].slice.call(table.tBodies[0].rows);

                if (confirm(gettext('Сохранить перемещение станции ') + $(row).find('.i-title').text() + '?')) {
                    var newOrder = $.map(rows, function(row) {
                        return row.id;
                    });

                    $.post('/admin/redmap/route/reorder/', {metaroute_id: self.metaroute.id, order: newOrder}, function(response) {
                        if (response.status === 'ok') {
                            $.each(response.order, function(id, order) {
                                stations[id].order = order;
                            });
                            self.renumberStations();

                            if (response.route_check_error) {
                                statusBar.say(response.route_check_error, {wait: STATUS_MESSAGE_SHOW_TIME});
                            }
                        } else {
                            resetStationOrder(table, rows);
                            alert(gettext('Не удалось поменять порядок станций'));
                        }
                    });

                } else {
                    resetStationOrder(table, rows);
                }
            },

            onDragStart: function(table, row) {
                var rows = [].slice.call(table.tBodies[0].rows);

                originalOrder = $.map(rows, function(row) {
                    return row.id;
                });
            }
        });

        include('RedStation.js');

        self = {
            add : function(data) {
                var redStation = RedStation(data);
                self.destructById(redStation.id);
                stations[redStation.id] = redStation;
                // Добавить станцию в блок
                stations[redStation.id].get$tr().appendTo($list);
            },

            update : function(data) {
                $.each(stations, function(j, s) {
                    s.destruct();
                });
                stations = {};

                $.each(data, function(j, s) {
                    self.add(s);
                });

                self.renumberStations();
                $list.tableDnDUpdate();
            },

            getById : function(redStationId) {
                return stations[redStationId];
            },

            // Удаление из рейса
            deleteFromRouteStationById : function(redStationId) {
                if(stations[redStationId]) {
                    stations[redStationId].deleteFromRoute();
                }
            },

            // Интерфейсное удаление
            destructById : function(redStationId) {
                if(stations[redStationId]) {
                    stations[redStationId].destruct();
                    delete stations[redStationId];
                    self.renumberStations();
                }
            },

            renumberStations : function() {
                var num = 1,
                    stationArr = $.map(stations, function(value, i) {
                        return [value];
                    });

                stationArr.sort(function(a, b) {
                    return a.order - b.order;
                });

                $.each(stationArr, function(j, s) {
                    s.setNumber(num);
                    num += 1;
                });
            },

            each : function(callback) {
                    if(!$.isEmptyObject(stations)) {
                        $.each(stations, function(j, s) {
                        callback(j, s);
                    });
                }
            },

            getSchedule : function() {
                var schedule = [];
                $.each(stations, function(j, s) {
                    var fields = ['id', 'arrival', 'departure', 'is_fuzzy',
                                  'is_searchable_to', 'is_searchable_from',
                                  'in_station_schedule'],
                        repr = $.map(fields, function(v, k) {return s[v]}).join('|');
                    schedule.push(repr);
                });
                return schedule;
            }

        };
        return self;
    })();

    $routeSelect.bind('change', function() {
        var route_id = $(this).val();

        if(route.is_saved() || confirm(gettext('Изменения не сохранены. Точно перейти?'))) {
            route.select(route_id);
        } else {
            $('OPTION[selected="selected"]', $routeSelect).each(function() {
                $(this).removeAttr('selected');
            });
            $('OPTION[value=' + self.id + ']', $routeSelect).attr('selected','selected');
        };

    });

    $(document).delegate('.b_delete_station_from_route', 'click', function() {
        var station_id = $(this).attr('data-id'),
            station = redStations.getById(station_id);
        if(station) {
            station.deleteFromRoute();
        }
    });

    $('INPUT, SELECT, TEXTAREA', $('.b-control-package-route, .b-control-route-stations, .b-control-route-schedules')).change(function() {

        var name = $(this).attr('name'),
            value = $(this).val();

        self[name] = value;
        saved = false;
        self.changed();

        if(name == 't_type') {
            layersControl.setTType(value);
        }

    });

    function updateRoute(data) {
        var $created_route,
            $select;

        // 1 Информация
        self.id = data.id;
        self.number = data.number;
        self.title = data.title;
        self.geoadmin_link = data.geoadmin_link;
        self.bounds = data.bounds;
        self.scheme = data.scheme;
        self.comment = data.comment;
        self.t_type = data.t_type;
        self.supplier = data.supplier;

        layersControl.setTType(self.t_type);

        $.each(['id', 't_type', 'supplier'], function(j, name) {
            $select = $('.b-control-package-route SELECT[name=' + name + ']');

            $('OPTION[selected="selected"]', $select).each(function() {
                $(this).removeAttr('selected');
            });
            $('OPTION[value=' + self[name] + ']', $select).attr('selected','selected');
        });

        $('.b-control-package-route #id_route_number').val(self.number);
        $('.b-control-package-route #id_route_title').val(self.title);

        $('.b-control-route-schedules .schedule TEXTAREA[name=scheme]').val(self.scheme);
        $('.b-control-route-schedules .schedule TEXTAREA[name=comment]').val(self.comment);

        $('.f-route-import INPUT[name=route_id]').val(data.id);

        $('A.geoadmin-route-link').attr('href', self.geoadmin_link);

        $created_route = $('<table></table>');
        $.each(data.routes, function(j, r) {
            $created_route.append('<tr>' +
                '<th>' + gettext('Созданный рейс') + '</th>' +
                '<td><a href="/admin/www/route/' + r.id + '/" target="_blank">' + (r.title || r.id) + '</a></td></tr>');
        });
        $('.created_route').html($created_route);

        ymapsUtils.setHashParams({'route_id': self.id});

        // 2 Станции следования
        redStations.update(data.stations);

    }

    wwwStations.bind('joinrollback', function(e, data) {
        self.select(self.id);
    });



    self = {

        select : function(route_id, kwargs) {
            if(typeof(kwargs) == 'undefined') {
                kwargs = {};
            }

            // Достать данные рейса
            $.getJSON('/admin/redmap/metaroute/' + route_id + '/', {}, function (data) {
                updateRoute(data);

                if(!kwargs.doNotFocuse) {
                    // Центрировать на карте
                    map.setBounds(self.bounds, { precizeZoom : true, duration: 330 });
                }

                saved = false;

                behaviorSelect.enable();
                behaviorCreating.enable();
            });

        },

        addStation : function(www_station_id) {
            $.post('/admin/redmap/mrstation/add/', {
                    station_id: www_station_id,
                    metaroute_id: self.id,
                    before: self._before,
                    after: self._after
                },
                function (data) {
                    if (data.mrstation.id && self._before || self._after) {
                        self.select(self.id);
                        delete self._before;
                        delete self._after;
                    } else if(data.mrstation.id) {
                        redStations.add(data.mrstation);
                        redStations.renumberStations();
                        self.changed();
                    } else {
                        alert(gettext('Не можем добавить станцию в мета-рейс'));
                    }

                    if (data.route_check_error) {
                        statusBar.say(data.route_check_error, {wait: STATUS_MESSAGE_SHOW_TIME});
                    }
                },
                'json'
            ).error(function() {
                    alert(gettext('Не можем добавить станцию в мета-рейс'));
            });
        },

        changed : function() {
            saved = false;
        },

        set_saved : function() {
            saved = true;
        },

        is_saved : function() {
            return saved ? true : false;
        },

        createNewStation : function(country_id, region_id, settlement_id, title, lon, lat, majority_id) {
            $.post('/admin/redmap/mrstation/create/', {
                    'country_id': country_id,
                    'region_id': region_id,
                    'settlement_id': settlement_id,
                    'title': title,
                    'longitude': lon,
                    'latitude': lat,
                    'metaroute_id': self.id,
                    'majority_id': majority_id,
                    'before': self._before,
                    'after': self._after
                },
                function (data) {
                    if (self._before || self._after) {
                        self.select(self.id);
                        delete self._before;
                        delete self._after;
                        return;
                    }

                    if(data.www_station && data.red_station) {
                        wwwStations.add(data.www_station);
                        redStations.add(data.red_station);

                        if (data.route_check_error) {
                            statusBar.say(data.route_check_error, {wait: STATUS_MESSAGE_SHOW_TIME});
                        }
                    } else {
                        alert(gettext('Не можем создать новую станцию'));
                    }
                },
                'json'
            ).error(function() {
                    alert(gettext('Не можем создать новую станцию'));
            });
        },

        save : function(callback, cancelback, errorback, params) {
            var routeData;
            params = typeof(params) != 'undefined' ? params : {};

            if(typeof(callback) == 'undefined') { callback = $.noop; }
            if(typeof(cancelback) == 'undefined') { cancelback = $.noop; }
            if(typeof(errorback) == 'undefined') { errorback = cancelback;  }

            if(!self.id) {
                callback();
                return;
            }

            if(saved) {
                statusBar.say(gettext('Мета-рейс уже сохранён'), {wait: STATUS_MESSAGE_SHOW_TIME});
                callback();
            } else {
                routeData = {
                    metaroute_id: self.id,
                    number: self.number,
                    title: self.title,
                    scheme: self.scheme,
                    comment: self.comment,
                    schedule: redStations.getSchedule(),
                    t_type_id: self.t_type,
                    supplier_id: self.supplier

                }; // Информация о мета-рейсе и времена следования по станциям

                $.post('/admin/redmap/route/save/', routeData,
                    function (data) {
                        if(data.status == 'ok') {
                            callback();
                            $('OPTION[value=' + self.id + ']', $routeSelect).html(self.number + ' - ' + self.title);
                            saved = true;

                            var status_text = gettext('Мета-рейс успешно сохранён');
                            if (data.route_check_error) {
                                status_text += '<br />' + data.route_check_error;
                            }
                            statusBar.say(status_text, {wait: STATUS_MESSAGE_SHOW_TIME});

                        } else {
                            alert(gettext('Не можем сохранить мета-рейс') + '\n' + (data.message || ''));
                            errorback();
                        }
                    },
                    'json'
                ).error(function() {
                        alert(gettext('Не можем сохранить мета-рейс'));
                        errorback();
                });
            }
        },

        create : function(package_id, callback, cancelback, errorback) {
            if(typeof(callback) == 'undefined') { callback = $.noop; }
            if(typeof(cancelback) == 'undefined') { cancelback = $.noop; }
            if(typeof(errorback) == 'undefined') { errorback = cancelback;  }

            $.post('/admin/redmap/route/create/', { package_id: package_id },
                function (data) {
                    if(data.id) {

                        self.title = gettext('Новый')

                        $('OPTION[selected="selected"]', $routeSelect).each(function() {
                            $(this).removeAttr('selected');
                        });

                        $('<option value="' + data.id + '">' + self.title + '</option>').appendTo($routeSelect).attr('selected', 'selected' );

                        updateRoute(data);

                        behaviorSelect.enable();
                        behaviorCreating.enable();

                        callback();
                    } else {
                        alert(gettext('Не можем создать мета-рейс') + '\n' + (data.message || ''));
                        errorback();
                    }
                },
                'json'
            ).error(function() {
                    alert(gettext('Не можем создать мета-рейс'));
                    errorback();
                });

        },

        del : function(callback, cancelback, errorback) {
            if(typeof(callback) == 'undefined') { callback = $.noop; }
            if(typeof(cancelback) == 'undefined') { cancelback = $.noop; }
            if(typeof(errorback) == 'undefined') { errorback = cancelback;  }

            $.post('/admin/redmap/route/delete/', { metaroute_id: self.id },
                function (data) {
                    var $current, $next;
                    if(data.status == 'ok') {

                        $current = $('OPTION[value=' + self.id + ']', $routeSelect)
                        $next = $current.next();
                        $current.remove();
                        if($next.length < 1) {
                            $next = $('OPTION:first', $routeSelect);
                        }
                        if($next.length > 0) {
                            route.select($next.val())
                        } else {
                            // Не осталось ни одного рейса
                            window.location.reload()
//                            behaviorSelect.disable();
//                            behaviorCreating.disable();
                        }

                        callback();
                    } else {
                        alert(gettext('Не можем удалить мета-рейс') + '\n' + (data.message || ''));
                        errorback();
                    }
                },
                'json'
            ).error(function() {
                    alert(gettext('Не можем удалить мета-рейс'));
                    errorback();
                });
        },

       clone : function(callback, options) {
            if(typeof(callback) == 'undefined') { callback = $.noop; }
            if(typeof(options) == 'undefined') {
                options = {}
            }

            $.post('/admin/redmap/route/clone/', { 'metaroute_id': self.id, 'reversed': options.reversed },
                    function (data) {
                        if(data.id) {

                            $('OPTION[selected="selected"]', $routeSelect).each(function() {
                                $(this).removeAttr('selected');
                            });

                            $('<option value="' + data.id + '">' + self.number + ' - ' + self.title + '</option>').appendTo($routeSelect).attr('selected', 'selected' );

                            updateRoute(data);

                            callback();
                        } else {
                            alert(gettext('Не можем скопировать мета-рейс') + '\n' + (data.message || ''));
                        }
                    },
                    'json'
                ).error(function() {
                        alert(gettext('Не можем скопировать мета-рейс'));
                    });

        }

    };

    redStations.metaroute = self;

    return self;
}
