include('../rainbow/ajax.js');
include('../rainbow/improvedRelatedObjectLookups.js');
include('../rainbow/ymapsUtils.js');
include('../rainbow/WwwStations.js');
include('../rainbow/StationLayersControl.js');
include('../rainbow/StationZoomControl.js');
include('../rainbow/behaviorInfo.js');
include('ContextMenu.js');

function yaRed(mapSelector, mediaUrl, options) {
    if (!ymaps) {
        throw 'ymaps is required';
    }

    if(options === undefined)
        options = {};

    include('../rainbow/statusBar.js');
    include('../rainbow/Goroda.js');

    var initial = ymapsUtils.getHashParams(),
        packet,
        map,
        statusBar = StatusBar(),
        layersControl = new StationLayersControl(options, mediaUrl),
        busZoomControl = new StationZoomControl(gettext('Автобусы'), 'map_bus_zoom', options),
        pseudoZoomControl = new StationZoomControl(gettext('Псевдо-гортранс'), 'map_pseudo-gortrans_zoom', options),
        route,
        wwwStations,
        behaviorHand, behaviorSelect, behaviorCreating, behaviorGoroda,
        behaviorSelectClickHandler, behaviorCreatingMapClickHandler,
        goroda,
        contextMenu;

    if(initial.route_id) {
        options.route_id = initial.route_id;
    }

    if(initial.center) {
        options.center = initial.center.split(',');
    }

    if(initial.zoom) {
        options.zoom = initial.zoom;
    }

    map = new ymaps.Map(mapSelector, {
        center: options.center || [37.64, 55.76],
        zoom: options.zoom || 10,
        type: "yandex#map",
        behaviors: ["default", "scrollZoom"]
    });

    map.behaviors.disable('dblClickZoom');

    map.controls.add("zoomControl").add("typeSelector").add("scaleLine");

//    map.options.set('dragCursor', 'arrow');

    // --------- переключатели режимов карты ---------
    // режим "лапка"
    behaviorHand = new ymaps.control.mapTools.button.Drag();

    // режим "выбор"
    behaviorSelect = new ymaps.control.Button({data: { content: 'Выбор' }});
    behaviorSelect.disable();
    behaviorSelectClickHandler = function(e, extraParams) {
        var station = extraParams.station;
        extraParams.pme.preventDefault();

        if(station.t_type_id == route.t_type || confirm('Добавить станцию типа ' + options.t_types[station.t_type_id].title + ' к рейсу типа ' + options.t_types[route.t_type].title + '?')) {
            route.addStation(station.id);
        }
    };
    behaviorSelect.events.add('select', function() {
        // Включить режим "Выбор"
        wwwStations.bind('click', behaviorSelectClickHandler);
    });
    behaviorSelect.events.add('deselect', function() {
        // Выключить режим "Выбор"
        wwwStations.unbind('click', behaviorSelectClickHandler);
    });

    // режим "создание"
    behaviorCreating = new ymaps.control.Button({data: { content: 'Создание' }});
    behaviorCreating.disable();
    behaviorCreatingMapClickHandler = function(e) {
//        map.hint.show(e.get('coordPosition'), 'Кто-то щелкнул правой кнопкой');

        if (!map.balloon.isOpen()) {
            var coords = e.get('coordPosition');
            map.balloon.open(coords, {
                contentHeader: 'Создать станцию?',
                contentBody:
                    '<form class="form-new-station">' +
                        '<table>' +

                        '<tr>' +
                            '<td><label for="station-country">Страна:</label></td>' +
                            '<td>' +
                                '<input id="station-country" name="country" class="vForeignKeyRawIdAdminField" value="">' +
                                '<a onclick="return showRelatedObjectLookupPopup(this);" id="lookup_station-country" class="related-lookup" href="/admin/www/country/?t=id"><img width="16" height="16" alt="Lookup" src="/static/admin/img/selector-search.gif"></a>' +
                                '<strong id="station-country-title"></strong>' +
                            '</td>' +
                        '</tr>' +

                        '<tr>' +
                            '<td><label for="station-region">Область:</label></td>' +
                            '<td>' +
                                '<input id="station-region" name="region" class="vForeignKeyRawIdAdminField" value="">' +
                                '<a onclick="return showRelatedObjectLookupPopup(this);" id="lookup_station-region" class="related-lookup" href="/admin/www/region/?t=id"><img width="16" height="16" alt="Lookup" src="/static/admin/img/selector-search.gif"></a>' +
                                '<strong id="station-region-title"></strong>' +
                            '</td>' +
                        '</tr>' +

                        '<tr>' +
                            '<td><label for="station-city">Город:</label></td>' +
                            '<td>' +
                                '<input id="station-city" name="settlement" class="vForeignKeyRawIdAdminField" value="">' +
                                '<a onclick="return showRelatedObjectLookupPopup(this);" id="lookup_station-city" class="related-lookup" href="/admin/www/settlement/?t=id"><img width="16" height="16" alt="Lookup" src="/static/admin/img/selector-search.gif"></a>' +
                                '<strong id="station-city-title"></strong>' +
                            '</td>' +
                        '</tr>' +

                        '<tr>' +
                        '   <td><label for="station-name">Название:</label></td><td><input id="station-name" name="title" value="" /></td>' +
                        '</tr>' +

                        '<tr>' +
                            '<td><label for="station-majority">Важность:</label></td>' +
                            '<td>' +
                                '<select id="station-majority" name=majority>' +
                                    wwwStations.majoritySelectOptions() +
                                '</select>' +
                            '</td>' +
                        '</tr>' +

                        '<tr><td colspan=2 class="ac">' +
                                '<input class="b-new-station-ok" type="button" value="Создать" />' +
                                '<input class="b-new-station-cancel" type="button" value="Отмена" />' +
                            '</td>' +
                        '</tr>' +

                        '</table></form>'
            });
            $('.b-new-station-ok').click(function() {
                var $form = $('.form-new-station');
                map.balloon.close();
                route.createNewStation(
                    $('INPUT[name=country]', $form).val(),
                    $('INPUT[name=region]', $form).val(),
                    $('INPUT[name=settlement]', $form).val(),
                    $('INPUT[name=title]', $form).val(),
                    coords[0],
                    coords[1],
                    $('SELECT[name=majority]', $form).val()
                );
            });
            $('.b-new-station-cancel').click(function() {
                map.balloon.close();
            });
        } else {
            map.balloon.close();
        }

    };
    behaviorCreating.events.add('select', function() {
        // Включить режим "Сознание"
        map.events.add('click', behaviorCreatingMapClickHandler);
    });
    behaviorCreating.events.add('deselect', function() {
        // Выключить режим "Создание"
        map.events.remove('click', behaviorCreatingMapClickHandler);
    });

    // режим "города"
    behaviorGoroda = new ymaps.control.Button({data: { content: 'Города' }});
    behaviorGoroda.events.add('select', function() {
        // Включить режим "Города"
        goroda.open();
    });
    behaviorGoroda.events.add('deselect', function() {
        // Выключить режим "Города"
        goroda.close();
    });

    // Устанавливаем кнопки режимов на карту
    map.controls.add(new ymaps.control.MapTools({
        items: [
            behaviorHand,
            behaviorInfo(map),
            behaviorSelect,
            behaviorCreating,
            behaviorGoroda,
            layersControl.control,
            busZoomControl.control,
            pseudoZoomControl.control
        ]
    }));
    // --------- /переключатели режимов карты ---------

    map.events.add('boundschange', function() {
        var center = map.getCenter();
        ymapsUtils.setHashParams({
            center: '' + center[0] + ',' + center[1],
            zoom: map.getZoom()
        });
        wwwStations.redraw();
    });

    wwwStations = WwwStations(map, mediaUrl, function() {
        return (route && route.t_type) || 3
    }, options, layersControl, [layersControl.events, busZoomControl.events, pseudoZoomControl.events]);

    include('Route.js');

    route = Route();
    goroda = Goroda(map, wwwStations);

    // Настроить первоначальное состояние окна
    if(options.route_id) {
        route.select(options.route_id, { doNotFocuse : (initial.center || initial.zoom) && true || false });
    }

    contextMenu = new ContextMenu(route, behaviorSelect, behaviorCreating);

    function Package() {
        var self,
            saved = true;

        self = {
            id : options['package'].id,
            title : options['package'].title,
//            t_type : options.t_types[options['package'].t_type.id].id,
//            supplier : options['package'].supplier.id,

            save : function(callback, cancelback, errorback) {
                if(typeof(callback) == 'undefined') { callback = $.noop; }
                if(typeof(cancelback) == 'undefined') { cancelback = $.noop; }
                if(typeof(errorback) == 'undefined') { errorback = cancelback;  }
                if(saved) {
                    callback();
                } else {
                    $.post('/admin/redmap/package/save/', {
                            'package_id': self.id,
                            'title': self.title
//                            't_type_id': self.t_type,
//                            'supplier_id': self.supplier
                        },
                        function (data) {
                            if(data.status == 'ok') {
                                saved = true;
                                callback();
                            } else {
                                alert(gettext('Не можем сохранить информацию о пакете'));
                                errorback();
                            }
                        },
                        'json'
                    ).error(function() {
                            alert(gettext('Не можем сохранить информацию о пакете'));
                            errorback();
                    });
                }
            }
        };

        $('SELECT, INPUT', $('.b-control-package FORM.package-info')).change(function() {

            var name = $(this).attr('name'),
                value = $(this).val();

            self[name] = value;
            saved = false;
            self.save();

            if(name == 'title') {
                $('.b-control-package SELECT[name=package] OPTION:selected').html(value);
            }

            if(name == 't_type') {
                layersControl.setTType(value);

                // wwwStations.redraw();
            }

        });

        $('.b-control-package SELECT[name=package]').bind('change', function() {
            var checkedPackageUrl = $('OPTION:selected', $(this)).attr('data-url'),
                $selectPackage = $(this);

            // Установим значения до выбора. На случай, если пользователь откажется уходить со страницы
            if(!route.is_saved()) {
                $('OPTION[selected="selected"]', $selectPackage).each(function() {
                    $(this).removeAttr('selected');
                });
                $('OPTION[value=' + self.id + ']', $selectPackage).attr('selected','selected');
            }

            window.location.href = checkedPackageUrl;

        });

        $('.b-route-create-first').click(function() {
            if(!packet.id || !confirm('Создать рейс ?')) return;
            route.create(packet.id, function() {
                window.location.reload();
            });
        });

        $('.b-route-create').click(function() {
            if (
                packet.id && (
                    route.is_saved() && confirm(gettext('Создать мета-рейс?')) ||
                    !route.is_saved() && confirm(gettext('Изменения не сохранены. Точно создать новый мета-рейс?'))
                )
            ) {
                route.create(packet.id);
            }
        });

        $('.b-route-clone').click(function() {
            if (
                route.id && (
                    route.is_saved() && confirm(gettext('Скопировать мета-рейс?')) ||
                    !route.is_saved() && confirm(gettext('Изменения не сохранены. Точно скопировать мета-рейс?'))
                )
            ) {
                route.clone(function() {alert(gettext('Создана копия рейса'));});
            }
        });

        $('.b-route-clone-reversed').click(function() {
            if (
                route.id && (
                    route.is_saved() && confirm(gettext('Скопировать обратный мета-рейс?')) ||
                    !route.is_saved() && confirm(gettext('Изменения не сохранены. Точно скопировать обратный мета-рейс?'))
                )
            ) {
                route.clone(function() {alert(gettext('Создана копия обратного рейса'));}, {'reversed': true});
            }
        });

        $('.b-route-save').click(function() {
            route.save();
        });

        $('.b-route-delete').click(function() {
            if (!confirm(gettext('Удалить мета-рейс?'))) return;
            route.del(function() {

            }, $.noop, function() {
                alert(gettext('Не можем удалить'));
            });
        });

        $('.f-route-import').submit(function() {
            if(!route.id || !confirm(gettext('Импортировать мета-рейс?'))) {
                return false;
            }
            if(!route.is_saved() && !confirm(gettext('Изменения не сохранены. Продолжить?'))) {
                return false;
            }

            route.set_saved();

            setTimeout(function() {
                // Перезагрузим окно чтобы могли повторно отправлять форму в новом окне
                window.location.reload();
            }, 200);

        });

        $('.f-package-import').submit(function() {
            if(!packet.id || !confirm(gettext('Импортировать пакет?'))) {
                return false;
            }
            if(!route.is_saved() && !confirm(gettext('Изменения не сохранены. Продолжить?'))) {
                return false;
            }

            route.set_saved();

            setTimeout(function() {
                // Перезагрузим окно чтобы могли повторно отправлять форму в новом окне
                window.location.reload();
            }, 200);

        });

        $(window).bind('beforeunload', function() {
            if(!route.is_saved()) {
                return gettext('Изменения не сохранены. Точно уйти?');
            }
        });

        return self;
    }

    $('#body_wrapper').resize(function() {
        map.container.fitToViewport();
    });

    if(options['package']) {
        packet = Package();
    }

    wwwStations.redraw();

}

function mapPageFixBodyHeight() {
    $('#body_wrapper').css('top', ($('#head').outerHeight(true)) + 'px')
        .resize();
}
