# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
from travel.avia.library.python.common.utils.fields import TrimmedCharField


class Migration(migrations.Migration):

    dependencies = [
        ('www', '__first__'),
        ('order', '__first__'),
    ]

    operations = [
        migrations.CreateModel(
            name='Partner',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('services', models.CharField(default=b'rasp', max_length=10, verbose_name='\u0441\u0435\u0440\u0432\u0438\u0441\u044b', choices=[(b'both', '\u0412\u0441\u0435 \u0441\u0435\u0440\u0432\u0438\u0441\u044b'), (b'rasp', '\u041f\u043e\u0441\u0442\u0440\u043e\u0438\u0442\u044c \u043c\u0430\u0440\u0448\u0440\u0443\u0442'), (b'ticket', '\u041a\u0443\u043f\u0438\u0442\u044c \u0431\u0438\u043b\u0435\u0442')])),  # noqa
                ('url', models.URLField(null=True, verbose_name='uRL', blank=True)),
                ('logo', models.FileField(default=None, upload_to=b'data/partners', verbose_name='\u043b\u043e\u0433\u043e\u0442\u0438\u043f')),
                ('order', models.PositiveIntegerField(default=100, verbose_name='\u043f\u043e\u0440\u044f\u0434\u043e\u043a')),
                ('is_published', models.BooleanField(default=False, verbose_name='\u043e\u043f\u0443\u0431\u043b\u0438\u043a\u043e\u0432\u0430\u043d\u043e')),
                ('national_version', models.CharField(default=b'ru', max_length=25, verbose_name='\u041d\u0430\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u0430\u044f \u0432\u0435\u0440\u0441\u0438\u044f', choices=[(b'ru', b'ru'), (b'ua', b'ua'), (b'tr', b'tr'), (b'com', b'com')])),  # noqa
                ('title', TrimmedCharField(default=None, max_length=50, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435', blank=True)),
                ('title_ru', TrimmedCharField(default=None, max_length=50, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (ru)', blank=True)),
                ('title_en', TrimmedCharField(default=None, max_length=50, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (en)', blank=True)),
                ('title_tr', TrimmedCharField(default=None, max_length=50, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (tr)', blank=True)),
                ('title_uk', TrimmedCharField(default=None, max_length=50, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (uk)', blank=True)),
                ('content', models.TextField(default=None, verbose_name='\u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435', blank=True)),
                ('content_ru', models.TextField(default=None, verbose_name='\u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 (ru)', blank=True)),
                ('content_en', models.TextField(default=None, verbose_name='\u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 (en)', blank=True)),
                ('content_tr', models.TextField(default=None, verbose_name='\u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 (tr)', blank=True)),
                ('content_uk', models.TextField(default=None, verbose_name='\u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 (uk)', blank=True)),
                ('dohop_vendor', models.ForeignKey(related_name='staticpages_partners', verbose_name='\u041f\u0430\u0440\u0442\u043d\u0451\u0440 \u0432 \u0434\u0435\u043c\u043e\u043d\u0435 (\u0412\u0435\u043d\u0434\u043e\u0440 \u0434\u043e\u0445\u043e\u043f\u0430)', blank=True, to='order.DohopVendor', null=True)),  # noqa
                ('order_partner', models.ForeignKey(related_name='staticpages_partners', verbose_name='\u041f\u0430\u0440\u0442\u043d\u0451\u0440 \u0432 \u0434\u0435\u043c\u043e\u043d\u0435', blank=True, to='order.Partner', null=True)),  # noqa
                ('t_type', models.ForeignKey(verbose_name='\u0442\u0438\u043f \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430', blank=True, to='www.TransportType', null=True)),
            ],
            options={
                'ordering': ('order', 'title'),
                'verbose_name': '\u043f\u0430\u0440\u0442\u043d\u0435\u0440',
                'verbose_name_plural': '\u043f\u0430\u0440\u0442\u043d\u0435\u0440\u044b',
            },
        ),
        migrations.CreateModel(
            name='StaticLink',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=100, verbose_name='\u0442\u0435\u043a\u0441\u0442 \u0441\u0441\u044b\u043b\u043a\u0438')),
                ('url', models.CharField(max_length=100, verbose_name='\u0443\u0440\u043b')),
                ('order', models.PositiveIntegerField(verbose_name='\u043f\u043e\u0440\u044f\u0434\u043e\u043a')),
            ],
            options={
                'ordering': ('order',),
                'verbose_name': '\u0441\u0441\u044b\u043b\u043a\u0430 \u0441\u0442\u0430\u0442. \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b',
                'verbose_name_plural': '\u0441\u0441\u044b\u043b\u043a\u0438',
            },
        ),
        migrations.CreateModel(
            name='StaticPage',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('slug', models.CharField(max_length=200, null=True, verbose_name='\u043a\u043e\u0434', blank=True)),
                ('is_published', models.IntegerField(default=0, verbose_name='\u043e\u043f\u0443\u0431\u043b\u0438\u043a\u043e\u0432\u0430\u043d\u043e', choices=[(0, '\u0421\u043a\u0440\u044b\u0442\u0430'), (1, '\u041e\u043f\u0443\u0431\u043b\u0438\u043a\u043e\u0432\u0430\u043d\u0430'), (2, '\u0423\u0441\u0442\u0430\u0440\u0435\u043b\u0430')])),  # noqa
                ('template', models.CharField(help_text='\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440 "yandex_dengi.html"', max_length=200, null=True, verbose_name='\u0444\u0430\u0439\u043b \u0448\u0430\u0431\u043b\u043e\u043d\u0430', blank=True)),  # noqa
                ('order', models.IntegerField(default=0, verbose_name='\u043f\u043e\u0440\u044f\u0434\u043e\u043a')),
                ('materialized_path', models.CharField(default=b'', max_length=200, blank=True, help_text='materialized path', null=True, verbose_name='\u0440\u043e\u0434\u0438\u0442\u0435\u043b\u0438')),  # noqa
                ('type', models.CharField(default=b'page', max_length=10, choices=[(b'page', '\u041e\u0431\u044b\u0447\u043d\u0430\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430'), (b'template', 'Jinja \u0448\u0430\u0431\u043b\u043e\u043d'), (b'link', '\u0421\u0441\u044b\u043b\u043a\u0430 \u043d\u0430 \u0432\u043d\u0435\u0448\u043d\u044e\u044e \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0443'), (b'geo', '\u0421\u0442\u0440\u0430\u043d\u0438\u0446\u0430 \u0441\u0442\u0440\u0430\u043d'), (b'carrier', '\u0421\u0442\u0440\u0430\u043d\u0438\u0446\u0430 \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a\u043e\u0432 \u043f\u043e \u0441\u0442\u0440\u0430\u043d\u0430\u043c'), (b'transport', '\u0421\u0442\u0440\u0430\u043d\u0438\u0446\u0430 \u0442\u0438\u043f\u043e\u0432 \u0422\u0421')])),  # noqa
                ('is_ticket_page', models.BooleanField(default=False, verbose_name='\u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430 \u0438\u0437 \u041a\u0411?')),
                ('national_version', models.CharField(default=b'ru', max_length=25, verbose_name='\u041d\u0430\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u0430\u044f \u0432\u0435\u0440\u0441\u0438\u044f', choices=[(b'ru', b'ru'), (b'ua', b'ua'), (b'tr', b'tr')])),  # noqa
                ('title', TrimmedCharField(default=None, max_length=200, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435', blank=True)),
                ('title_ru', TrimmedCharField(default=None, max_length=200, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (ru)', blank=True)),
                ('title_en', TrimmedCharField(default=None, max_length=200, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (en)', blank=True)),
                ('title_tr', TrimmedCharField(default=None, max_length=200, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (tr)', blank=True)),
                ('title_uk', TrimmedCharField(default=None, max_length=200, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (uk)', blank=True)),
                ('content', models.TextField(default=None, null=True, verbose_name='\u0441\u043e\u0434\u0435\u0440\u0436\u0430\u043d\u0438\u0435', blank=True)),
                ('content_ru', models.TextField(default=None, null=True, verbose_name='\u0441\u043e\u0434\u0435\u0440\u0436\u0430\u043d\u0438\u0435 (ru)', blank=True)),
                ('content_en', models.TextField(default=None, null=True, verbose_name='\u0441\u043e\u0434\u0435\u0440\u0436\u0430\u043d\u0438\u0435 (en)', blank=True)),
                ('content_tr', models.TextField(default=None, null=True, verbose_name='\u0441\u043e\u0434\u0435\u0440\u0436\u0430\u043d\u0438\u0435 (tr)', blank=True)),
                ('content_uk', models.TextField(default=None, null=True, verbose_name='\u0441\u043e\u0434\u0435\u0440\u0436\u0430\u043d\u0438\u0435 (uk)', blank=True)),
                ('meta_description', models.TextField(default=None, null=True, verbose_name='meta description \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b', blank=True)),
                ('meta_description_ru', models.TextField(default=None, null=True, verbose_name='meta description \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b (ru)', blank=True)),
                ('meta_description_en', models.TextField(default=None, null=True, verbose_name='meta description \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b (en)', blank=True)),
                ('meta_description_tr', models.TextField(default=None, null=True, verbose_name='meta description \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b (tr)', blank=True)),
                ('meta_description_uk', models.TextField(default=None, null=True, verbose_name='meta description \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b (uk)', blank=True)),
                ('meta_title', TrimmedCharField(default=None, max_length=255, null=True, verbose_name='title \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b', blank=True)),
                ('meta_title_ru', TrimmedCharField(default=None, max_length=255, null=True, verbose_name='title \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b (ru)', blank=True)),  # noqa
                ('meta_title_en', TrimmedCharField(default=None, max_length=255, null=True, verbose_name='title \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b (en)', blank=True)),  # noqa
                ('meta_title_tr', TrimmedCharField(default=None, max_length=255, null=True, verbose_name='title \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b (tr)', blank=True)),  # noqa
                ('meta_title_uk', TrimmedCharField(default=None, max_length=255, null=True, verbose_name='title \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b (uk)', blank=True)),  # noqa
                ('parent', models.ForeignKey(verbose_name='\u0440\u043e\u0434\u0438\u0442\u0435\u043b\u044c', blank=True, to='staticpages.StaticPage', null=True)),
            ],
            options={
                'ordering': ('materialized_path',),
                'verbose_name': '\u0441\u0442\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430',
                'verbose_name_plural': '\u0441\u0442\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b',
            },
        ),
        migrations.CreateModel(
            name='StaticText',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('code', models.CharField(unique=True, max_length=150, verbose_name='\u043a\u043e\u0434')),
                ('title', models.CharField(help_text='\u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0435\u0442\u0441\u044f \u0442\u043e\u043b\u044c\u043a\u043e \u0432 \u0430\u0434\u043c\u0438\u043d\u043a\u0435', max_length=100, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435')),  # noqa
                ('content', models.TextField(verbose_name='\u0442\u0435\u043a\u0441\u0442')),
                ('announce_ru', models.TextField(null=True, verbose_name='\u0430\u043d\u043e\u043d\u0441 \u043d\u0430 \u0440\u0443\u0441\u0441\u043a\u043e\u043c', blank=True)),
                ('announce_be', models.TextField(null=True, verbose_name='\u0430\u043d\u043e\u043d\u0441 \u043d\u0430 \u0431\u0435\u043b\u043e\u0440\u0443\u0441\u0441\u043a\u043e\u043c', blank=True)),
                ('announce_kk', models.TextField(null=True, verbose_name='\u0430\u043d\u043e\u043d\u0441 \u043d\u0430 \u043a\u0430\u0437\u0430\u0445\u0441\u043a\u043e\u043c', blank=True)),
                ('announce_tt', models.TextField(null=True, verbose_name='\u0430\u043d\u043e\u043d\u0441 \u043d\u0430 \u0442\u0430\u0442\u0430\u0440\u0441\u043a\u043e\u043c', blank=True)),
                ('announce_uk', models.TextField(null=True, verbose_name='\u0430\u043d\u043e\u043d\u0441 \u043d\u0430 \u0443\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u043e\u043c', blank=True)),
                ('announce_en', models.TextField(null=True, verbose_name='\u0430\u043d\u043e\u043d\u0441 \u043d\u0430 \u0430\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u043e\u043c', blank=True)),
                ('announce_tr', models.TextField(null=True, verbose_name='\u0430\u043d\u043e\u043d\u0441 \u043d\u0430 \u0442\u0443\u0440\u0435\u0446\u043a\u043e\u043c', blank=True)),
                ('content_ru', models.TextField(null=True, verbose_name='\u0442\u0435\u043a\u0441\u0442 \u043d\u0430 \u0440\u0443\u0441\u0441\u043a\u043e\u043c', blank=True)),
                ('content_be', models.TextField(null=True, verbose_name='\u0442\u0435\u043a\u0441\u0442 \u043d\u0430 \u0431\u0435\u043b\u043e\u0440\u0443\u0441\u0441\u043a\u043e\u043c', blank=True)),
                ('content_kk', models.TextField(null=True, verbose_name='\u0442\u0435\u043a\u0441\u0442 \u043d\u0430 \u043a\u0430\u0437\u0430\u0445\u0441\u043a\u043e\u043c', blank=True)),
                ('content_tt', models.TextField(null=True, verbose_name='\u0442\u0435\u043a\u0441\u0442 \u043d\u0430 \u0442\u0430\u0442\u0430\u0440\u0441\u043a\u043e\u043c', blank=True)),
                ('content_uk', models.TextField(null=True, verbose_name='\u0442\u0435\u043a\u0441\u0442 \u043d\u0430 \u0443\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u043e\u043c', blank=True)),
                ('content_en', models.TextField(null=True, verbose_name='\u0442\u0435\u043a\u0441\u0442 \u043d\u0430 \u0430\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u043e\u043c', blank=True)),
                ('content_tr', models.TextField(null=True, verbose_name='\u0442\u0435\u043a\u0441\u0442 \u043d\u0430 \u0442\u0443\u0440\u0435\u0446\u043a\u043e\u043c', blank=True)),
                ('sample_url', models.CharField(help_text='\u0433\u0434\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f', max_length=100, null=True, verbose_name='\u043f\u0440\u0438\u043c\u0435\u0440 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b', blank=True)),  # noqa
                ('is_mobile', models.BooleanField(default=False, verbose_name='\u0434\u043b\u044f \u043c\u043e\u0431\u0438\u043b\u044c\u043d\u043e\u0439 \u0432\u0435\u0440\u0441\u0438\u0438?')),
            ],
            options={
                'verbose_name': '\u0442\u0435\u043a\u0441\u0442',
                'verbose_name_plural': '\u0442\u0435\u043a\u0441\u0442\u044b',
            },
        ),
        migrations.AddField(
            model_name='staticlink',
            name='page',
            field=models.ForeignKey(verbose_name='\u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430', to='staticpages.StaticPage'),
        ),
    ]
