# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
import datetime
from travel.avia.library.python.common.utils.fields import CodeCharField, RegExpField


class Migration(migrations.Migration):

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='CacheDirection',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.TextField(verbose_name='\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435')),
                ('point_from_key', CodeCharField(max_length=100, verbose_name='\u0422\u043e\u0447\u043a\u0430 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f')),
                ('point_to_key', CodeCharField(max_length=100, verbose_name='\u0422\u043e\u0447\u043a\u0430 \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f')),
                ('alt_link', models.TextField(verbose_name='\u0410\u043b\u044c\u0442\u0435\u0440\u043d\u0430\u0442\u0438\u0432\u043d\u044b\u0435 \u0432\u0430\u0440\u0438\u0430\u043d\u0442\u044b')),
                ('data', models.TextField(verbose_name='\u0414\u0430\u043d\u043d\u044b\u0435')),
                ('partner_code', models.CharField(default=b'ufs', max_length=10, verbose_name='\u043f\u0430\u0440\u0442\u043d\u0451\u0440', choices=[(b'ufs', '\u0423\u0424\u0421'), (b'tickets_ua', 'Tickets UA')])),  # noqa
            ],
            options={
                'verbose_name': '\u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043d\u0430 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435 \u043d\u0430\u043b\u0438\u0447\u0438\u044f \u0441\u0432\u043e\u0431\u043e\u0434\u043d\u044b\u0445 \u0431\u0438\u043b\u0435\u0442\u043e\u0432',  # noqa
                'verbose_name_plural': '\u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043d\u0430 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435 \u043d\u0430\u043b\u0438\u0447\u0438\u044f \u0441\u0432\u043e\u0431\u043e\u0434\u043d\u044b\u0445 \u0431\u0438\u043b\u0435\u0442\u043e\u0432',  # noqa
            },
        ),
        migrations.CreateModel(
            name='CacheSet',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.TextField(default=b'', verbose_name='\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a')),
                ('date1', models.DateField(default=datetime.date.today, verbose_name='\u0414\u0430\u0442\u0430 1')),
                ('date2', models.DateField(default=datetime.date.today, verbose_name='\u0414\u0430\u0442\u0430 2')),
                ('date3', models.DateField(default=datetime.date.today, verbose_name='\u0414\u0430\u0442\u0430 3')),
                ('sort_order', models.IntegerField(default=65535, verbose_name='\u041f\u043e\u0440\u044f\u0434\u043e\u043a \u0434\u043b\u044f \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0438')),  # noqa
            ],
            options={
                'ordering': ['sort_order', 'date1', 'date2', 'date3'],
                'verbose_name': '\u0431\u043b\u043e\u043a \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0439',
                'verbose_name_plural': '\u0431\u043b\u043e\u043a\u0438 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0439',
            },
        ),
        migrations.CreateModel(
            name='SkyExpressFuelSurcharge',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('iata_from', CodeCharField(max_length=10, verbose_name='\u0418\u0410\u0422\u0410 \u043a\u043e\u0434 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f')),  # noqa
                ('iata_to', CodeCharField(max_length=10, verbose_name='\u0418\u0410\u0422\u0410 \u043a\u043e\u0434 \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f')),  # noqa
                ('surcharge', models.FloatField(verbose_name='\u0442\u043e\u043f\u043b\u0438\u0432\u043d\u044b\u0439 \u0441\u0431\u043e\u0440')),
            ],
            options={
                'verbose_name': '\u0442\u043e\u043f\u043b\u0438\u0432\u043d\u044b\u0439 c\u0431\u043e\u0440 \u0421\u043a\u0430\u0439\u042d\u043a\u0441\u043f\u0440\u0435\u0441\u0441\u0430',  # noqa
                'verbose_name_plural': '\u0442\u043e\u043f\u043b\u0438\u0432\u043d\u044b\u0435 \u0441\u0431\u043e\u0440\u044b \u0421\u043a\u0430\u0439\u042d\u043a\u0441\u043f\u0440\u0435\u0441\u0441\u0430',  # noqa
            },
        ),
        migrations.CreateModel(
            name='TCHDirection',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('iata_from', CodeCharField(max_length=10, verbose_name='\u0438\u0410\u0422\u0410 \u043a\u043e\u0434 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f')),  # noqa
                ('iata_to', CodeCharField(max_length=10, verbose_name='\u0438\u0410\u0422\u0410 \u043a\u043e\u0434 \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f')),  # noqa
            ],
            options={
                'verbose_name': '\u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u0435\u043c\u043e\u0435 TCH',  # noqa
                'verbose_name_plural': '\u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0434\u043b\u044f TCH',
            },
        ),
        migrations.CreateModel(
            name='UFSDepthOfSales',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('number', RegExpField(help_text='\u043d\u043e\u043c\u0435\u0440 \u0440\u0435\u0439\u0441\u0430 \u043c\u043e\u0436\u043d\u043e \u0437\u0430\u0434\u0430\u0432\u0430\u0442\u044c \u0440\u0435\u0433\u0443\u043b\u044f\u0440\u044b\u043c \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435\u043c', unique=True, max_length=255, verbose_name='\u043d\u043e\u043c\u0435\u0440 \u0440\u0435\u0439\u0441\u0430')),  # noqa
                ('days_ahead', models.IntegerField(default=60, help_text='\u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0434\u043d\u0435\u0439 \u0432\u043f\u0435\u0440\u0435\u0434 \u043d\u0430 \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0430 \u043f\u0440\u043e\u0434\u0430\u0436\u0430', verbose_name='\u0433\u043b\u0443\u0431\u0438\u043d\u0430 \u043f\u0440\u043e\u0434\u0430\u0436\u0438')),  # noqa
            ],
            options={
                'verbose_name': '\u0413\u043b\u0443\u0431\u0438\u043d\u0430 \u043f\u0440\u043e\u0434\u0430\u0436\u0438 \u0431\u0438\u043b\u0435\u0442\u043e\u0432 \u0434\u043b\u044f \u0440\u0435\u0439\u0441\u0430 UFS',  # noqa
                'verbose_name_plural': '\u0413\u043b\u0443\u0431\u0438\u043d\u0430 \u043f\u0440\u043e\u0434\u0430\u0436\u0438 \u0431\u0438\u043b\u0435\u0442\u043e\u0432 \u0434\u043b\u044f \u0440\u0435\u0439\u0441\u043e\u0432 UFS',  # noqa
            },
        ),
        migrations.CreateModel(
            name='UFSDirectionDaysAhead',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('from_express_code', CodeCharField(max_length=50)),
                ('to_express_code', CodeCharField(max_length=50)),
                ('days_ahead', models.IntegerField()),
            ],
        ),
        migrations.AlterUniqueTogether(
            name='ufsdirectiondaysahead',
            unique_together=set([('from_express_code', 'to_express_code')]),
        ),
        migrations.AlterUniqueTogether(
            name='tchdirection',
            unique_together=set([('iata_from', 'iata_to')]),
        ),
        migrations.AlterUniqueTogether(
            name='skyexpressfuelsurcharge',
            unique_together=set([('iata_from', 'iata_to')]),
        ),
        migrations.AddField(
            model_name='cachedirection',
            name='set',
            field=models.ForeignKey(related_name='directions', to='tariffs.CacheSet'),
        ),
    ]
