PY2TEST()

OWNER(g:avia)

PEERDIR(
    travel/avia/library/python/tester
    travel/avia/admin

    library/python/resource

    travel/library/python/dicts/factories

    contrib/python/pyfakefs
)

IF(NOT SKIP_TESTS_RECIPE)
    INCLUDE(${ARCADIA_ROOT}/travel/avia/library/python/recipe/recipe.inc)
ENDIF()

IF(NOT SKIP_YT_RECIPE)
    INCLUDE(${ARCADIA_ROOT}/mapreduce/yt/python/recipe/recipe.inc)
ENDIF()

PY_SRCS(
    conftest.py
    tests_settings.py

    lib/unittests/__init__.py
    lib/unittests/check_thread_mixin.py
    lib/unittests/server.py
    lib/unittests/testcase.py
    lib/unittests/utils.py
)

TEST_SRCS(
    admin/avia/management/test_update_company_colors.py

    lib/script_helpers/mail_senders/test_fail_script_mail_sender.py
    lib/script_helpers/mail_senders/test_script_reports_mail_sender.py

    lib/script_helpers/test_environment_detector.py
    lib/script_helpers/test_script_reporter.py
    lib/script_helpers/test_script_result_cleaner.py
    lib/script_helpers/test_script_run_logger_factory.py
    lib/script_helpers/test_script_runner.py

    lib/test_airline_popular_score_updater.py
    lib/test_balance.py
    lib/test_coverage.py
    lib/test_exception.py
    lib/test_exporters_for_stat_admin.py
    lib/test_fileutils.py
    lib/test_iterators.py
    lib/test_mysqlutils.py
    lib/test_partner_mail_sender.py
    lib/test_popular_partners_builder.py
    lib/test_processes.py

    scripts/utils/action_list.py

    avia_scripts/conversions/test_booking_yql.py
    avia_scripts/conversions/test_intervals.py
    avia_scripts/conversions/test_update_conversions.py
    avia_scripts/sync_with_rasp/test_sync_currency_currency.py
    avia_scripts/sync_with_rasp/test_sync_www_aviaalliance.py
    avia_scripts/sync_with_rasp/test_sync_www_company.py
    avia_scripts/sync_with_rasp/test_sync_www_country.py
    avia_scripts/sync_with_rasp/test_sync_www_pointsynonym.py
    avia_scripts/sync_with_rasp/test_sync_www_region.py
    avia_scripts/sync_with_rasp/test_sync_www_settlement.py
    avia_scripts/sync_with_rasp/test_sync_www_station.py
    avia_scripts/test_build_yt_reference.py
    avia_scripts/test_update_avg_check_coeff.py
    avia_scripts/test_update_heater_conf.py

    lib/test_arcadia.py
    lib/test_feature_flags.py
    lib/test_lock.py
    lib/test_logs.py

    scripts/export/test_gen_t_types_by_geoid_for_mobile_morda.py
    scripts/test_update_geobase.py

    test_atomic_rollback.py

    www/test_mysql.py
)


RESOURCE(
    lib/script_helpers/data/script_reporter_data.json lib/script_helpers/data/script_reporter_data.json
)

NO_CHECK_IMPORTS()  # do not pass because of django

SIZE(MEDIUM)

END()
