#!/bin/bash

LANGUAGES="ru uk be kk tt"

babelcfg=$(dirname $(readlink -f $0))/babel.cfg
compilejstemplate=$(dirname $(readlink -f $0))/compile_template.js

function build-js-templates {
    for jstemplate_dir in $(find . -name "jstemplates" -type d)
    do
        for f in $(find "$jstemplate_dir" -name "*.html" -type f)
        do
            echo Compile js template $f
            nodejs $compilejstemplate $f
        done
    done
}

function remove-js-templates {
    echo
    echo Removing compiled js-templates
    find . -name "__*.html.js" -delete -print
}

function extract {
    languages="$1"
    localedir="$2"
    shift 2

    echo Languages: $languages
    echo Locale dir: $localedir
    echo Dirs: "$@"

    build-js-templates

    mkdir -p $localedir

    PYTHONPATH="$PYTHONPATH:./contrib/" pybabel extract -F $babelcfg --sort-output -o $localedir/django.pot "$@"

    for lang in $LANGUAGES; do
        if [ ! -d $localedir/$lang/LC_MESSAGES/django.po ]; then
            pybabel init -D django -i $localedir/django.pot -d $localedir -l $lang
        fi
    done

    pybabel update --no-fuzzy-matching -D django -i $localedir/django.pot -d $localedir

    remove-js-templates
}

extract "ru en" admin/locale admin currency filebrowser importinfo order tariffs www staticpages cysix common/models
