# -*- coding: utf-8 -*-

from django.conf import settings
from django.conf.urls import url, include
from django.conf.urls.static import static

from travel.avia.admin.www.views import django_ping, logtail, version, exception

urlpatterns = [
    url(r'^marker/', include('travel.avia.admin.marker_callback.urls')),
    url(r'^(?:django/)?ping', django_ping),

    url(r'^version$', version),
    url(r'^exception$', exception),

    url(r'^admin/maintenance/logtail/(?P<path>[\w\-./]+)$', logtail),

    url(r'^admin/', include('travel.avia.admin.admin.urls')),
    url(r'^dostup/', include('django_idm_api.urls')),
    url(r'^partners/', include('travel.avia.admin.partners.urls')),

    url(r'^feature_flag_app/', include('travel.avia.admin.feature_flag_app.urls')),

    url(r'^', include('travel.avia.admin.admin.urls')),
]

if settings.SERVE_STATIC_BY_GUNICORN:
    urlpatterns += static(settings.STATIC_URL, document_root=settings.STATIC_ROOT)
    urlpatterns += static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)
