# -*- coding: utf-8 -*-

import warnings
warnings.filterwarnings("ignore", r'^Module .*? was already imported from.*', UserWarning)


from raven.contrib.django.raven_compat.middleware.wsgi import Sentry
from django.core.wsgi import get_wsgi_application


application = get_wsgi_application()


from django.conf import settings


# Sentry
if getattr(settings, 'RAVEN_CONFIG', False):
    application = Sentry(application)


# Werkzeug debugger
if getattr(settings, 'USE_WERKZEUG', False):
    try:
        from werkzeug.debug import DebuggedApplication

        settings.DEBUG_PROPAGATE_EXCEPTIONS = True

        application = DebuggedApplication(application, evalex=True)
    except ImportError:
        pass
