# -*- coding: utf-8 -*-
try:
    #
    from django.conf import settings
    DEBUG_SQL_STACK = getattr(settings, 'DEBUG_SQL_STACK', False)
except Exception:
    DEBUG_SQL_STACK = None


if DEBUG_SQL_STACK:
    from time import time
    import traceback
    from django.db.backends import util

    class TracingCursorDebugWrapper(util.CursorDebugWrapper):
        def trace_entry(self, sql, start):
            stop = time()
            entry = {
                'sql': sql,
                'time': "%.5f" % (stop - start),
                'stack': traceback.format_stack()[:-2],
            }
            self.db.queries.append(entry)

        def execute(self, sql, params=()):
            start = time()
            try:
                return self.cursor.execute(sql, params)
            finally:
                sql = self.db.ops.last_executed_query(self.cursor, sql, params)
                self.trace_entry(sql, start)

        def executemany(self, sql, param_list):
            start = time()
            try:
                return self.cursor.executemany(sql, param_list)
            finally:
                sql = '%s times: %s' % (len(param_list), sql)
                self.trace_entry(sql, start)

    util.CursorDebugWrapper = TracingCursorDebugWrapper
