# -*- coding: utf-8 -*-

from travel.avia.admin.xgettext.i18n import mark_gettext, dynamic_gettext


# Разметка для выгрузки в танкер
GENDER_MARK = [
    # Однобуквенное сокращение "мужской"
    mark_gettext(u"м", key='male-short'),
    # Однобуквенное сокращение "женский"
    mark_gettext(u"ж", key='female-short'),
    # Однобуквенное сокращение "мужской и женский"
    mark_gettext(u"МЖ", key='male-female-short')
]

GENDER_MAP = {
    'm': 'male',
    'f': 'female',
    'MF': 'male-female'
}


def get_gender_short(key):
    """
    Возвращает сокращение для "мужчина" и "женщина" для текущего языка.

    Пример:
    'м' = get_gender_short('m')
    'ж' = get_gender_short('f')
    'МЖ' = get_gender_short('MF')
    """

    return dynamic_gettext("%s-short" % GENDER_MAP[key])
