# -*- coding: utf-8 -*-
import logging


LOGGING_VERBOSITY = {
    0: None,
    1: logging.ERROR,
    2: logging.INFO,
    3: logging.DEBUG,
}


class FilterLevelLessThan(logging.Filter):
    def __init__(self, level):
        self._level = level

    def filter(self, record):
        return int(record.levelno < self._level)


def setup_logger_verbosity(log, verbosity, stdout, stderr):
    log_level = LOGGING_VERBOSITY.get(verbosity)
    if log_level is None:
        return

    h = logging.StreamHandler(stderr)
    h.setLevel(max(log_level, logging.ERROR))
    log.addHandler(h)

    h = logging.StreamHandler(stdout)
    h.setLevel(log_level)
    h.addFilter(FilterLevelLessThan(logging.ERROR))
    log.addHandler(h)
