# -*- coding: utf-8 -*-

import logging

from django.core.management import call_command
from django.core.management.base import BaseCommand

from travel.avia.admin.lib.logs import create_run_log, print_log_to_stdout


log = logging.getLogger(__name__)


FIXTURES = [
    'www_translatedtitle.json',
    'www_citymajority.json',
    'www_codesystem.json',
    'www_transporttype.json',
    'www_stationmajority.json',
    'www_stationtype.json',
    'www_rthreadtype.json',
    'www_country.json',
    'www_region.json',
    'www_settlement.json',
    'maintenance_flag.json',
]


# Наследуем, чтобы обработались все аргументы
class Command(BaseCommand):
    def handle(self, *args, **kwargs):
        create_run_log('special.management_runs.' + __name__)

        if int(kwargs.get('verbosity', 0)) > 0:
            print_log_to_stdout()

        # FIXME: Нужно сделать умную обработку, и удалять базу если пользователь согласен
        log.info(u'Внимание! Если таблицы в базе уже есть, ее лучше пересоздать.')
        log.info(u'Создаем базу')
        # Нужна команды именно из south
        # с параметром --noinput подчистит на агентах django_content_type
        call_command('migrate', '--noinput', verbosity=kwargs.get('verbosity', 1))

        log.info(u'Загружаем фикстуры')

        for fixture in FIXTURES:
            log.info(u'Загружаем %s', fixture)
            call_command('loaddata', fixture, verbosity=kwargs.get('verbosity', 1))

        log.info(u'Готово')
