# -*- coding: utf-8 -*-
import logging

from django.core.management import call_command
from django.core.management.base import BaseCommand

from travel.avia.admin.lib.logs import create_run_log, print_log_to_stdout


log = logging.getLogger(__name__)


class Command(BaseCommand):
    help = u'''
    Команда для обновления реальной базы или копии реальной базы.
    Для других случаев лучше использовать обычный migrate.
    '''

    def add_arguments(self, parser):
        parser.add_argument('--ignore-flag', action='store_true', default=False)

    def handle(self, verbosity=0, **kwargs):
        create_run_log('special.management_runs.' + __name__)

        if verbosity > 0:
            print_log_to_stdout()

        log.info(u"Начинаем миграцию")

        # Джанга использует этот параметр внутри при миграциях, он должен быть заполнен
        # Чтобы фиксить по честному, нужно перерабатывать mysql_switcher или обновляться на 1.9
        # В 1.9 это решено на уровне django.
        # https://github.com/django/django/commit/65aa94200b3d10d515b15a78898c3692cd57e6c7
        from django.db import connection
        connection.settings_dict['NAME'] = connection.get_connection_params()['db']

        try:
            call_command('migrate', verbosity=verbosity, interactive=False, traceback=True)

            log.info(u"Миграция прошла успешно")

        except BaseException:
            log.exception(u"Возникла ошибка при миграции")
            raise
