import os
import codecs

from django.core.management.base import NoArgsCommand
from django.conf import settings

import json
from travel.avia.admin.xgettext._common import get_common_keyset


TRANSLATIONS_TEMPLATE = u'''
// Autogenerated by manage.py update_i_time_translations . do not edit!

(function() {

var daysTranslations = %(days)s,

    monthsTranslations = %(months)s;

daysTranslations.getList = monthsTranslations.getList = function(lang, type) {
    var i = 1,
        translation,
        result = [];

    while(translation = this.get(lang, type + i.toString())) {
        result.push(translation);
        i++;
    }

    return result;
};

daysTranslations.getLowerCaseList = monthsTranslations.getLowerCaseList = function(lang, type) {
    var i = 1,
        translation,
        result = [];

    while(translation = this.get(lang, type + i.toString())) {
        result.push(translation.toLowerCase());
        i++;
    }

    return result;
};

daysTranslations.get = function(lang, key) {
    return this[lang].days[key];
};

monthsTranslations.get = function(lang, key) {
    return this[lang].months[key];
};

BEM.DOM.decl('i-time-translations', {}, {
    daysTranslations: daysTranslations,

    monthsTranslations: monthsTranslations
});

})();

'''.strip()


class Command(NoArgsCommand):
    def handle_noargs(self, **options):
        with codecs.open(
                os.path.join(settings.PROJECT_PATH, 'markup', 'blocks-desktop', 'i-time-translations',
                             'i-time-translations.js'),
                'w', encoding='utf-8'
        ) as trasnlations_js:

            output = TRANSLATIONS_TEMPLATE % dict(
                days=json.dumps(get_common_keyset('days'), encoding='utf-8', ensure_ascii=False),
                months=json.dumps(get_common_keyset('months'), encoding='utf-8', ensure_ascii=False)
            )

            trasnlations_js.write(output)
