# -*- coding: utf-8 -*-
import os
import random
import subprocess
import tempfile
import requests
from contextlib import contextmanager

from django.conf import settings
from django.core.management import BaseCommand


class Command(BaseCommand):
    def add_arguments(self, parser):
        parser.add_argument('local_db')
        parser.add_argument('tables',  nargs='*')

    def get_random_dev_slave(self):
        r = requests.get('https://c.yandex-team.ru/api/groups2hosts/avia_db_mysql_main_dev')
        hosts = r.content.strip().split('\n')

        return random.choice(hosts)

    def ssh_execute(self, shell_cmd):
        self.stdout.write('Execute: %s' % shell_cmd)
        try:
            output = subprocess.check_output(
                shell_cmd,
                stderr=subprocess.STDOUT,
                shell=True
            )

            # если что-то случилось в первых частях pipe
            if output:
                self.stdout.write(output.decode('utf-8'))

        except subprocess.CalledProcessError as e:
            self.stdout.write(e.output)
            raise e

    def copy_mysql_database(self, local_db, tables):
        local_db_user = settings.DATABASES['default']['USER']
        local_db_pass = settings.DATABASES['default']['PASSWORD']
        local_db_host = settings.DATABASES['default']['HOST']

        if not local_db_host:
            raise Exception('Mysql host is not specified.')

        mysql_args = ' '.join([
            '--max-allowed-packet=512M',
            '-h %s' % local_db_host,
            '-u %s' % local_db_user,
            '-p%s' % local_db_pass if local_db_pass else '',
        ])
        shell_cmd = 'echo "CREATE DATABASE IF NOT EXISTS {local_db}" | mysql {mysql_args}'.format(
            local_db=local_db,
            mysql_args=mysql_args
        )
        self.ssh_execute(shell_cmd)

        dev_slave = self.get_random_dev_slave()
        password = 'xaequ8paD'
        with open_secure_temp_file('wb') as (f, local_my_cnf_path):
            f.write('[client]\npassword={}'.format(password))
            f.flush()
            mysql_dump_args = ' '.join([
                '--defaults-file={}'.format(local_my_cnf_path),
                '--compress',
                '--single-transaction',
                '--max-allowed-packet=512M',
                '-h %s' % dev_slave,
                '-u rasp',
            ])
            shell_cmd = 'mysqldump {mysql_dump_args} avia {tables}| mysql {mysql_args} {local_db}'.format(
                mysql_dump_args=mysql_dump_args,
                mysql_args=mysql_args,
                local_db=local_db,
                tables='{} '.format(' '.join(tables)) if tables else ''
            )
            self.ssh_execute(shell_cmd)

        self.stdout.write('End DB update')

    def handle(self, local_db=None, tables=None, **options):
        if not local_db:
            self.stdout.write('Usage: manage.py update_local_db <local_db>')
            return

        self.stdout.write('Start DB update')

        self.copy_mysql_database(local_db, tables)


@contextmanager
def open_secure_temp_file(mode='wb', suffix='', prefix='tmp'):
    h, filepath = tempfile.mkstemp(suffix, prefix)
    try:
        f = os.fdopen(h, mode)
        try:
            yield f, filepath
        finally:
            f.close()
    finally:
        os.unlink(filepath)
