# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
from travel.avia.library.python.common.models.schedule import get_svg2png_logo_upload_to
from travel.avia.library.python.common.utils.fields import TrimmedCharField, TrimmedTextField, CodeCharField, ThreadCalendarField, RegExpField, ReplaceableFileSystemStorage, TextFileField
from travel.avia.library.python.common.models.transport import TransportSubtypeIconField, transportsubtypeiconfield_generate_filename
from travel.avia.library.python.common.models_utils.geo import Point, TimeZoneMixin, TransLocalMixin
from travel.avia.library.python.common.utils.files.validators import FileSizeValidator, SvgValidator
from travel.avia.library.python.common.models_abstract.schedule import StringTemplateValidator
import django.core.validators


class Migration(migrations.Migration):

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        ('currency', '__first__'),
    ]

    operations = [
        migrations.CreateModel(
            name='AeroexTariff',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('tariff', models.FloatField(verbose_name='\u0426\u0435\u043d\u0430')),
                ('suburban_search', models.BooleanField(default=True, verbose_name='\u0412 \u043f\u043e\u0438\u0441\u043a\u0435 \u044d\u043b\u0435\u043a\u0442\u0440\u0438\u0447\u0435\u043a')),
                ('reverse', models.BooleanField(default=True, verbose_name='\u0442\u0443\u0434\u0430-\u043e\u0431\u0440\u0430\u0442\u043d\u043e')),
                ('precalc', models.BooleanField(default=False, verbose_name='\u0417\u043e\u043d\u043d\u044b\u0439')),
                ('currency', models.CharField(default=None, max_length=10, null=True, verbose_name='\u0412\u0430\u043b\u044e\u0442\u0430', blank=True)),
            ],
            options={
                'verbose_name': '\u0442\u0430\u0440\u0438\u0444 \u043f\u0440\u0438\u0433\u043e\u0440\u043e\u0434\u043d\u043e\u0433\u043e \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430 \u0442\u043e\u0447\u043a\u0430-\u0442\u043e\u0447\u043a\u0430',  # noqa
                'verbose_name_plural': '\u0442\u0430\u0440\u0438\u0444\u044b \u043f\u0440\u0438\u0433\u043e\u0440\u043e\u0434\u043d\u043e\u0433\u043e \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430 \u0442\u043e\u0447\u043a\u0430-\u0442\u043e\u0447\u043a\u0430',  # noqa
            },
        ),
        migrations.CreateModel(
            name='AviaAlliance',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('logo_svg', models.FileField(upload_to=b'data/alliance/logo', verbose_name='SVG \u043b\u043e\u0433\u043e\u0442\u0438\u043f', blank=True)),
                ('enabled', models.BooleanField(default=False, verbose_name='\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c')),
                ('title', TrimmedCharField(default='', max_length=100, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0430\u043b\u044c\u044f\u043d\u0441\u0430')),
                ('title_ru', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0430\u043b\u044c\u044f\u043d\u0441\u0430 (ru)', blank=True)),  # noqa
                ('title_en', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0430\u043b\u044c\u044f\u043d\u0441\u0430 (en)', blank=True)),  # noqa
                ('title_tr', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0430\u043b\u044c\u044f\u043d\u0441\u0430 (tr)', blank=True)),  # noqa
                ('title_uk', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0430\u043b\u044c\u044f\u043d\u0441\u0430 (uk)', blank=True)),  # noqa
                ('description', models.TextField(verbose_name='\u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435', blank=True)),
                ('description_ru', models.TextField(verbose_name='\u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 (ru)', blank=True)),
                ('description_en', models.TextField(verbose_name='\u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 (en)', blank=True)),
                ('description_tr', models.TextField(verbose_name='\u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 (tr)', blank=True)),
                ('description_uk', models.TextField(verbose_name='\u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 (uk)', blank=True)),
            ],
            options={
                'ordering': ('title',),
                'verbose_name': '\u0430\u0432\u0438\u0430 \u0430\u043b\u044c\u044f\u043d\u0441',
                'verbose_name_plural': '\u0430\u0432\u0438\u0430 \u0430\u043b\u044c\u044f\u043d\u0441\u044b',
            },
        ),
        migrations.CreateModel(
            name='CityMajority',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=100, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435')),
            ],
            options={
                'db_table': 'www_citymajority',
                'verbose_name': '\u0432\u0430\u0436\u043d\u043e\u0441\u0442\u044c \u0433\u043e\u0440\u043e\u0434\u0430',
                'verbose_name_plural': '\u0432\u0430\u0436\u043d\u043e\u0441\u0442\u0438 \u0433\u043e\u0440\u043e\u0434\u043e\u0432',
            },
        ),
        migrations.CreateModel(
            name='CodeSystem',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=100, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f')),  # noqa
                ('code', CodeCharField(unique=True, max_length=100, verbose_name='\u043a\u043e\u0434 \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f')),  # noqa
            ],
            options={
                'ordering': ('id',),
                'db_table': 'www_codesystem',
                'verbose_name': '\u0441\u0438\u0441\u0442\u0435\u043c\u0430 \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f',
                'verbose_name_plural': 'c\u0438\u0441\u0442\u0435\u043c\u044b \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f',
            },
        ),
        migrations.CreateModel(
            name='Company',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('address', models.CharField(max_length=255, null=True, verbose_name='\u0430\u0434\u0440\u0435\u0441', blank=True)),
                ('supplier_code', CodeCharField(null=True, default=None, max_length=255, blank=True, unique=True, verbose_name='\u043a\u043e\u0434 \u041f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430 \u0414\u0430\u043d\u043d\u044b\u0445')),  # noqa
                ('sirena_id', CodeCharField(null=True, default=None, max_length=100, blank=True, unique=True, verbose_name='\u043a\u043e\u0434 \u0421\u0438\u0440\u0435\u043d\u0430')),  # noqa
                ('iata', CodeCharField(default=None, max_length=100, blank=True, null=True, verbose_name='\u043a\u043e\u0434 IATA', db_index=True)),
                ('icao', CodeCharField(max_length=100, unique=True, null=True, verbose_name='\u043a\u043e\u0434 ICAO', blank=True)),
                ('icao_ru', CodeCharField(max_length=100, unique=True, null=True, verbose_name='\u043a\u043e\u0434 ICAO(\u0440\u0443\u0441)', blank=True)),
                ('is_freight', models.BooleanField(default=False, help_text='\u041d\u0435 \u0438\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u0443\u0435\u043c \u0442\u0430\u043a\u0438\u0435 \u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0438 \u043e\u0442 OAG', verbose_name='\u0413\u0440\u0443\u0437\u043e\u0432\u0430\u044f \u043a\u043e\u043c\u043f\u0430\u043d\u0438\u044f')),  # noqa
                ('priority', models.IntegerField(default=0, help_text='\u041f\u0440\u0438\u043e\u0440\u0438\u0442\u0435\u0442 \u0434\u043b\u044f \u0440\u0430\u0437\u043b\u0438\u0447\u0435\u043d\u0438\u044f \u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0439 \u0441 \u043e\u0434\u043d\u0438\u043c \u0438\u0430\u0442\u0430-\u043a\u043e\u0434\u043e\u043c', blank=True)),  # noqa
                ('url', models.URLField(max_length=255, null=True, verbose_name='\u0443\u0440\u043b \u0441\u0430\u0439\u0442\u0430', blank=True)),
                ('email', models.EmailField(max_length=255, null=True, verbose_name='email', blank=True)),
                ('contact_info', models.TextField(default=None, null=True, verbose_name='\u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u0430\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f', blank=True)),  # noqa
                ('phone', TrimmedCharField(default=b'', max_length=255, verbose_name='\u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u044b\u0439 \u0442\u0435\u043b\u0435\u0444\u043e\u043d', blank=True)),  # noqa
                ('phone_booking', TrimmedCharField(default=b'', max_length=255, verbose_name='\u0442\u0435\u043b\u0435\u0444\u043e\u043d \u0434\u043b\u044f \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f', blank=True)),  # noqa
                ('description', models.TextField(default=None, null=True, verbose_name='\u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435', blank=True)),
                ('logo', models.ImageField(default=None, upload_to=b'data/company/logo', null=True, verbose_name='\u043b\u043e\u0433\u043e\u0442\u0438\u043f', blank=True)),
                ('icon', models.ImageField(default=None, upload_to=b'data/company/icon', null=True, verbose_name='\u0438\u043a\u043e\u043d\u043a\u0430', blank=True)),
                ('logo_mono', models.ImageField(default=None, upload_to=b'data/company/logo_mono', null=True, verbose_name='\u043b\u043e\u0433\u043e\u0442\u0438\u043f \u0431\u0435\u0437 \u0444\u043e\u043d\u0430', blank=True)),  # noqa
                ('logo_bgcolor', TrimmedCharField(default=b'', help_text='\u0412 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 #FF0044', max_length=7, verbose_name='\u0446\u0432\u0435\u0442 \u0444\u043e\u043d\u0430 \u043b\u043e\u0433\u043e\u0442\u0438\u043f\u0430', blank=True)),  # noqa
                ('svg_logo', models.FileField(default=None, upload_to=b'data/company/svg', null=True, verbose_name='svg \u043b\u043e\u0433\u043e\u0442\u0438\u043f', blank=True)),
                ('svg2png_logo', models.ImageField(default=None, storage=ReplaceableFileSystemStorage(), upload_to=get_svg2png_logo_upload_to, blank=True, null=True, verbose_name='\u0420\u0435\u043d\u0434\u0435\u0440\u0435\u043d\u043d\u044b\u0439 svg2png \u043b\u043e\u0433\u043e\u0442\u0438\u043f')),  # noqa
                ('hidden', models.BooleanField(default=False, verbose_name='\u043d\u0435 \u043f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u043d\u0438\u0433\u0434\u0435!')),
                ('strange', models.BooleanField(default=False, verbose_name='\u043d\u0435 \u043f\u043e\u043d\u044f\u0442\u043d\u044b\u0435 \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a\u0438')),  # noqa
                ('meta_title', models.CharField(max_length=255, null=True, verbose_name='meta title', blank=True)),
                ('meta_description', models.TextField(null=True, verbose_name='meta description', blank=True)),
                ('bonus_name', TrimmedCharField(default='', max_length=255, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b \u0434\u043b\u044f \u0447\u0430\u0441\u0442\u043e \u043b\u0435\u0442\u0430\u044e\u0449\u0438\u0445 \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u043e\u0432', blank=True)),  # noqa
                ('bonus_name_ru', TrimmedCharField(default='', max_length=255, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b \u0434\u043b\u044f \u0447\u0430\u0441\u0442\u043e \u043b\u0435\u0442\u0430\u044e\u0449\u0438\u0445 \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u043e\u0432 (ru)', blank=True)),  # noqa
                ('bonus_name_en', TrimmedCharField(default='', max_length=255, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b \u0434\u043b\u044f \u0447\u0430\u0441\u0442\u043e \u043b\u0435\u0442\u0430\u044e\u0449\u0438\u0445 \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u043e\u0432 (en)', blank=True)),  # noqa
                ('bonus_name_tr', TrimmedCharField(default='', max_length=255, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b \u0434\u043b\u044f \u0447\u0430\u0441\u0442\u043e \u043b\u0435\u0442\u0430\u044e\u0449\u0438\u0445 \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u043e\u0432 (tr)', blank=True)),  # noqa
                ('bonus_name_uk', TrimmedCharField(default='', max_length=255, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b \u0434\u043b\u044f \u0447\u0430\u0441\u0442\u043e \u043b\u0435\u0442\u0430\u044e\u0449\u0438\u0445 \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u043e\u0432 (uk)', blank=True)),  # noqa
                ('registration_phone', TrimmedCharField(default=b'', max_length=255, null=True, verbose_name='\u0422\u0435\u043b\u0435\u0444\u043e\u043d \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438', blank=True)),  # noqa
                ('registration_phone_ru', TrimmedCharField(default=b'', max_length=255, null=True, verbose_name='\u0422\u0435\u043b\u0435\u0444\u043e\u043d \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 (ru)', blank=True)),  # noqa
                ('registration_phone_en', TrimmedCharField(default=b'', max_length=255, null=True, verbose_name='\u0422\u0435\u043b\u0435\u0444\u043e\u043d \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 (en)', blank=True)),  # noqa
                ('registration_phone_tr', TrimmedCharField(default=b'', max_length=255, null=True, verbose_name='\u0422\u0435\u043b\u0435\u0444\u043e\u043d \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 (tr)', blank=True)),  # noqa
                ('registration_phone_uk', TrimmedCharField(default=b'', max_length=255, null=True, verbose_name='\u0422\u0435\u043b\u0435\u0444\u043e\u043d \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 (uk)', blank=True)),  # noqa
                ('title', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435', blank=True)),
                ('title_ru', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (ru)', blank=True)),
                ('title_en', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (en)', blank=True)),
                ('title_tr', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (tr)', blank=True)),
                ('title_uk', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (uk)', blank=True)),
                ('short_title', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043a\u0440\u0430\u0442\u043a\u043e\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435', blank=True)),  # noqa
                ('short_title_ru', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043a\u0440\u0430\u0442\u043a\u043e\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (ru)', blank=True)),  # noqa
                ('short_title_en', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043a\u0440\u0430\u0442\u043a\u043e\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (en)', blank=True)),  # noqa
                ('short_title_tr', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043a\u0440\u0430\u0442\u043a\u043e\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (tr)', blank=True)),  # noqa
                ('short_title_uk', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043a\u0440\u0430\u0442\u043a\u043e\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (uk)', blank=True)),  # noqa
                ('registration_url', TrimmedCharField(default=b'', max_length=255, null=True, verbose_name='Url \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438', blank=True)),  # noqa
                ('registration_url_ru', TrimmedCharField(default=b'', max_length=255, null=True, verbose_name='Url \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 (ru)', blank=True)),  # noqa
                ('registration_url_en', TrimmedCharField(default=b'', max_length=255, null=True, verbose_name='Url \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 (en)', blank=True)),  # noqa
                ('registration_url_tr', TrimmedCharField(default=b'', max_length=255, null=True, verbose_name='Url \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 (tr)', blank=True)),  # noqa
                ('registration_url_uk', TrimmedCharField(default=b'', max_length=255, null=True, verbose_name='Url \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 (uk)', blank=True)),  # noqa
                ('alliance', models.ForeignKey(related_name='companies', verbose_name='\u0410\u0432\u0438\u0430-\u0430\u043b\u044c\u044f\u043d\u0441', blank=True, to='www.AviaAlliance', null=True)),
            ],
            options={
                'ordering': ('title',),
                'db_table': 'www_company',
                'verbose_name': '\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u044f-\u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a',
                'verbose_name_plural': '\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0438-\u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a\u0438',
            },
        ),
        migrations.CreateModel(
            name='CompanyOffice',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=255, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435')),
                ('address', models.CharField(max_length=255, verbose_name='\u0410\u0434\u0440\u0435\u0441\u0441')),
                ('contact_info', models.TextField(default=b'', verbose_name='\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u0430\u044f \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f', blank=True)),  # noqa
                ('phone', TrimmedCharField(default=b'', max_length=255, verbose_name='\u041a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u044b\u0439 \u0442\u0435\u043b\u0435\u0444\u043e\u043d', blank=True)),  # noqa
                ('phone_booking', TrimmedCharField(default=b'', max_length=255, verbose_name='\u0422\u0435\u043b\u0435\u0444\u043e\u043d \u0434\u043b\u044f \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f', blank=True)),  # noqa
                ('description', models.TextField(default=b'', verbose_name='\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435', blank=True)),
                ('longitude', models.FloatField(default=None, null=True, verbose_name='\u0414\u043e\u043b\u0433\u043e\u0442\u0430', blank=True)),
                ('latitude', models.FloatField(default=None, null=True, verbose_name='\u0428\u0438\u0440\u043e\u0442\u0430', blank=True)),
                ('is_main', models.BooleanField(default=False, verbose_name='\u0413\u043b\u0430\u0432\u043d\u044b\u0439 \u043e\u0444\u0438\u0441')),
                ('company', models.ForeignKey(verbose_name='\u041a\u043e\u043c\u043f\u0430\u043d\u0438\u044f \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a', to='www.Company')),
            ],
            options={
                'verbose_name': '\u041e\u0444\u0438\u0441 \u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0438-\u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a\u0430',
                'verbose_name_plural': '\u041e\u0444\u0438\u0441\u044b \u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0439-\u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a\u043e\u0432',
            },
        ),
        migrations.CreateModel(
            name='Country',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title_ru_preposition_v_vo_na', TrimmedCharField(default=None, max_length=2, null=True, verbose_name='\u043f\u0440\u0435\u0434\u043b\u043e\u0433 (\u0432, \u0432\u043e, \u043d\u0430)', blank=True)),  # noqa
                ('title_ru_genitive', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (\u0440\u043e\u0434. \u043f\u0430\u0434\u0435\u0436', blank=True)),  # noqa
                ('title_ru_locative', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (\u043c\u0435\u0441\u0442\u043d\u044b\u0439. \u043f\u0430\u0434\u0435\u0436)', blank=True)),  # noqa
                ('title_uk_accusative', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (\u0432\u0438\u043d. \u043f\u0430\u0434\u0435\u0436) (uk)', blank=True)),  # noqa
                ('_geo_id', models.IntegerField(default=None, unique=True, null=True, verbose_name='geo ID', blank=True)),
                ('_kladr_id', models.CharField(default=None, editable=False, max_length=50, blank=True, null=True, verbose_name='kladr ID')),
                ('code', CodeCharField(null=True, default=None, max_length=4, blank=True, unique=True, verbose_name='\u043a\u043e\u0434 \u0441\u0442\u0440\u0430\u043d\u044b ISO 2-alpha')),  # noqa
                ('domain_zone', CodeCharField(null=True, default=None, max_length=2, blank=True, help_text="\u0431\u0435\u0437 \u0442\u043e\u0447\u043a\u0438: 'ru', 'us', 'uk'", unique=True, verbose_name='\u0438\u043c\u044f \u0434\u043e\u043c\u0435\u043d\u043d\u043e\u0439 \u0437\u043e\u043d\u044b IANA')),  # noqa
                ('language', CodeCharField(default=b'ru', max_length=5, verbose_name='\u044f\u0437\u044b\u043a \u0441\u0442\u0440\u0430\u043d\u044b', choices=[(b'af', 'Afrikaans'), (b'ar', 'Arabic'), (b'ast', 'Asturian'), (b'az', 'Azerbaijani'), (b'bg', 'Bulgarian'), (b'be', 'Belarusian'), (b'bn', 'Bengali'), (b'br', 'Breton'), (b'bs', 'Bosnian'), (b'ca', 'Catalan'), (b'cs', 'Czech'), (b'cy', 'Welsh'), (b'da', 'Danish'), (b'de', 'German'), (b'el', 'Greek'), (b'en', 'English'), (b'en-au', 'Australian English'), (b'en-gb', 'British English'), (b'eo', 'Esperanto'), (b'es', 'Spanish'), (b'es-ar', 'Argentinian Spanish'), (b'es-mx', 'Mexican Spanish'), (b'es-ni', 'Nicaraguan Spanish'), (b'es-ve', 'Venezuelan Spanish'), (b'et', 'Estonian'), (b'eu', 'Basque'), (b'fa', 'Persian'), (b'fi', 'Finnish'), (b'fr', 'French'), (b'fy', 'Frisian'), (b'ga', 'Irish'), (b'gl', 'Galician'), (b'he', 'Hebrew'), (b'hi', 'Hindi'), (b'hr', 'Croatian'), (b'hu', 'Hungarian'), (b'ia', 'Interlingua'), (b'id', 'Indonesian'), (b'io', 'Ido'), (b'is', 'Icelandic'), (b'it', 'Italian'), (b'ja', 'Japanese'), (b'ka', 'Georgian'), (b'kk', 'Kazakh'), (b'km', 'Khmer'), (b'kn', 'Kannada'), (b'ko', 'Korean'), (b'lb', 'Luxembourgish'), (b'lt', 'Lithuanian'), (b'lv', 'Latvian'), (b'mk', 'Macedonian'), (b'ml', 'Malayalam'), (b'mn', 'Mongolian'), (b'mr', 'Marathi'), (b'my', 'Burmese'), (b'nb', 'Norwegian Bokmal'), (b'ne', 'Nepali'), (b'nl', 'Dutch'), (b'nn', 'Norwegian Nynorsk'), (b'os', 'Ossetic'), (b'pa', 'Punjabi'), (b'pl', 'Polish'), (b'pt', 'Portuguese'), (b'pt-br', 'Brazilian Portuguese'), (b'ro', 'Romanian'), (b'ru', 'Russian'), (b'sk', 'Slovak'), (b'sl', 'Slovenian'), (b'sq', 'Albanian'), (b'sr', 'Serbian'), (b'sr-latn', 'Serbian Latin'), (b'sv', 'Swedish'), (b'sw', 'Swahili'), (b'ta', 'Tamil'), (b'te', 'Telugu'), (b'th', 'Thai'), (b'tr', 'Turkish'), (b'tt', 'Tatar'), (b'udm', 'Udmurt'), (b'uk', 'Ukrainian'), (b'ur', 'Urdu'), (b'vi', 'Vietnamese'), (b'zh-cn', 'Simplified Chinese'), (b'zh-hans', 'Simplified Chinese'), (b'zh-hant', 'Traditional Chinese'), (b'zh-tw', 'Traditional Chinese')])),  # noqa
                ('modified_at', models.DateTimeField(auto_now=True, verbose_name='\u0414\u0430\u0442\u0430-\u0432\u0440\u0435\u043c\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f')),
                ('title', TrimmedCharField(default=None, max_length=100, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435')),
                ('title_ru', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (ru)', blank=True)),  # noqa
                ('title_en', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (en)', blank=True)),  # noqa
                ('title_tr', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (tr)', blank=True)),  # noqa
                ('title_uk', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (uk)', blank=True)),  # noqa
                ('currency', models.ForeignKey(default=None, blank=True, to='currency.Currency', null=True, verbose_name='\u0432\u0430\u043b\u044e\u0442\u0430')),
            ],
            options={
                'db_table': 'www_country',
                'verbose_name': '\u0441\u0442\u0440\u0430\u043d\u0430',
                'verbose_name_plural': '\u0441\u0442\u0440\u0430\u043d\u044b',
            },
            bases=(models.Model, Point),
        ),
        migrations.CreateModel(
            name='DefaultPoint',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', TrimmedCharField(help_text="\u0432 \u043d\u0438\u0436\u043d\u0435\u043c \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0435, '\u043c\u043e\u0441\u043a\u0432\u0430'", unique=True, max_length=255, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435')),  # noqa
            ],
            options={
                'verbose_name': '\u0423\u0442\u043e\u0447\u043d\u0435\u043d\u0438\u0435 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e',
                'verbose_name_plural': '\u0423\u0442\u043e\u0447\u043d\u0435\u043d\u0438\u044f \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e',
            },
        ),
        migrations.CreateModel(
            name='DefaultSuggest',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('priority', models.IntegerField(help_text='\u041e\u043f\u0440\u0435\u0434\u0435\u043b\u044f\u0435\u0442 \u043f\u043e\u0440\u044f\u0434\u043e\u043a \u0441\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043a\u0438 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u043e\u0432', verbose_name='\u043f\u0440\u0438\u043e\u0440\u0438\u0442\u0435\u0442')),  # noqa
                ('lang', models.CharField(help_text='\u042f\u0437\u044b\u043a, \u0434\u043b\u044f \u043a\u043e\u0442\u043e\u0440\u043e\u0433\u043e \u0431\u0443\u0434\u0435\u0442 \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0442\u044c\u0441\u044f \u043f\u043e\u0434\u0441\u043a\u0430\u0437\u043a\u0430: ru, tr,...', max_length=10, verbose_name='\u044f\u0437\u044b\u043a (deprecated)', choices=[(b'ru', '\u0420\u0443\u0441\u0441\u043a\u0438\u0439'), (b'be', '\u0411\u0435\u043b\u043e\u0440\u0443\u0441\u0441\u043a\u0438\u0439'), (b'kk', '\u041a\u0430\u0437\u0430\u0445\u0441\u043a\u0438\u0439'), (b'tt', '\u0422\u0430\u0442\u0430\u0440\u0441\u043a\u0438\u0439'), (b'uk', '\u0423\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u0438\u0439'), (b'en', '\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439'), (b'tr', '\u0422\u0443\u0440\u0435\u0446\u043a\u0438\u0439')])),  # noqa
                ('national_version', models.CharField(default=b'ru', max_length=25, verbose_name='\u041d\u0430\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u0430\u044f \u0432\u0435\u0440\u0441\u0438\u044f', choices=[(b'ru', b'ru'), (b'ua', b'ua'), (b'tr', b'tr')])),  # noqa
                ('suggest_type_id', models.IntegerField(help_text='Suggest \u043a \u043a\u043e\u0442\u043e\u0440\u043e\u043c\u0443 \u043e\u0442\u043d\u043e\u0441\u0438\u0442\u0441\u044f \u044d\u043b\u0435\u043c\u0435\u043d\u0442', verbose_name='Suggest', choices=[(2, '\u0436/\u0434 \u0433\u043e\u0440\u043e\u0434'), (1, '\u0436/\u0434 \u0441\u0442\u0430\u043d\u0446\u0438\u044f'), (4, '\u0430\u0432\u0438\u0430 \u0433\u043e\u0440\u043e\u0434'), (3, '\u0430\u0432\u0438\u0430 \u0430\u044d\u0440\u043e\u043f\u043e\u0440\u0442')])),  # noqa
                ('value', TrimmedCharField(default=None, max_length=100, blank=True, help_text='\u041f\u0440\u0435\u0434\u043b\u0430\u0433\u0430\u0435\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435', null=True, verbose_name='\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435')),  # noqa
                ('value_ru', TrimmedCharField(default=None, max_length=100, blank=True, help_text='\u041f\u0440\u0435\u0434\u043b\u0430\u0433\u0430\u0435\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435', null=True, verbose_name='\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 (ru)')),  # noqa
                ('value_en', TrimmedCharField(default=None, max_length=100, blank=True, help_text='\u041f\u0440\u0435\u0434\u043b\u0430\u0433\u0430\u0435\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435', null=True, verbose_name='\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 (en)')),  # noqa
                ('value_tr', TrimmedCharField(default=None, max_length=100, blank=True, help_text='\u041f\u0440\u0435\u0434\u043b\u0430\u0433\u0430\u0435\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435', null=True, verbose_name='\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 (tr)')),  # noqa
                ('value_uk', TrimmedCharField(default=None, max_length=100, blank=True, help_text='\u041f\u0440\u0435\u0434\u043b\u0430\u0433\u0430\u0435\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435', null=True, verbose_name='\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 (uk)')),  # noqa
            ],
            options={
                'ordering': ('suggest_type_id', 'lang', 'priority', 'value'),
                'verbose_name': 'default suggest',
                'verbose_name_plural': 'default suggests',
            },
        ),
        migrations.CreateModel(
            name='DeLuxeTrain',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('numbers', TrimmedCharField(max_length=50, verbose_name='\u043d\u043e\u043c\u0435\u0440\u0430')),
                ('deluxe', models.BooleanField(default=False, verbose_name='\u0444\u0438\u0440\u043c\u0435\u043d\u043d\u044b\u0439')),
                ('high_speed', models.BooleanField(default=False, verbose_name='\u0441\u043a\u043e\u0440\u043e\u0441\u0442\u043d\u043e\u0439')),
                ('title', TrimmedCharField(db_index=True, max_length=100, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435', blank=True)),
                ('title_ru', TrimmedCharField(db_index=True, max_length=100, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (ru)', blank=True)),
                ('title_en', TrimmedCharField(db_index=True, max_length=100, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (en)', blank=True)),
                ('title_tr', TrimmedCharField(db_index=True, max_length=100, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (tr)', blank=True)),
                ('title_uk', TrimmedCharField(db_index=True, max_length=100, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (uk)', blank=True)),
            ],
            options={
                'db_table': 'www_deluxetrain',
                'verbose_name': '\u0444\u0438\u0440\u043c\u0435\u043d\u043d\u044b\u0439 \u0438\u043b\u0438 \u0438\u043c\u0435\u043d\u043d\u043e\u0439 \u043f\u043e\u0435\u0437\u0434',
                'verbose_name_plural': '\u0444\u0438\u0440\u043c\u0435\u043d\u043d\u044b\u0435 \u0438 \u0438\u043c\u0435\u043d\u043d\u044b\u0435 \u043f\u043e\u0435\u0437\u0434\u0430',
            },
        ),
        migrations.CreateModel(
            name='Direction',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=100, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f')),
                ('title_from', models.CharField(max_length=100, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0442\u0443\u0434\u0430(\u043e\u0442 \u041c\u043e\u0441\u043a\u0432\u044b)')),  # noqa
                ('title_to', models.CharField(max_length=100, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043e\u0431\u0440\u0430\u0442\u043d\u043e(\u043d\u0430 \u041c\u043e\u0441\u043a\u0432\u0443)')),  # noqa
                ('code', models.CharField(unique=True, max_length=50, verbose_name='\u043a\u043e\u0434 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f')),
            ],
            options={
                'ordering': ('title',),
                'db_table': 'www_direction',
                'verbose_name': '\u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435',
                'verbose_name_plural': '\u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f',
            },
        ),
        migrations.CreateModel(
            name='DirectionFromTranslate',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('value', TrimmedCharField(null=True, default=None, max_length=100, blank=True, unique=True, verbose_name='\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435')),
                ('value_ru', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 (ru)', blank=True)),
                ('value_en', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 (en)', blank=True)),
                ('value_tr', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 (tr)', blank=True)),
                ('value_uk', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 (uk)', blank=True)),
            ],
            options={
                'ordering': ('value',),
                'db_table': 'www_directionfromtranslate',
                'verbose_name': '\u043f\u0435\u0440\u0435\u0432\u043e\u0434 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u044f \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0442\u0443\u0434\u0430 \u0438 \u043e\u0431\u0440\u0430\u0442\u043d\u043e',  # noqa
                'verbose_name_plural': '\u043f\u0435\u0440\u0435\u0432\u043e\u0434\u044b \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0439 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0439 \u0442\u0443\u0434\u0430 \u0438 \u043e\u0431\u0440\u0430\u0442\u043d\u043e',  # noqa
            },
        ),
        migrations.CreateModel(
            name='DirectionMarker',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title_from', models.CharField(help_text='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0442\u0443\u0434\u0430(\u043e\u0442 \u041c\u043e\u0441\u043a\u0432\u044b). \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0434\u043b\u044f \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u044f \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043d\u0430 \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0435\u0439 \u0441\u0442\u0430\u043d\u0446\u0438\u0438((\u043e\u0442 \u041c\u043e\u0441\u043a\u0432\u044b) \u043d\u0430 \u041a\u0430\u0442\u044b\u0448\u043a\u0443)', max_length=100, null=True, verbose_name='\u0442\u0443\u0434\u0430', blank=True)),  # noqa
                ('title_to', models.CharField(help_text='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043e\u0431\u0440\u0430\u0442\u043d\u043e(\u043d\u0430 \u041c\u043e\u0441\u043a\u0432\u0443). \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0434\u043b\u044f \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u044f \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043d\u0430 \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0435\u0439 \u0441\u0442\u0430\u043d\u0446\u0438\u0438((\u043d\u0430 \u041c\u043e\u0441\u043a\u0432\u0443) \u043d\u0430 \u0411\u0443\u0442\u043a\u0443)', max_length=100, null=True, verbose_name='\u043e\u0431\u0440\u0430\u0442\u043d\u043e', blank=True)),  # noqa
                ('order', models.IntegerField(verbose_name='\u043f\u043e\u0440\u044f\u0434\u043e\u043a', db_index=True)),
                ('arrival_title_from', models.CharField(help_text='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0442\u0443\u0434\u0430(\u043e\u0442 \u041c\u043e\u0441\u043a\u0432\u044b). \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0434\u043b\u044f \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u044f \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f \u043d\u0430 \u0442\u0435\u043a\u0443\u0449\u0435\u0439 \u0441\u0442\u0430\u043d\u0446\u0438\u0438((\u043e\u0442 \u041c\u043e\u0441\u043a\u0432\u044b) \u043d\u0430 \u041a\u0430\u0442\u044b\u0448\u043a\u0443) \u0438\u043d\u0430\u0447\u0435 \u0431\u0435\u0440\u0435\u0442\u0441\u044f \u0442\u0435\u043a\u0441\u0442 \u0438\u0437 \u0422\u0443\u0434\u0430', max_length=100, null=True, verbose_name='\u043f\u0440\u0438\u0431\u044b\u0442\u0438\u0435 \u0422\u0443\u0434\u0430', blank=True)),  # noqa
                ('arrival_title_to', models.CharField(help_text='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043e\u0431\u0440\u0430\u0442\u043d\u043e(\u043d\u0430 \u041c\u043e\u0441\u043a\u0432\u0443). \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0434\u043b\u044f \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u044f \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f \u043d\u0430 \u0442\u0435\u043a\u0443\u0449\u0435\u0439 \u0441\u0442\u0430\u043d\u0446\u0438\u0438((\u043d\u0430 \u041c\u043e\u0441\u043a\u0432\u0443) \u043d\u0430 \u0411\u0443\u0442\u043a\u0443) \u0438\u043d\u0430\u0447\u0435 \u0431\u0435\u0440\u0435\u0442\u0441\u044f \u0442\u0435\u043a\u0441\u0442 \u0438\u0437 \u041e\u0431\u0440\u0430\u0442\u043d\u043e', max_length=100, null=True, verbose_name='\u043f\u0440\u0438\u0431\u044b\u0442\u0438\u0435 \u041e\u0431\u0440\u0430\u0442\u043d\u043e', blank=True)),  # noqa
                ('arrow_type', models.CharField(blank=True, max_length=100, null=True, verbose_name='\u0442\u0438\u043f \u043e\u0442\u0432\u0435\u0442\u0432\u043b\u0435\u043d\u0438\u044f', choices=[(b'', '\u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e'), (b'right', '\u043d\u0430\u043f\u0440\u0430\u0432\u043e'), (b'left', '\u043d\u0430\u043b\u0435\u0432\u043e'), (b'up', '\u0432\u0432\u0435\u0440\u0445'), (b'down', '\u0432\u043d\u0438\u0437'), (b'right-up', '\u043d\u0430\u043f\u0440\u0430\u0432\u043e-\u0432\u0432\u0435\u0440\u0445'), (b'right-down', '\u043d\u0430\u043f\u0440\u0430\u0432\u043e-\u0432\u043d\u0438\u0437'), (b'left-up', '\u043d\u0430\u043b\u0435\u0432\u043e-\u0432\u0432\u0435\u0440\u0445'), (b'left-down', '\u043d\u0430\u043b\u0435\u0432\u043e-\u0432\u043d\u0438\u0437')])),  # noqa
                ('arrow_title', models.CharField(max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u0442\u0440\u0435\u043b\u043a\u0438', blank=True)),
                ('direction', models.ForeignKey(verbose_name='\u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435', to='www.Direction')),
                ('next', models.ForeignKey(related_name='prev_set', verbose_name='\u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0430\u044f \u0441\u0442\u0430\u043d\u0446\u0438\u044f', blank=True, to='www.DirectionMarker', null=True)),  # noqa
                ('prev', models.ForeignKey(related_name='next_set', verbose_name='\u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0430\u044f \u0441\u0442\u0430\u043d\u0446\u0438\u044f', blank=True, to='www.DirectionMarker', null=True)),  # noqa
            ],
            options={
                'ordering': ('order',),
                'db_table': 'www_directionmarker',
                'verbose_name': '\u043c\u0430\u0440\u043a\u0435\u0440 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f',
                'verbose_name_plural': '\u043c\u0430\u0440\u043a\u0435\u0440\u044b \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0439',
            },
        ),
        migrations.CreateModel(
            name='DirectionTranslate',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('value', TrimmedCharField(null=True, default=None, max_length=100, blank=True, unique=True, verbose_name='\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435')),
                ('value_ru', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 (ru)', blank=True)),
                ('value_en', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 (en)', blank=True)),
                ('value_tr', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 (tr)', blank=True)),
                ('value_uk', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 (uk)', blank=True)),
            ],
            options={
                'ordering': ('value',),
                'db_table': 'www_directiontranslate',
                'verbose_name': '\u043f\u0435\u0440\u0435\u0432\u043e\u0434 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u044f \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f',
                'verbose_name_plural': '\u043f\u0435\u0440\u0435\u0432\u043e\u0434\u044b \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0439 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0439',  # noqa
            },
        ),
        migrations.CreateModel(
            name='District',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=255, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435')),
                ('_disputed_territory', models.BooleanField(default=False, verbose_name='\u0441\u043f\u043e\u0440\u043d\u0430\u044f \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u044f', db_column=b'disputed_territory')),  # noqa
            ],
        ),
        migrations.CreateModel(
            name='ExpressNumber',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('number', RegExpField(help_text='\u043d\u043e\u043c\u0435\u0440 \u0440\u0435\u0439\u0441\u0430 \u043c\u043e\u0436\u043d\u043e \u0437\u0430\u0434\u0430\u0432\u0430\u0442\u044c \u0440\u0435\u0433\u0443\u043b\u044f\u0440\u044b\u043c \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435\u043c', unique=True, max_length=255, verbose_name='\u043d\u043e\u043c\u0435\u0440 \u0440\u0435\u0439\u0441\u0430')),  # noqa
                ('express_type', models.CharField(max_length=20, verbose_name='\u0442\u0438\u043f \u044d\u043a\u0441\u043f\u0440\u0435\u0441\u0441\u0430', choices=[(b'', '\u041e\u0431\u044b\u0447\u043d\u044b\u0439 \u0440\u0435\u0439\u0441'), (b'express', '\u042d\u043a\u0441\u043f\u0440\u0435\u0441\u0441'), (b'aeroexpress', '\u0410\u044d\u0440\u043e\u044d\u043a\u0441\u043f\u0440\u0435\u0441\u0441')])),  # noqa
            ],
            options={
                'verbose_name': '\u043d\u043e\u043c\u0435\u0440 \u044d\u043a\u0441\u043f\u0440\u0435\u0441\u0441\u0430',
                'verbose_name_plural': '\u043d\u043e\u043c\u0435\u0440\u0430 \u044d\u043a\u0441\u043f\u0440\u0435\u0441\u0441\u043e\u0432',
            },
        ),
        migrations.CreateModel(
            name='ExpressTypeLite',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', TrimmedCharField(default=b'', max_length=100, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435', blank=True)),
                ('code', TrimmedCharField(default=b'', max_length=40, verbose_name='\u041a\u043e\u0434', blank=True)),
                ('color', TrimmedCharField(default=b'', max_length=10, verbose_name='\u0426\u0432\u0435\u0442', blank=True)),
            ],
            options={
                'db_table': 'www_expresstypelite',
                'verbose_name': '\u043f\u043e\u0434\u0442\u0438\u043f \u044d\u043a\u0441\u043f\u0440\u0435\u0441\u0441\u043e\u0432',
                'verbose_name_plural': '\u043f\u043e\u0434\u0442\u0438\u043f\u044b \u044d\u043a\u0441\u043f\u0440\u0435\u0441\u0441\u043e\u0432',
            },
        ),
        migrations.CreateModel(
            name='ExternalDirection',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('code', models.CharField(unique=True, max_length=50, verbose_name='\u043a\u043e\u0434 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f')),
                ('reduced_tariff', models.FloatField(default=0, verbose_name='\u043c\u043d\u043e\u0436\u0438\u0442\u0435\u043b\u044c \u043b\u044c\u0433\u043e\u0442\u043d\u043e\u0433\u043e \u0442\u0430\u0440\u0438\u0444\u0430')),  # noqa
                ('use_synchronous_tariff', models.BooleanField(default=False, verbose_name='\u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u043d\u044b\u0439 \u0442\u0430\u0440\u0438\u0444')),  # noqa
                ('schema_file', TextFileField(help_text='\u043f\u0440\u0438\u043d\u0438\u043c\u0430\u044e\u0442\u0441\u044f \u0442\u043e\u043b\u044c\u043a\u043e \u0442\u0435\u043a\u0441\u0442\u043e\u0432\u044b\u0435 \u0444\u0430\u0439\u043b\u044b \u0432 \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u043a\u0435 cp1251', verbose_name='\u0444\u0430\u0439\u043b \u0441 \u043a\u0430\u0440\u0442\u043e\u0439 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f', blank=True)),  # noqa
                ('full_title', TrimmedCharField(default=None, max_length=100, verbose_name='\u043f\u043e\u043b\u043d\u043e\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435')),  # noqa
                ('full_title_ru', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043f\u043e\u043b\u043d\u043e\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (ru)', blank=True)),  # noqa
                ('full_title_en', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043f\u043e\u043b\u043d\u043e\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (en)', blank=True)),  # noqa
                ('full_title_tr', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043f\u043e\u043b\u043d\u043e\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (tr)', blank=True)),  # noqa
                ('full_title_uk', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043f\u043e\u043b\u043d\u043e\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (uk)', blank=True)),  # noqa
                ('title', TrimmedCharField(default=None, max_length=100, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f')),  # noqa
                ('title_ru', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f (ru)', blank=True)),  # noqa
                ('title_en', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f (en)', blank=True)),  # noqa
                ('title_tr', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f (tr)', blank=True)),  # noqa
                ('title_uk', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f (uk)', blank=True)),  # noqa
            ],
            options={
                'ordering': ('title',),
                'db_table': 'www_externaldirection',
                'verbose_name': '\u0432\u043d\u0435\u0448\u043d\u0435\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435',
                'verbose_name_plural': '\u0432\u043d\u0435\u0448\u043d\u0438\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f',
            },
        ),
        migrations.CreateModel(
            name='ExternalDirectionMarker',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('order', models.IntegerField(verbose_name='\u043f\u043e\u0440\u044f\u0434\u043e\u043a', db_index=True)),
                ('zone', TrimmedCharField(max_length=10, null=True, verbose_name='\u0442\u0430\u0440\u0438\u0444\u043d\u0430\u044f \u0437\u043e\u043d\u0430', blank=True)),
                ('zgroup', TrimmedCharField(max_length=50, null=True, verbose_name='\u0442\u0430\u0440\u0438\u0444\u043d\u0430\u044f \u0433\u0440\u0443\u043f\u043f\u0430', blank=True)),  # noqa
                ('zprice', TrimmedCharField(max_length=50, null=True, verbose_name='\u0432\u044a\u0435\u0437\u0434 \u0432 \u0437\u043e\u043d\u0443', blank=True)),
                ('zprice_inner', TrimmedCharField(max_length=50, null=True, verbose_name='\u043f\u0440\u043e\u0435\u0437\u0434 \u0432\u043d\u0443\u0442\u0440\u0438 \u0437\u043e\u043d\u044b', blank=True)),  # noqa
                ('zprice_exit', TrimmedCharField(max_length=50, null=True, verbose_name='\u0432\u044b\u0435\u0437\u0434 \u0438\u0437 \u0437\u043e\u043d\u044b \u0432 \u0441\u043e\u0441\u0435\u0434\u043d\u044e\u044e', blank=True)),  # noqa
                ('branch', CodeCharField(max_length=50, null=True, verbose_name='\u0432\u0435\u0442\u043a\u0430', blank=True)),
                ('external_direction', models.ForeignKey(verbose_name='\u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435', to='www.ExternalDirection')),
            ],
            options={
                'ordering': ('order',),
                'db_table': 'www_externaldirectionmarker',
                'verbose_name': '\u043c\u0430\u0440\u043a\u0435\u0440 \u0432\u043d\u0435\u0448\u043d\u0435\u0433\u043e \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f',
                'verbose_name_plural': '\u043c\u0430\u0440\u043a\u0435\u0440\u044b \u0432\u043d\u0435\u0448\u043d\u0438\u0445 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0439',
            },
        ),
        migrations.CreateModel(
            name='FaceDirection',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('text', models.CharField(max_length=255, null=True, verbose_name='\u0422\u0435\u0441\u043a\u0442', blank=True)),
                ('url', models.TextField(null=True, verbose_name='\u0421\u0441\u044b\u043b\u043a\u0430', blank=True)),
            ],
            options={
                'verbose_name': '\u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435',
                'verbose_name_plural': '\u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043d\u0430 \u043c\u043e\u0440\u0434\u0435 \u0433\u043e\u0440\u043e\u0434\u0430',  # noqa
            },
        ),
        migrations.CreateModel(
            name='GortransCityLink',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('url', models.CharField(max_length=255, verbose_name='\u0421\u0441\u044b\u043b\u043a\u0430')),
            ],
            options={
                'db_table': 'www_gortranscitylink',
                'verbose_name': '\u0441\u0441\u044b\u043b\u043a\u0430 \u043d\u0430 \u0433\u043e\u0440\u0442\u0440\u0430\u043d\u0441',
                'verbose_name_plural': '\u0441\u0441\u044b\u043b\u043a\u0438 \u043d\u0430 \u0433\u043e\u0440\u0442\u0440\u0430\u043d\u0441',
            },
        ),
        migrations.CreateModel(
            name='Holiday',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('date', models.DateField(verbose_name='\u0434\u0430\u0442\u0430 \u0441\u0447\u0438\u0442\u0430\u044e\u0449\u0430\u044f\u0441\u044f \u043f\u0440\u0430\u0437\u0434\u043d\u0438\u0447\u043d\u043e\u0439')),  # noqa
                ('title', models.CharField(default=b'', help_text='\u043d\u0435\u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u043f\u043e\u043b\u0435', max_length=100, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0440\u0430\u0437\u0434\u043d\u0438\u043a\u0430', blank=True)),  # noqa
            ],
            options={
                'verbose_name': '\u043f\u0440\u0430\u0437\u0434\u043d\u0438\u0447\u043d\u044b\u0439 \u0434\u0435\u043d\u044c',
                'verbose_name_plural': '\u043f\u0440\u0430\u0437\u0434\u043d\u0438\u0447\u043d\u044b\u0435 \u0434\u043d\u0438',
            },
        ),
        migrations.CreateModel(
            name='NameSearchIndex',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('text', models.CharField(max_length=255, db_index=True)),
                ('exact', models.BooleanField()),
                ('object_id', models.PositiveIntegerField()),
                ('content_type', models.ForeignKey(to='contenttypes.ContentType')),
            ],
        ),
        migrations.CreateModel(
            name='NotTariffTrain',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('number', RegExpField(help_text='\u043d\u043e\u043c\u0435\u0440 \u0440\u0435\u0439\u0441\u0430 \u043c\u043e\u0436\u043d\u043e \u0437\u0430\u0434\u0430\u0432\u0430\u0442\u044c \u0440\u0435\u0433\u0443\u043b\u044f\u0440\u044b\u043c \u0432\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435\u043c', unique=True, max_length=255, verbose_name='\u043d\u043e\u043c\u0435\u0440 \u0440\u0435\u0439\u0441\u0430')),  # noqa
            ],
            options={
                'verbose_name': '\u043f\u043e\u0435\u0437\u0434, \u043a\u043e\u0442\u043e\u0440\u044b\u0439 \u043d\u0435 \u0442\u0430\u0440\u0438\u0444\u0438\u0446\u0438\u0440\u0443\u0435\u0442 \u042d\u043a\u0441\u043f\u0440\u0435\u0441\u0441',  # noqa
                'verbose_name_plural': '\u043f\u043e\u0435\u0437\u0434\u0430, \u043a\u043e\u0442\u043e\u0440\u044b\u0435 \u043d\u0435 \u0442\u0430\u0440\u0438\u0444\u0438\u0446\u0438\u0440\u0443\u0435\u0442 \u042d\u043a\u0441\u043f\u0440\u0435\u0441\u0441',  # noqa
            },
        ),
        migrations.CreateModel(
            name='Page',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('code', models.CharField(unique=True, max_length=100, verbose_name='\u043a\u043e\u0434 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b')),
                ('title', models.CharField(max_length=250, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b')),
            ],
            options={
                'verbose_name': '\u043b\u043e\u0433\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430',
                'verbose_name_plural': '\u043b\u043e\u0433\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b',
            },
        ),
        migrations.CreateModel(
            name='PlatformTranslation',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('description', models.CharField(default=None, max_length=255, null=True, verbose_name='\u0413\u0434\u0435 \u0432\u0441\u0442\u0440\u0435\u0447\u0430\u0435\u0442\u0441\u044f', blank=True)),  # noqa
                ('platform', TrimmedCharField(default=None, max_length=30, null=True, verbose_name='\u043f\u043b\u0430\u0442\u0444\u043e\u0440\u043c\u0430', blank=True)),
                ('platform_ru', TrimmedCharField(default=None, max_length=30, null=True, verbose_name='\u043f\u043b\u0430\u0442\u0444\u043e\u0440\u043c\u0430 (ru)', blank=True)),
                ('platform_en', TrimmedCharField(default=None, max_length=30, null=True, verbose_name='\u043f\u043b\u0430\u0442\u0444\u043e\u0440\u043c\u0430 (en)', blank=True)),
                ('platform_tr', TrimmedCharField(default=None, max_length=30, null=True, verbose_name='\u043f\u043b\u0430\u0442\u0444\u043e\u0440\u043c\u0430 (tr)', blank=True)),
                ('platform_uk', TrimmedCharField(default=None, max_length=30, null=True, verbose_name='\u043f\u043b\u0430\u0442\u0444\u043e\u0440\u043c\u0430 (uk)', blank=True)),
            ],
            options={
                'db_table': 'www_platformtranslation',
                'verbose_name': '\u041f\u0435\u0440\u0435\u0432\u043e\u0434 \u043f\u043b\u0430\u0442\u0444\u043e\u0440\u043c\u044b',
                'verbose_name_plural': '\u041f\u0435\u0440\u0435\u0432\u043e\u0434\u044b \u043f\u043b\u0430\u0442\u0444\u043e\u0440\u043c',
            },
        ),
        migrations.CreateModel(
            name='PointSynonym',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=100, verbose_name='\u0441\u0438\u043d\u043e\u043d\u0438\u043c')),
                ('object_id', models.PositiveIntegerField()),
                ('search_type', models.CharField(default=b'synonym', max_length=20, editable=False, db_index=True, choices=[(b'synonym', '\u0441\u0438\u043d\u043e\u043d\u0438\u043c'), (b'normalized', '\u043d\u043e\u0440\u043c\u0430\u043b\u0438\u0437\u043e\u0432\u0430\u043d\u043d\u0430\u044f \u0444\u043e\u0440\u043c\u0430'), (b'tokenized', '\u0442\u043e\u043a\u0435\u043d\u044b'), (b'exact', '\u0442\u043e\u0447\u043d\u0430\u044f \u043a\u043e\u043f\u0438\u044f')])),  # noqa
                ('content_type', models.ForeignKey(to='contenttypes.ContentType')),
            ],
            options={
                'ordering': ('title',),
                'db_table': 'www_pointsynonym',
                'verbose_name': '\u0441\u0438\u043d\u043e\u043d\u0438\u043c',
                'verbose_name_plural': '\u0441\u0438\u043d\u043e\u043d\u0438\u043c\u044b',
            },
        ),
        migrations.CreateModel(
            name='PreHoliday',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('date', models.DateField(verbose_name='\u0434\u0430\u0442\u0430 \u0441\u0447\u0438\u0442\u0430\u044e\u0449\u0430\u044f\u0441\u044f \u043f\u0440\u0435\u0434\u043f\u0440\u0430\u0437\u0434\u043d\u0438\u0447\u043d\u043e\u0439')),  # noqa
                ('title', models.CharField(default=b'', help_text='\u043d\u0435\u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u043f\u043e\u043b\u0435', max_length=100, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0440\u0430\u0437\u0434\u043d\u0438\u043a\u0430', blank=True)),  # noqa
            ],
            options={
                'verbose_name': '\u043f\u0440\u0435\u0434\u043f\u0440\u0430\u0437\u0434\u043d\u0438\u0447\u043d\u044b\u0439 \u0434\u0435\u043d\u044c',
                'verbose_name_plural': '\u043f\u0440\u0435\u0434\u043f\u0440\u0430\u0437\u0434\u043d\u0438\u0447\u043d\u044b\u0435 \u0434\u043d\u0438',
            },
        ),
        migrations.CreateModel(
            name='PseudoRegion',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=255, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435')),
                ('countries', models.ManyToManyField(to='www.Country', verbose_name='\u0441\u0442\u0440\u0430\u043d\u044b', blank=True)),
            ],
            options={
                'db_table': 'www_pseudoregion',
                'verbose_name': '\u043f\u0441\u0435\u0432\u0434\u043e-\u0440\u0435\u0433\u0438\u043e\u043d',
                'verbose_name_plural': '\u043f\u0441\u0435\u0432\u0434\u043e-\u0440\u0435\u0433\u0438\u043e\u043d\u044b',
            },
        ),
        migrations.CreateModel(
            name='Redirect',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('old_url', models.CharField(unique=True, max_length=100, verbose_name='\u0421\u0442\u0430\u0440\u044b\u0439 \u0430\u0434\u0440\u0435\u0441')),
                ('new_url', models.CharField(max_length=100, verbose_name='\u041d\u043e\u0432\u044b\u0439 \u0430\u0434\u0440\u0435\u0441')),
            ],
            options={
                'verbose_name': '\u0420\u0435\u0434\u0438\u0440\u0435\u043a\u0442',
                'verbose_name_plural': '\u0420\u0435\u0434\u0438\u0440\u0435\u043a\u0442\u044b',
            },
        ),
        migrations.CreateModel(
            name='Region',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('time_zone', models.CharField(help_text='\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f \u0437\u043e\u043d\u0430 \u0432 \u043c\u0435\u0436\u0434\u0443\u043d\u0430\u0440\u043e\u0434\u043d\u043e\u043c \u0444\u043e\u0440\u043c\u0430\u0442\u0435', max_length=30, null=True, verbose_name='\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f \u0437\u043e\u043d\u0430')),  # noqa
                ('_geo_id', models.IntegerField(default=None, unique=True, null=True, verbose_name='geo ID', blank=True)),
                ('_kladr_id', models.CharField(default=None, editable=False, max_length=50, blank=True, null=True, verbose_name='kladr ID')),
                ('hidden', models.BooleanField(default=False, verbose_name='\u043d\u0435 \u043f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u043d\u0438\u0433\u0434\u0435!')),
                ('koatuu', CodeCharField(null=True, default=None, max_length=40, blank=True, help_text="\u0434\u0435\u0440\u0436\u0430\u0301\u0432\u043d\u0438\u0439 \u043a\u043b\u0430\u0441\u0438\u0444\u0456\u043a\u0430\u0301\u0442\u043e\u0440 \u043e\u0431'\u0454\u0301\u043a\u0442\u0456\u0432 \u0430\u0434\u043c\u0456\u043d\u0456\u0441\u0442\u0440\u0430\u0442\u0438\u0301\u0432\u043d\u043e-\u0442\u0435\u0440\u0438\u0442\u043e\u0440\u0456\u0430\u0301\u043b\u044c\u043d\u043e\u0433\u043e \u0443\u0301\u0441\u0442\u0440\u043e\u044e \u0423\u043a\u0440\u0430\u0457\u0301\u043d\u0438", unique=True, verbose_name='\u043a\u043e\u0434 \u041a\u041e\u0410\u0422\u0423\u0423')),  # noqa
                ('agent_geo_id', models.IntegerField(default=None, null=True, verbose_name='agent Geo ID', blank=True)),
                ('disputed_territory', models.BooleanField(default=False, verbose_name='\u0441\u043f\u043e\u0440\u043d\u0430\u044f \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u044f')),
                ('modified_at', models.DateTimeField(auto_now=True, verbose_name='\u0414\u0430\u0442\u0430-\u0432\u0440\u0435\u043c\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f')),
                ('title', TrimmedCharField(default=None, max_length=100, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435')),
                ('title_ru', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (ru)', blank=True)),  # noqa
                ('title_en', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (en)', blank=True)),  # noqa
                ('title_tr', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (tr)', blank=True)),  # noqa
                ('title_uk', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (uk)', blank=True)),  # noqa
                ('country', models.ForeignKey(verbose_name='\u0441\u0442\u0440\u0430\u043d\u0430', to='www.Country')),
            ],
            options={
                'db_table': 'www_region',
                'verbose_name': '\u043e\u0431\u043b\u0430\u0441\u0442\u044c',
                'verbose_name_plural': '\u043e\u0431\u043b\u0430\u0441\u0442\u0438',
            },
            bases=(models.Model, TimeZoneMixin, Point),
        ),
        migrations.CreateModel(
            name='RegionWhiteList',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('regions', models.ManyToManyField(to='www.Region', verbose_name='\u043e\u0431\u043b\u0430\u0441\u0442\u0438', blank=True)),
            ],
            options={
                'verbose_name': '\u0431\u0435\u043b\u044b\u0439 \u0441\u043f\u0438\u0441\u043e\u043a \u043e\u0431\u043b\u0430\u0441\u0442\u0435\u0439 \u0434\u043b\u044f \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0430',  # noqa
                'verbose_name_plural': '\u0431\u0435\u043b\u044b\u0439 \u0441\u043f\u0438\u0441\u043e\u043a \u043e\u0431\u043b\u0430\u0441\u0442\u0435\u0439 \u0434\u043b\u044f \u044d\u043a\u0441\u043f\u043e\u0440\u0442\u0430',  # noqa
            },
        ),
        migrations.CreateModel(
            name='ReplaceException',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
            ],
            options={
                'db_table': 'www_replaceexception',
                'verbose_name': '\u0438\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u043a\u043e\u043b\u0434\u0443\u043d\u0441\u0442\u0432\u0430',
                'verbose_name_plural': '\u0438\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u043a\u043e\u043b\u0434\u0443\u043d\u0441\u0442\u0432\u0430',
            },
        ),
        migrations.CreateModel(
            name='Route',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('comment', models.TextField(default='', null=True, verbose_name='\u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439', blank=True)),
                ('script_protected', models.BooleanField(default=True, verbose_name='\u043d\u0435 \u043c\u0435\u043d\u044f\u0442\u044c \u043f\u0440\u0438 \u0438\u043c\u043f\u043e\u0440\u0442\u0435')),
                ('route_uid', models.CharField(help_text='\u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0434\u043b\u044f \u043e\u0434\u043d\u043e\u0437\u043d\u0430\u0447\u043d\u043e\u0433\u043e \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u044f \u0440\u0435\u0439\u0441\u0430 \u0438\u0437 \u0438\u043c\u043f\u043e\u0440\u0442\u0430', max_length=100, verbose_name='\u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440')),  # noqa
                ('hidden', models.BooleanField(default=False, verbose_name='\u0440\u0435\u0439\u0441 \u0441\u043a\u0440\u044b\u0442')),
                ('style', models.TextField(default=None, null=True, verbose_name='\u0441\u0442\u0438\u043b\u044c \u043b\u0438\u043d\u0438\u0438 \u043c\u0435\u0442\u0440\u043e', blank=True)),
                ('modified_at', models.DateTimeField(auto_now=True, verbose_name='\u0414\u0430\u0442\u0430-\u0432\u0440\u0435\u043c\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f')),
            ],
            options={
                'abstract': False,
                'db_table': 'www_route',
                'verbose_name': '\u0440\u0435\u0439\u0441',
                'verbose_name_plural': '\u0440\u0435\u0439\u0441\u044b',
            },
        ),
        migrations.CreateModel(
            name='Route2Company',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('number', models.CharField(max_length=100, verbose_name='\u043d\u043e\u043c\u0435\u0440 \u0440\u0435\u0439\u0441\u0430')),
                ('company', models.ForeignKey(verbose_name='\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u044f-\u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a', to='www.Company')),
            ],
            options={
                'ordering': ('number', 'company'),
                'verbose_name': '\u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0435 \u043d\u043e\u043c\u0435\u0440\u0430 \u0440\u0435\u0439\u0441\u0430 \u0438 \u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0438',  # noqa
                'verbose_name_plural': '\u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u044f \u043d\u043e\u043c\u0435\u0440\u043e\u0432 \u0416\u0414 \u0440\u0435\u0439\u0441\u043e\u0432 \u0438 \u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0439',  # noqa
            },
        ),
        migrations.CreateModel(
            name='RouteImportInfo',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('number', models.CharField(max_length=100, verbose_name='\u043d\u043e\u043c\u0435\u0440', db_index=True)),
                ('route_uid', models.CharField(null=True, default=None, max_length=100, blank=True, help_text='\u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0434\u043b\u044f \u043e\u0434\u043d\u043e\u0437\u043d\u0430\u0447\u043d\u043e\u0433\u043e \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u044f \u0440\u0435\u0439\u0441\u0430 \u0438\u0437 \u0438\u043c\u043f\u043e\u0440\u0442\u0430', unique=True, verbose_name='\u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440')),  # noqa
            ],
            options={
                'ordering': ('supplier__id', 'number'),
                'verbose_name': '\u0434\u043e\u043f. \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0440\u0435\u0439\u0441\u0435',
                'verbose_name_plural': '\u0434\u043e\u043f. \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0440\u0435\u0439\u0441\u0435',
            },
        ),
        migrations.CreateModel(
            name='RouteMapBlacklist',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('number', TrimmedCharField(unique=True, max_length=100, verbose_name='\u043d\u043e\u043c\u0435\u0440 \u0440\u0435\u0439\u0441\u0430')),
            ],
            options={
                'verbose_name': '\u0440\u0435\u0439\u0441, \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043d\u044b\u0439 \u043a \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044e \u043d\u0430 \u043a\u0430\u0440\u0442\u0435',  # noqa
                'verbose_name_plural': '\u0440\u0435\u0439\u0441\u044b, \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043d\u044b\u0435 \u043a \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044e \u043d\u0430 \u043a\u0430\u0440\u0442\u0435',  # noqa
            },
        ),
        migrations.CreateModel(
            name='RoutePath',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('for_two_directions', models.BooleanField(verbose_name='\u0434\u043b\u044f \u0434\u0432\u0443\u0445 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0439')),
                ('data_direct', models.TextField(help_text='json-\u0434\u0430\u043d\u043d\u044b\u0435 \u0433\u0435\u043e\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430', null=True, verbose_name='\u0434\u0430\u043d\u043d\u044b\u0435 \u043f\u0440\u044f\u043c\u043e\u0433\u043e \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f', blank=True)),  # noqa
                ('data_back', models.TextField(help_text='json-\u0434\u0430\u043d\u043d\u044b\u0435 \u0433\u0435\u043e\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430', null=True, verbose_name='\u0434\u0430\u043d\u043d\u044b\u0435 \u043e\u0431\u0440\u0430\u0442\u043d\u043e\u0433\u043e \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f', blank=True)),  # noqa
                ('status_direct', models.IntegerField(default=0, verbose_name='\u0441\u0442\u0430\u0442\u0443\u0441 \u043f\u0440\u044f\u043c\u043e\u0433\u043e \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f', choices=[(0, '\u043d\u0435 \u0433\u0435\u043e\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u043e'), (1, '\u0433\u0435\u043e\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u043e'), (2, '\u0441\u0442\u0430\u043d\u0446\u0438\u0438 \u043f\u0435\u0440\u0435\u0434\u0432\u0438\u043d\u0443\u0442\u044b')])),  # noqa
                ('status_back', models.IntegerField(default=0, verbose_name='\u0441\u0442\u0430\u0442\u0443\u0441 \u043e\u0431\u0440\u0430\u0442\u043d\u043e\u0433\u043e \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f', choices=[(0, '\u043d\u0435 \u0433\u0435\u043e\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u043e'), (1, '\u0433\u0435\u043e\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u043e'), (2, '\u0441\u0442\u0430\u043d\u0446\u0438\u0438 \u043f\u0435\u0440\u0435\u0434\u0432\u0438\u043d\u0443\u0442\u044b')])),  # noqa
            ],
            options={
                'verbose_name': '\u0433\u0435\u043e\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0443\u0447\u0430\u0441\u0442\u043e\u043a \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430',  # noqa
                'verbose_name_plural': '\u0433\u0435\u043e\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0435 \u0443\u0447\u0430\u0441\u0442\u043a\u0438 \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430',  # noqa
            },
        ),
        migrations.CreateModel(
            name='RouteUidMap',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('new_uid', models.CharField(max_length=100, verbose_name='\u0421\u0442\u0430\u0440\u044b\u0439 uid \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430', db_index=True)),
                ('old_uid', models.CharField(max_length=100, verbose_name='\u041d\u043e\u0432\u044b\u0439 uid \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430', db_index=True)),
            ],
            options={
                'verbose_name': '\u0421\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0435 \u0441\u0442\u0430\u0440\u043e\u0433\u043e \u0438 \u043d\u043e\u0432\u043e\u0433\u043e uid-\u043e\u0432 \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430',  # noqa
                'verbose_name_plural': '\u0421\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0435 \u0441\u0442\u0430\u0440\u044b\u0445 \u0438 \u043d\u043e\u0432\u044b\u0445 uid-\u043e\u0432 \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u043e\u0432',  # noqa
            },
        ),
        migrations.CreateModel(
            name='RThread',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('old_thread_number', models.CharField(default=b'', max_length=100, verbose_name='\u0421\u0442\u0430\u0440\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u043d\u0438\u0442\u043a\u0438', db_column=b'number', blank=True)),  # noqa
                ('title', models.CharField(max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435')),
                ('is_manual_title', models.BooleanField(default=True, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u043e \u0432\u0440\u0443\u0447\u043d\u0443\u044e')),  # noqa
                ('title_tr', TrimmedCharField(db_index=True, max_length=100, null=True, verbose_name='Turkish title', blank=True)),
                ('title_tr_author', CodeCharField(max_length=100, null=True)),
                ('title_uk', TrimmedCharField(db_index=True, max_length=100, null=True, verbose_name='\u0423\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u043e\u0435 \u0440\u0443\u0447\u043d\u043e\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435', blank=True)),  # noqa
                ('title_uk_author', CodeCharField(max_length=100, null=True)),
                ('title_common', models.CharField(max_length=500, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435')),
                ('title_short', models.CharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043a\u043e\u0440\u043e\u0442\u043a\u043e\u0435', blank=True)),  # noqa
                ('uid', models.CharField(null=True, max_length=100, blank=True, help_text='\u0440\u0430\u0441\u0441\u0447\u0438\u0442\u044b\u0432\u0430\u0435\u0442\u0441\u044f \u0441\u043a\u0440\u0438\u043f\u0442\u043e\u043c', unique=True, verbose_name='\u043d\u043e\u043c\u0435\u0440 \u0432 \u043b\u0430\u0442\u0438\u043d\u0438\u0446\u0435')),  # noqa
                ('tz_start_time', models.TimeField(verbose_name='\u0432\u0440\u0435\u043c\u044f \u0432\u044b\u0435\u0437\u0434\u0430(\u0432\u044b\u043b\u0435\u0442\u0430) \u0441 \u0443\u0447\u0435\u0442\u043e\u043c \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439 \u0437\u043e\u043d\u044b')),  # noqa
                ('time_zone', models.CharField(max_length=30, verbose_name='\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f \u0437\u043e\u043d\u0430')),
                ('period_int', models.IntegerField(default=None, null=True, verbose_name='\u0418\u043d\u0442\u0435\u0440\u0432\u0430\u043b \u043c\u0435\u0436\u0434\u0443 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f\u043c\u0438 \u0440\u0435\u0439\u0441\u043e\u0432, \u0432 \u043c\u0438\u043d\u0443\u0442\u0430\u0445', blank=True)),  # noqa
                ('begin_time', models.TimeField(default=None, null=True, verbose_name='\u041d\u0430\u0447\u0430\u043b\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430', blank=True)),
                ('end_time', models.TimeField(default=None, null=True, verbose_name='\u041a\u043e\u043d\u0435\u0446 \u043f\u0435\u0440\u0438\u043e\u0434\u0430', blank=True)),
                ('density', TrimmedCharField(default=b'', max_length=200, verbose_name='\u0420\u0435\u0433\u0443\u043b\u044f\u0440\u043d\u043e\u0441\u0442\u044c \u0445\u043e\u0436\u0434\u0435\u043d\u0438\u044f \u0432 \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b\u0435', blank=True)),  # noqa
                ('pseudo_data', models.TextField(default=b'', verbose_name='\u0414\u0430\u043d\u043d\u044b\u0435 \u0434\u043b\u044f \u043f\u043e\u0441\u0442\u0440\u043e\u0435\u043d\u0438\u044f \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u044f \u0434\u043b\u044f \u043e\u0431\u0440\u0430\u0442\u043d\u044b\u0445 \u043f\u0441\u0435\u0432\u0434\u043e\u0440\u0435\u0439\u0441\u043e\u0432', blank=True)),  # noqa
                ('comment', TrimmedTextField(default=b'', verbose_name='\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439', blank=True)),
                ('year_days', ThreadCalendarField(default=b'000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000', verbose_name='\u0434\u043d\u0438 \u0445\u043e\u0436\u0434\u0435\u043d\u0438\u0439', db_column=b'tz_year_days')),  # noqa
                ('has_extrapolatable_mask', models.BooleanField(default=True, verbose_name='\u044d\u043a\u0441\u0442\u0440\u0430\u043f\u043e\u043b\u0438\u0440\u0443\u0435\u043c\u044b\u0435 \u0434\u043d\u0438 \u0445\u043e\u0436\u0434\u0435\u043d\u0438\u044f')),  # noqa
                ('changed', models.BooleanField(default=False, verbose_name='\u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c \u043f\u0435\u0440\u0435\u0441\u0447\u0435\u0442 \u0442\u0430\u0431\u043b\u043e \u0438 \u043f\u043e\u0438\u0441\u043a\u0430')),  # noqa
                ('path_and_time_unchanged', models.BooleanField(default=False, help_text='\u043c\u043e\u0436\u043d\u043e \u043d\u0435 \u043f\u0435\u0440\u0435\u0441\u0447\u0438\u0442\u044b\u0432\u0430\u0442\u044c \u043d\u043e\u0434\u0435\u0440\u043e\u0442', verbose_name='\u041f\u0443\u0442\u044c \u0438 \u0432\u0440\u0435\u043c\u044f \u043d\u0435 \u043c\u0435\u043d\u044f\u043b\u0438\u0441\u044c')),  # noqa
                ('recount_station_schedule', models.BooleanField(default=False, verbose_name='\u043f\u0435\u0440\u0435\u0441\u0447\u0438\u0442\u0430\u0442\u044c \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043d\u0430 \u0441\u0442\u0430\u043d\u0446\u0438\u044f\u0445')),  # noqa
                ('template_text', models.CharField(default=None, max_length=200, blank=True, help_text='\u0448\u0430\u0431\u043b\u043e\u043d\u044b \u0434\u043d\u0435\u0439 \u0445\u043e\u0436\u0434\u0435\u043d\u0438\u0439 \u0447\u0435\u0440\u0435\u0437 \u0442\u043e\u0447\u043a\u0443 \u0441 \u0437\u0430\u043f\u044f\u0442\u043e\u0439, \u0435\u0441\u043b\u0438 \u0435\u0441\u0442\u044c \u043f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u0441\u0443\u0442\u043e\u043a \u0432 \u0440\u0435\u0439\u0441\u0435, \u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, "\u0435\u0436\u0435\u0434\u043d\u0435\u0432\u043d\u043e;\u0435\u0436\u0435\u0434\u043d\u0435\u0432\u043d\u043e".', null=True, verbose_name='\u0422\u0435\u043a\u0441\u0442 \u0448\u0430\u0431\u043b\u043e\u043d\u043e\u0432 \u0434\u043d\u0435\u0439 \u0445\u043e\u0436\u0434\u0435\u043d\u0438\u0439(\u0441\u0442\u0430\u0440\u043e\u0435)')),  # noqa
                ('template_start', models.DateField(null=True, verbose_name='\u041d\u0430\u0447\u0430\u043b\u043e \u0445\u043e\u0436\u0434\u0435\u043d\u0438\u044f \u0448\u0430\u0431\u043b\u043e\u043d\u0430', blank=True)),  # noqa
                ('template_end', models.DateField(null=True, verbose_name='\u041a\u043e\u043d\u0435\u0446 \u0445\u043e\u0436\u0434\u0435\u043d\u0438\u044f \u0448\u0430\u0431\u043b\u043e\u043d\u0430', blank=True)),  # noqa
                ('template_code', models.CharField(default=None, max_length=100, null=True, verbose_name='\u041a\u043e\u0434 \u0448\u0430\u0431\u043b\u043e\u043d\u0430 \u0434\u043d\u0435\u0439 \u0445\u043e\u0436\u0434\u0435\u043d\u0438\u0439', blank=True)),  # noqa
                ('translated_manual_days_texts', models.TextField(default=b'', verbose_name='\u0422\u0435\u043a\u0441\u0442\u044b \u0434\u043d\u0435\u0439 \u0445\u043e\u0436\u0434\u0435\u043d\u0438\u044f \u0441\u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0435 \u0438\u0437 \u043a\u043e\u0434\u0430 \u0448\u0430\u0431\u043b\u043e\u043d\u0430 \u0410.\u0424.', blank=True)),  # noqa
                ('translated_days_texts', models.TextField(default=b'', verbose_name='\u041f\u0440\u0435\u0434\u0440\u0430\u0441\u0447\u0438\u0442\u0430\u043d\u043d\u044b\u0435 \u0442\u0435\u043a\u0441\u0442\u044b \u0434\u043d\u0435\u0439 \u0445\u043e\u0436\u0434\u0435\u043d\u0438\u044f', blank=True)),  # noqa
                ('translated_except_texts', models.TextField(default=b'', verbose_name='\u041f\u0440\u0435\u0434\u0440\u0430\u0441\u0447\u0438\u0442\u0430\u043d\u043d\u044b\u0435 \u0442\u0435\u043a\u0441\u0442\u044b \u0438\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0439 \u0434\u043d\u0435\u0439 \u0445\u043e\u0436\u0434\u0435\u043d\u0438\u044f', blank=True)),  # noqa
                ('import_uid', models.CharField(null=True, default=None, editable=False, max_length=255, blank=True, unique=True, verbose_name='\u0443\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u043d\u0438\u0442\u043a\u0438 \u0433\u0435\u043d\u0435\u0440\u0438\u0440\u0443\u0435\u043c\u044b\u0439 \u043d\u0430 \u043e\u0441\u043d\u043e\u0432\u0435 \u0440\u0435\u0439\u0441\u0430 \u043d\u0438\u0442\u043a\u0438')),  # noqa
                ('is_circular', models.BooleanField(default=False, verbose_name='\u043d\u0438\u0442\u043a\u0430 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043a\u043e\u043b\u044c\u0446\u0435\u0432\u043e\u0439')),  # noqa
                ('hidden', models.BooleanField(default=False, verbose_name='\u043d\u0438\u0442\u043a\u0430 \u0441\u043a\u0440\u044b\u0442\u0430')),
                ('is_combined', models.BooleanField(default=False, verbose_name='\u041d\u0438\u0442\u043a\u0430 \u0441\u043e\u0433\u043b\u0430\u0441\u043e\u0432\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u043e\u0435\u0437\u0434\u0430')),  # noqa
                ('show_in_alldays_pages', models.BooleanField(default=True, verbose_name='\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u0432 \u043f\u043e\u0438\u0441\u043a\u0435 \u0438 \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0438 \u043d\u0430 \u0432\u0441\u0435 \u0434\u043d\u0438')),  # noqa
                ('number', models.CharField(db_column=b'route_number', default='', max_length=100, blank=True, verbose_name='\u043d\u043e\u043c\u0435\u0440', db_index=True)),
                ('hidden_number', models.CharField(default='', max_length=100, verbose_name='\u0441\u043a\u0440\u044b\u0442\u044b\u0439 \u043d\u043e\u043c\u0435\u0440', blank=True)),
                ('express_type', models.CharField(default=None, choices=[(b'', '\u041e\u0431\u044b\u0447\u043d\u044b\u0439 \u0440\u0435\u0439\u0441'), (b'express', '\u042d\u043a\u0441\u043f\u0440\u0435\u0441\u0441'), (b'aeroexpress', '\u0410\u044d\u0440\u043e\u044d\u043a\u0441\u043f\u0440\u0435\u0441\u0441')], max_length=20, blank=True, null=True, verbose_name='\u0442\u0438\u043f \u044d\u043a\u0441\u043f\u0440\u0435\u0441\u0441\u0430')),  # noqa
                ('reversed_number', models.CharField(default='', verbose_name='\u043d\u043e\u043c\u0435\u0440 \u0434\u043b\u044f \u043f\u043e\u0438\u0441\u043a\u0430', max_length=100, editable=False, db_index=True)),  # noqa
                ('ordinal_number', models.PositiveIntegerField(verbose_name='\u041f\u043e\u0440\u044f\u0434\u043a\u043e\u0432\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u043d\u0438\u0442\u043a\u0438, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u043f\u0440\u0438 \u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438 uid')),  # noqa
                ('modified_at', models.DateTimeField(auto_now=True, verbose_name='\u0414\u0430\u0442\u0430-\u0432\u0440\u0435\u043c\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f')),
                ('path_key', models.TextField(default=None, null=True, verbose_name='\u041a\u043b\u044e\u0447 \u043f\u0443\u0442\u0438', blank=True)),
                ('basic_thread', models.ForeignKey(related_name='thread_changes', default=None, blank=True, to='www.RThread', null=True, verbose_name='\u043e\u0441\u043d\u043e\u0432\u043d\u0430\u044f \u043d\u0438\u0442\u043a\u0430')),  # noqa
                ('company', models.ForeignKey(default=None, blank=True, to='www.Company', null=True, verbose_name='\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u044f-\u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a')),  # noqa
                ('express_lite', models.ForeignKey(default=None, blank=True, to='www.ExpressTypeLite', null=True, verbose_name='\u043f\u043e\u0434\u0442\u0438\u043f \u044d\u043a\u0441\u043f\u0440\u0435\u0441\u0441\u0430')),  # noqa
                ('route', models.ForeignKey(verbose_name='\u0440\u0435\u0439\u0441', to='www.Route')),
            ],
            options={
                'abstract': False,
                'db_table': 'www_rthread',
                'verbose_name': '\u043d\u0438\u0442\u043a\u0430',
                'verbose_name_plural': '\u043d\u0438\u0442\u043a\u0438',
            },
        ),
        migrations.CreateModel(
            name='RThreadType',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=100, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435')),
                ('code', models.CharField(unique=True, max_length=100, verbose_name='\u043a\u043e\u0434')),
            ],
            options={
                'ordering': ('id',),
                'db_table': 'www_rthreadtype',
                'verbose_name': '\u0442\u0438\u043f \u043d\u0438\u0442\u043a\u0438',
                'verbose_name_plural': '\u0442\u0438\u043f\u044b \u043d\u0438\u0442\u043e\u043a',
            },
        ),
        migrations.CreateModel(
            name='RThreadUidMap',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('new_uid', models.CharField(max_length=100, verbose_name='\u0421\u0442\u0430\u0440\u044b\u0439 uid \u043d\u0438\u0442\u043a\u0438', db_index=True)),
                ('old_uid', models.CharField(max_length=100, verbose_name='\u041d\u043e\u0432\u044b\u0439 uid \u043d\u0438\u0442\u043a\u0438', db_index=True)),
            ],
            options={
                'verbose_name': '\u0421\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0435 \u0441\u0442\u0430\u0440\u043e\u0433\u043e \u0438 \u043d\u043e\u0432\u043e\u0433\u043e uid-\u043e\u0432 \u043d\u0438\u0442\u043a\u0438',  # noqa
                'verbose_name_plural': '\u0421\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0435 \u0441\u0442\u0430\u0440\u044b\u0445 \u0438 \u043d\u043e\u0432\u044b\u0445 uid-\u043e\u0432 \u043d\u0438\u0442\u043e\u043a',  # noqa
            },
        ),
        migrations.CreateModel(
            name='RTStation',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('tz_arrival', models.IntegerField(help_text='\u0440\u0430\u0441\u0441\u0442. \u043e\u0442 \u043d\u0430\u0447. \u043c\u0430\u0440\u0448\u0440. \u0434\u043e \u043f\u0440\u0438\u0431. (\u0432 \u043c\u0438\u043d\u0443\u0442\u0430\u0445). \u041f\u0440\u0438\u0431\u044b\u0442\u0438\u0435 \u043d\u0430 \u043f\u0435\u0440\u0432\u0443\u044e \u0441\u0442\u0430\u043d\u0446\u0438\u044e \u0437\u0430\u043f\u043e\u043b\u043d\u044f\u0442\u044c \u043d\u0435\u043b\u044c\u0437\u044f(\u043e\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c)', null=True, blank=True)),  # noqa
                ('tz_departure', models.IntegerField(help_text='\u0440\u0430\u0441\u0441\u0442. \u043e\u0442 \u043d\u0430\u0447. \u043c\u0430\u0440\u0448\u0440. \u0434\u043e \u043e\u0442\u043f\u0440. (\u0432 \u043c\u0438\u043d\u0443\u0442\u0430\u0445). \u041e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0441 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0439 \u0441\u0442\u0430\u043d\u0446\u0438\u0438 \u0437\u0430\u043f\u043e\u043b\u043d\u044f\u0442\u044c \u043d\u0435\u043b\u044c\u0437\u044f(\u043e\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c)', null=True, blank=True)),  # noqa
                ('time_zone', models.CharField(max_length=30, verbose_name='\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f \u0437\u043e\u043d\u0430')),
                ('arrival_code_sharing', models.BooleanField(default=False, verbose_name='\u043f\u0440\u0438\u0431\u044b\u0442\u0438\u0435 code sharing')),
                ('departure_code_sharing', models.BooleanField(default=False, verbose_name='\u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 code sharing')),
                ('arrival_subdir', models.CharField(max_length=100, null=True, verbose_name='arr_subdir', blank=True)),
                ('departure_subdir', models.CharField(max_length=100, null=True, verbose_name='dep_subdir', blank=True)),
                ('is_from_subdir', models.BooleanField(default=True, help_text='\u043e\u0442 \u041c\u043e\u0441\u043a\u0432\u044b', verbose_name='\u043f\u043e\u0434\u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 "\u0442\u0443\u0434\u0430"')),  # noqa
                ('is_technical_stop', models.BooleanField(default=False, help_text='\u0442\u0435\u0445\u043d\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430', verbose_name='\u0422\u041e')),  # noqa
                ('platform', TrimmedCharField(default=None, max_length=20, null=True, verbose_name='\u043f\u043b\u0430\u0442\u0444\u043e\u0440\u043c\u0430', blank=True)),
                ('is_virtual_end', models.BooleanField(default=False, verbose_name='\u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0432\u0438\u0440\u0442\u0443\u0430\u043b\u044c\u043d\u043e\u0439 \u043a\u043e\u043d\u0435\u0447\u043d\u043e\u0439 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u043e\u0439')),  # noqa
                ('is_fuzzy', models.BooleanField(default=False, verbose_name='\u043d\u0435\u0447\u0435\u0442\u043a\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f/\u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f')),  # noqa
                ('is_searchable_to', models.BooleanField(default=True, verbose_name='\u0438\u0441\u043a\u0430\u0442\u044c \u0434\u043e \u0441\u0442\u0430\u043d\u0446\u0438\u0438')),
                ('is_searchable_from', models.BooleanField(default=True, verbose_name='\u0438\u0441\u043a\u0430\u0442\u044c \u043e\u0442 \u0441\u0442\u0430\u043d\u0446\u0438\u0438')),
                ('in_station_schedule', models.BooleanField(default=True, verbose_name='\u0432 \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0438 \u043f\u043e \u0441\u0442\u0430\u043d\u0446\u0438\u0438')),  # noqa
                ('in_thread', models.BooleanField(default=True, verbose_name='\u043f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u043d\u0430 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435 \u043d\u0438\u0442\u043a\u0438')),  # noqa
                ('is_combined', models.BooleanField(default=False, verbose_name='\u0421\u0442\u0430\u043d\u0446\u0438\u044f \u0441\u043e\u0433\u043b\u0430\u0441\u043e\u0432\u0430\u043d\u043d\u043e\u0439 \u043f\u0435\u0440\u0435\u0441\u0430\u0434\u043a\u0438')),  # noqa
                ('arrival_direction', models.ForeignKey(related_name='arrival_rtstation_set', blank=True, to='www.Direction', help_text='\u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f', null=True, verbose_name='arr_direction')),  # noqa
            ],
            options={
                'ordering': ('id',),
                'db_table': 'www_rtstation',
                'verbose_name': '\u0441\u0442\u0430\u043d\u0446\u0438\u044f \u043d\u0438\u0442\u043a\u0438',
                'verbose_name_plural': '\u0441\u0442\u0430\u043d\u0446\u0438\u0438 \u043d\u0438\u0442\u043e\u043a',
            },
        ),
        migrations.CreateModel(
            name='ScheduleExclusion',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('number', TrimmedCharField(help_text='\u0415\u0441\u043b\u0438 \u043d\u043e\u043c\u0435\u0440\u0430 \u043d\u0435\u0442, \u0431\u0435\u0440\u0443\u0442\u0441\u044f \u0432\u0441\u0435 \u0440\u0435\u0439\u0441\u044b \u043c\u0435\u0436\u0434\u0443 \u0441\u0442\u0430\u043d\u0446\u0438\u044f\u043c\u0438', max_length=255, null=True, verbose_name='\u041d\u043e\u043c\u0435\u0440 \u0440\u0435\u0439\u0441\u0430', blank=True)),  # noqa
                ('departure', models.TimeField(null=True, verbose_name='\u041e\u043f\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0441 \u043d\u0430\u0447\u0430\u043b\u044c\u043d\u043e\u0439 \u0441\u0442\u0430\u043d\u0446\u0438\u0438', blank=True)),  # noqa
                ('departure_interval', models.TimeField(default=None, null=True, verbose_name='\u041a\u043e\u043d\u0435\u0446 \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b\u0430 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f', blank=True)),  # noqa
            ],
            options={
                'db_table': 'importinfo_scheduleexclusion',
                'verbose_name': '\u0418\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u0438\u0437 \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u043f\u043e \u0441\u0442\u0430\u043d\u0446\u0438\u0438',  # noqa
                'verbose_name_plural': '\u0418\u0441\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u0438\u0437 \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u043f\u043e \u0441\u0442\u0430\u043d\u0446\u0438\u0438',  # noqa
            },
        ),
        migrations.CreateModel(
            name='Setting',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', TrimmedCharField(max_length=255, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435')),
                ('code', CodeCharField(max_length=255, verbose_name='\u041a\u043e\u0434', validators=[django.core.validators.RegexValidator('(?u)^[A-Z][A-Z_0-9]*$', '\u041a\u043e\u0434 \u0434\u043e\u043b\u0436\u0435\u043d \u043d\u0430\u0447\u0438\u043d\u0430\u0442\u044c\u0441\u044f \u0441 \u0431\u0443\u043a\u0432\u044b, \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u044b\u0435 \u0441\u0438\u043c\u0432\u043e\u043b\u044b [A-Z_0-9]')])),  # noqa
                ('type', models.CharField(default=b'str', max_length=20, verbose_name='\u0422\u0438\u043f', choices=[(b'int', '\u0426\u0435\u043b\u043e\u0435'), (b'float', '\u0427\u0438\u0441\u043b\u043e \u0441 \u043f\u043b\u0430\u0432\u0430\u044e\u0449\u0435\u0439 \u0442\u043e\u0447\u043a\u043e\u0439'), (b'str', '\u0421\u0442\u0440\u043e\u043a\u0430')])),  # noqa
                ('value', models.CharField(default=b'', max_length=1024, verbose_name='\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435', blank=True)),
                ('help_text', models.TextField(default=b'', max_length=1024, null=True, verbose_name='\u041f\u043e\u0434\u0441\u043a\u0430\u0437\u043a\u0430', blank=True)),
            ],
            options={
                'verbose_name': '\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430',
                'verbose_name_plural': '\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438',
            },
        ),
        migrations.CreateModel(
            name='Settlement',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('suggest_order', models.IntegerField(default=100, help_text='\u0441\u043d\u0430\u0447\u0430\u043b\u0430 \u0432\u044b\u0432\u043e\u0434\u044f\u0442\u0441\u044f \u0433\u043e\u0440\u043e\u0434\u0430 \u0441 \u043c\u0435\u043d\u044c\u0448\u0438\u043c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435\u043c', verbose_name='\u043f\u043e\u0440\u044f\u0434\u043e\u043a \u0432 \u0441\u0430\u0434\u0436\u0435\u0441\u0442\u0430\u0445')),  # noqa
                ('title_ru_preposition_v_vo_na', TrimmedCharField(default=None, max_length=2, null=True, verbose_name='\u043f\u0440\u0435\u0434\u043b\u043e\u0433 (\u0432, \u0432\u043e, \u043d\u0430)', blank=True)),  # noqa
                ('title_ru_genitive', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (\u0440\u043e\u0434. \u043f\u0430\u0434\u0435\u0436)', blank=True)),  # noqa
                ('title_ru_accusative', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (\u0432\u0438\u043d. \u043f\u0430\u0434\u0435\u0436)', blank=True)),  # noqa
                ('title_ru_locative', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (\u043c\u0435\u0441\u0442\u043d. \u043f\u0430\u0434\u0435\u0436)', blank=True)),  # noqa
                ('time_zone', models.CharField(help_text='\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f \u0437\u043e\u043d\u0430 \u0432 \u043c\u0435\u0436\u0434\u0443\u043d\u0430\u0440\u043e\u0434\u043d\u043e\u043c \u0444\u043e\u0440\u043c\u0430\u0442\u0435', max_length=30, verbose_name='\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f \u0437\u043e\u043d\u0430')),  # noqa
                ('phone_info', models.CharField(default=None, max_length=20, null=True, verbose_name='\u0442\u0435\u043b. \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u043e\u0439', blank=True)),
                ('phone_info_short', models.CharField(default=None, max_length=20, null=True, verbose_name='\u043a\u043e\u0440\u043e\u0442\u043a\u0438\u0439 \u0442\u0435\u043b. \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u043e\u0439', blank=True)),  # noqa
                ('_geo_id', models.IntegerField(default=None, unique=True, null=True, verbose_name='geo ID', blank=True)),
                ('_kladr_id', models.CharField(default=None, editable=False, max_length=50, blank=True, null=True, verbose_name='kladr ID')),
                ('sirena_id', CodeCharField(null=True, default=None, max_length=50, blank=True, unique=True, verbose_name='\u043a\u043e\u0434 \u0432 "Sirena"')),
                ('iata', CodeCharField(null=True, default=None, max_length=20, blank=True, unique=True, verbose_name='\u043a\u043e\u0434 IATA')),
                ('koatuu', CodeCharField(null=True, default=None, max_length=40, blank=True, help_text="\u0434\u0435\u0440\u0436\u0430\u0301\u0432\u043d\u0438\u0439 \u043a\u043b\u0430\u0441\u0438\u0444\u0456\u043a\u0430\u0301\u0442\u043e\u0440 \u043e\u0431'\u0454\u0301\u043a\u0442\u0456\u0432 \u0430\u0434\u043c\u0456\u043d\u0456\u0441\u0442\u0440\u0430\u0442\u0438\u0301\u0432\u043d\u043e-\u0442\u0435\u0440\u0438\u0442\u043e\u0440\u0456\u0430\u0301\u043b\u044c\u043d\u043e\u0433\u043e \u0443\u0301\u0441\u0442\u0440\u043e\u044e \u0423\u043a\u0440\u0430\u0457\u0301\u043d\u0438", unique=True, verbose_name='\u043a\u043e\u0434 \u041a\u041e\u0410\u0422\u0423\u0423')),  # noqa
                ('big_city', models.BooleanField(default=False, verbose_name='\u0433\u043e\u0440\u043e\u0434 \u043d\u0430 \u0443\u0440\u043e\u0432\u043d\u0435 \u0441\u0442\u043e\u043b\u0438\u0446\u044b')),  # noqa
                ('hidden', models.BooleanField(default=False, verbose_name='\u043d\u0435 \u043f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u043d\u0438\u0433\u0434\u0435!')),
                ('service_comment', models.TextField(default=None, help_text='\u043d\u0435 \u043f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0435\u0442\u0441\u044f \u0432 \u0441\u0435\u0440\u0432\u0438\u0441\u0435', null=True, verbose_name='\u0441\u043b\u0443\u0436\u0435\u0431\u043d\u044b\u0439 \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439', blank=True)),  # noqa
                ('has_tablo', models.BooleanField(default=True, verbose_name='\u0433\u043e\u0440\u043e\u0434 \u0438\u043c\u0435\u0435\u0442 \u0442\u0430\u0431\u043b\u043e')),
                ('agent_geo_id', models.IntegerField(default=None, null=True, verbose_name='agent Geo ID', blank=True)),
                ('has_many_airports', models.BooleanField(default=False, verbose_name='\u043c\u043d\u043e\u0433\u043e \u0430\u044d\u0440\u043e\u043f\u043e\u0440\u0442\u043e\u0432')),
                ('has_urban_transport', models.BooleanField(default=False, verbose_name='\u0435\u0441\u0442\u044c \u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442')),  # noqa
                ('human_url', CodeCharField(null=True, default=None, max_length=50, blank=True, unique=True, verbose_name='\u043a\u043e\u0434 \u0433\u043e\u0440\u043e\u0434\u0430 \u0434\u043b\u044f \u0427\u041f\u0423')),  # noqa
                ('threads_amount', models.PositiveIntegerField(default=0, verbose_name='\u043e\u0431\u0449\u0435\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0440\u0435\u0439\u0441\u043e\u0432 \u0432 \u0442\u0430\u0431\u043b\u043e', editable=False)),  # noqa
                ('type_choices', models.CharField(default=b'', max_length=50, verbose_name='\u0442\u0438\u043f\u044b \u0422\u0421', blank=True)),
                ('longitude', models.FloatField(default=None, null=True, verbose_name='\u0434\u043e\u043b\u0433\u043e\u0442\u0430', db_index=True, blank=True)),
                ('latitude', models.FloatField(default=None, null=True, verbose_name='\u0448\u0438\u0440\u043e\u0442\u0430', db_index=True, blank=True)),
                ('_disputed_territory', models.BooleanField(default=False, verbose_name='\u0441\u043f\u043e\u0440\u043d\u0430\u044f \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u044f', db_column=b'disputed_territory')),  # noqa
                ('modified_at', models.DateTimeField(auto_now=True, verbose_name='\u0414\u0430\u0442\u0430-\u0432\u0440\u0435\u043c\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f')),
                ('title', TrimmedCharField(default=None, max_length=100, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435', db_index=True)),
                ('title_ru', TrimmedCharField(default=None, max_length=100, blank=True, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (ru)', db_index=True)),  # noqa
                ('title_en', TrimmedCharField(default=None, max_length=100, blank=True, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (en)', db_index=True)),  # noqa
                ('title_tr', TrimmedCharField(default=None, max_length=100, blank=True, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (tr)', db_index=True)),  # noqa
                ('title_uk', TrimmedCharField(default=None, max_length=100, blank=True, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (uk)', db_index=True)),  # noqa
                ('abbr_title', TrimmedCharField(default=None, max_length=4, blank=True, help_text='\u043c\u0430\u043a\u0441\u0438\u043c\u0443\u043c 4 \u0441\u0438\u043c\u0432\u043e\u043b\u0430', null=True, verbose_name='\u0441\u043e\u043a\u0440. \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435')),  # noqa
                ('abbr_title_ru', TrimmedCharField(default=None, max_length=4, blank=True, help_text='\u043c\u0430\u043a\u0441\u0438\u043c\u0443\u043c 4 \u0441\u0438\u043c\u0432\u043e\u043b\u0430', null=True, verbose_name='\u0441\u043e\u043a\u0440. \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (ru)')),  # noqa
                ('abbr_title_en', TrimmedCharField(default=None, max_length=4, blank=True, help_text='\u043c\u0430\u043a\u0441\u0438\u043c\u0443\u043c 4 \u0441\u0438\u043c\u0432\u043e\u043b\u0430', null=True, verbose_name='\u0441\u043e\u043a\u0440. \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (en)')),  # noqa
                ('abbr_title_tr', TrimmedCharField(default=None, max_length=4, blank=True, help_text='\u043c\u0430\u043a\u0441\u0438\u043c\u0443\u043c 4 \u0441\u0438\u043c\u0432\u043e\u043b\u0430', null=True, verbose_name='\u0441\u043e\u043a\u0440. \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (tr)')),  # noqa
                ('abbr_title_uk', TrimmedCharField(default=None, max_length=4, blank=True, help_text='\u043c\u0430\u043a\u0441\u0438\u043c\u0443\u043c 4 \u0441\u0438\u043c\u0432\u043e\u043b\u0430', null=True, verbose_name='\u0441\u043e\u043a\u0440. \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (uk)')),  # noqa
                ('country', models.ForeignKey(default=None, blank=True, to='www.Country', null=True, verbose_name='\u0441\u0442\u0440\u0430\u043d\u0430')),
                ('district', models.ForeignKey(related_name='settlements', default=None, blank=True, to='www.District', null=True, verbose_name='\u0440\u0430\u0439\u043e\u043d')),
                ('majority', models.ForeignKey(default=None, blank=True, to='www.CityMajority', null=True, verbose_name='\u0432\u0430\u0436\u043d\u043e\u0441\u0442\u044c \u0433\u043e\u0440\u043e\u0434\u0430')),  # noqa
            ],
            options={
                'db_table': 'www_settlement',
                'verbose_name': '\u0433\u043e\u0440\u043e\u0434',
                'verbose_name_plural': '\u0433\u043e\u0440\u043e\u0434\u0430',
            },
            bases=(models.Model, TimeZoneMixin, TransLocalMixin, Point),
        ),
        migrations.CreateModel(
            name='SettlementCode',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('code', CodeCharField(max_length=50, verbose_name='\u043a\u043e\u0434', db_index=True)),
                ('settlement', models.ForeignKey(related_name='code_set', verbose_name='\u0433\u043e\u0440\u043e\u0434', to='www.Settlement')),
                ('system', models.ForeignKey(verbose_name='\u0441\u0438\u0441\u0442\u0435\u043c\u0430 \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f', to='www.CodeSystem')),
            ],
            options={
                'ordering': ('settlement__id',),
                'db_table': 'www_settlementcode',
                'verbose_name': '\u043a\u043e\u0434 \u0433\u043e\u0440\u043e\u0434\u0430',
                'verbose_name_plural': '\u043a\u043e\u0434\u044b \u0433\u043e\u0440\u043e\u0434\u043e\u0432',
            },
        ),
        migrations.CreateModel(
            name='SettlementNearest',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('description', models.TextField(null=True, verbose_name='\u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043f\u0440\u043e\u0435\u0437\u0434\u0430', blank=True)),
                ('nearest', models.ForeignKey(related_name='related_nearest', verbose_name='\u0431\u043b\u0438\u0436\u0430\u0439\u0448\u0438\u0439', to='www.Settlement')),
                ('settlement', models.ForeignKey(related_name='related_settlement', verbose_name='\u0433\u043e\u0440\u043e\u0434', to='www.Settlement')),
            ],
            options={
                'db_table': 'www_settlementnearest',
                'verbose_name': '\u0431\u043b\u0438\u0436\u0430\u0439\u0448\u0438\u0439 \u0433\u043e\u0440\u043e\u0434',
                'verbose_name_plural': '\u0431\u043b\u0438\u0436\u0430\u0439\u0448\u0438\u0435 \u0433\u043e\u0440\u043e\u0434\u0430',
            },
        ),
        migrations.CreateModel(
            name='SettlementProperty',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=100, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435')),
                ('description', models.TextField(default=None, null=True, verbose_name='\u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435', blank=True)),
            ],
            options={
                'ordering': ('title',),
                'db_table': 'www_settlementproperty',
                'verbose_name': '\u0441\u0432\u043e\u0439\u0441\u0442\u0432\u043e \u0433\u043e\u0440\u043e\u0434\u0430',
                'verbose_name_plural': '\u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430 \u0433\u043e\u0440\u043e\u0434\u043e\u0432',
            },
        ),
        migrations.CreateModel(
            name='SettlementRelatedStations',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('settlement', models.ForeignKey(related_name='related_stations', verbose_name='\u0433\u043e\u0440\u043e\u0434', to='www.Settlement')),
            ],
            options={
                'ordering': ('settlement', 'station'),
                'db_table': 'www_settlement_related_stations',
                'verbose_name': '\u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0435 \u0441\u0442\u0430\u043d\u0446\u0438\u0438 \u0438 \u0433\u043e\u0440\u043e\u0434\u0430 \u0434\u043b\u044f \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f',  # noqa
                'verbose_name_plural': '\u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u044f \u0441\u0442\u0430\u043d\u0446\u0438\u0439 \u0438 \u0433\u043e\u0440\u043e\u0434\u043e\u0432 \u0434\u043b\u044f \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f',  # noqa
            },
        ),
        migrations.CreateModel(
            name='SpecialOffer',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('tariff', models.FloatField(verbose_name='\u0426\u0435\u043d\u0430')),
                ('service_class', models.CharField(default=b'e', max_length=1, verbose_name='\u043a\u043b\u0430\u0441\u0441 \u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u044f', choices=[(b'e', '\u042d\u043a\u043e\u043d\u043e\u043c'), (b'b', '\u0411\u0438\u0437\u043d\u0435\u0441'), (b'f', '\u041f\u0435\u0440\u0432\u044b\u0439')])),  # noqa
                ('date_start', models.DateField(verbose_name='\u0434\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u044f')),
                ('date_end', models.DateField(verbose_name='\u0434\u0430\u0442\u0430 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u044f')),  # noqa
                ('period_start', models.DateField(verbose_name='\u0434\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u043f\u0435\u0440\u0438\u043e\u0434\u0430 \u043f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0438\u044f')),  # noqa
                ('period_end', models.DateField(verbose_name='\u0434\u0430\u0442\u0430 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u043f\u0435\u0440\u0438\u043e\u0434\u0430 \u043f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0438\u044f')),  # noqa
                ('reverse', models.BooleanField(default=False, verbose_name='\u0442\u0443\u0434\u0430-\u043e\u0431\u0440\u0430\u0442\u043d\u043e')),
                ('online_booking', models.BooleanField(default=False, verbose_name='\u043e\u043d\u043b\u0430\u0439\u043d \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435')),
                ('tariff_code', TrimmedCharField(default=b'', max_length=20, verbose_name='\u043a\u043e\u0434 \u0442\u0430\u0440\u0438\u0444\u0430', blank=True)),
                ('text', models.TextField(default=b'', verbose_name='\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435', blank=True)),
            ],
            options={
                'verbose_name': '\u0421\u043f\u0435\u0446\u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u043d\u0430 \u0410\u0432\u0438\u0430\u0431\u0438\u043b\u0435\u0442\u044b',
                'verbose_name_plural': '\u0421\u043f\u0435\u0446\u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u043d\u0430 \u0410\u0432\u0438\u0430\u0431\u0438\u043b\u0435\u0442\u044b',  # noqa
            },
        ),
        migrations.CreateModel(
            name='Station',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title_ru_preposition_v_vo_na', TrimmedCharField(default=None, max_length=2, blank=True, help_text='\u0432, \u0432\u043e, \u043d\u0430 \u2013 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435: \u043a\u0443\u0434\u0430? (\u0432\u043e \u0412\u043b\u0430\u0434\u0438\u043c\u0438\u0440, \u043d\u0430 \u0443\u043b. \u041f\u0443\u0448\u043a\u0438\u043d\u0430)', null=True, verbose_name='\u043f\u0440\u0435\u0434\u043b\u043e\u0433 (\u0432, \u0432\u043e, \u043d\u0430)')),  # noqa
                ('title_ru_genitive', TrimmedCharField(default=None, max_length=100, blank=True, help_text='\u043e\u0442\u043a\u0443\u0434\u0430? - \u043e\u0442 (\u043a\u043e\u0433\u043e? \u0447\u0435\u0433\u043e?) \u041c\u043e\u0441\u043a\u0432\u044b, \u0438\u0437 (\u043a\u043e\u0433\u043e? \u0447\u0435\u0433\u043e?) \u041c\u043e\u0441\u043a\u0432\u044b, \u0442\u0430\u0431\u043b\u043e (\u043a\u043e\u0433\u043e? \u0447\u0435\u0433\u043e?) \u041c\u043e\u0441\u043a\u0432\u044b', null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (\u0440\u043e\u0434. \u043f\u0430\u0434\u0435\u0436)')),  # noqa
                ('title_ru_accusative', TrimmedCharField(default=None, max_length=100, blank=True, help_text='\u043a\u0443\u0434\u0430? - \u0432 (\u043a\u043e\u0433\u043e? \u0447\u0442\u043e?) \u041c\u043e\u0441\u043a\u0432\u0443', null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (\u0432\u0438\u043d. \u043f\u0430\u0434\u0435\u0436)')),  # noqa
                ('title_ru_locative', TrimmedCharField(default=None, max_length=100, blank=True, help_text='\u0433\u0434\u0435? - \u0432 (\u043a\u043e\u043c? \u0447\u0435\u043c?) \u041c\u043e\u0441\u043a\u0432\u0435', null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (\u043f\u0440\u0435\u0434. \u043f\u0430\u0434\u0435\u0436)')),  # noqa
                ('popular_title_ru_genitive', TrimmedCharField(default=None, max_length=100, blank=True, help_text='\u043e\u0442\u043a\u0443\u0434\u0430? - \u043e\u0442 (\u043a\u043e\u0433\u043e? \u0447\u0435\u0433\u043e?) \u041c\u043e\u0441\u043a\u0432\u044b, \u0438\u0437 (\u043a\u043e\u0433\u043e? \u0447\u0435\u0433\u043e?) \u041c\u043e\u0441\u043a\u0432\u044b, \u0442\u0430\u0431\u043b\u043e (\u043a\u043e\u0433\u043e? \u0447\u0435\u0433\u043e?) \u041c\u043e\u0441\u043a\u0432\u044b', null=True, verbose_name='\u043d\u0430\u0440\u043e\u0434\u043d\u043e\u0435 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (\u0440\u043e\u0434. \u043f\u0430\u0434\u0435\u0436)', db_index=True)),  # noqa
                ('type_choices', TrimmedCharField(default='', max_length=100, null=True, verbose_name='\u0442\u0438\u043f\u044b \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f \u0442\u0430\u0431\u043b\u043e/\u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f', blank=True)),  # noqa
                ('hidden', models.BooleanField(default=False, help_text='\u043d\u0435 \u043f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u043d\u0438\u0433\u0434\u0435, \u043a\u0440\u043e\u043c\u0435 \u0440\u0435\u0439\u0441\u043e\u0432 \u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u044f. \u041d\u0435 \u0434\u0430\u0432\u0430\u0442\u044c \u0441\u0441\u044b\u043b\u043a\u0443 \u0432 \u0440\u0435\u0439\u0441\u0435 \u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u044f.', verbose_name='\u0441\u043a\u0440\u044b\u0442\u0430')),  # noqa
                ('express_id', CodeCharField(null=True, default=None, editable=False, max_length=50, blank=True, unique=True)),
                ('sirena_id', CodeCharField(null=True, default=None, editable=False, max_length=10, blank=True, unique=True, verbose_name='\u043a\u043e\u0434 \u0432 "Sirena"')),
                ('time_zone', models.CharField(help_text='\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f \u0437\u043e\u043d\u0430 \u0432 \u043c\u0435\u0436\u0434\u0443\u043d\u0430\u0440\u043e\u0434\u043d\u043e\u043c \u0444\u043e\u0440\u043c\u0430\u0442\u0435', max_length=30, verbose_name='\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f \u0437\u043e\u043d\u0430', blank=True)),  # noqa
                ('time_zone_not_check', models.BooleanField(default=False, verbose_name='\u043d\u0435 \u0441\u0432\u0435\u0440\u044f\u0442\u044c \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u0443\u044e \u0437\u043e\u043d\u0443 \u0441 \u0440\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u043c \u0440\u0435\u0433\u0438\u043e\u043d\u043e\u043c')),  # noqa
                ('site_url', models.URLField(default=None, max_length=100, null=True, verbose_name='\u0443\u0440\u043b \u0441\u0430\u0439\u0442\u0430', blank=True)),
                ('_majority', models.IntegerField(default=None, null=True, verbose_name='\u0432\u0430\u0436\u043d\u043e\u0441\u0442\u044c', blank=True)),
                ('not_generalize', models.BooleanField(default=False, verbose_name='\u043d\u0435 \u043e\u0431\u043e\u0431\u0449\u0430\u0442\u044c \u0434\u043e \u0433\u043e\u0440\u043e\u0434\u0430 \u043f\u0440\u0438 \u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0438 \u0440\u0435\u0439\u0441\u043e\u0432')),  # noqa
                ('longitude', models.FloatField(default=None, null=True, verbose_name='\u0434\u043e\u043b\u0433\u043e\u0442\u0430', db_index=True, blank=True)),
                ('latitude', models.FloatField(default=None, null=True, verbose_name='\u0448\u0438\u0440\u043e\u0442\u0430', db_index=True, blank=True)),
                ('map_zoom', models.IntegerField(default=None, null=True, verbose_name='\u043c\u0430\u0441\u0448\u0442\u0430\u0431 \u043a\u0430\u0440\u0442\u044b', blank=True)),
                ('use_direction', models.CharField(default=b'subdir', max_length=10, verbose_name='\u0441\u0432\u044f\u0437\u044c \u0441 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f\u043c\u0438', blank=True, choices=[(b'', '\u043d\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f'), (b'dir', '\u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f'), (b'subdir', '\u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442 \u043f\u043e\u0434\u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f')])),  # noqa
                ('has_aeroexpress', models.BooleanField(default=False, verbose_name='\u043f\u043e \u0441\u0442\u0430\u043d\u0446\u0438\u0438 \u0445\u043e\u0434\u044f\u0442 \u0430\u044d\u0440\u043e\u044d\u043a\u0441\u043f\u0440\u0435\u0441\u0441\u044b')),  # noqa
                ('near_metro', models.CharField(default=None, max_length=25, null=True, verbose_name='\u0440\u044f\u0434\u043e\u043c \u0441 \u043c\u0435\u0442\u0440\u043e', blank=True)),
                ('last_change', models.DateTimeField(default=None, help_text='\u0432\u044b\u0441\u0442\u0430\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043f\u0440\u0438 \u0440\u0443\u0447\u043d\u043e\u0439 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0435 \u0430\u0434\u0440\u0435\u0441\u0430, \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0439 \u0438 \u0442\u0434.', null=True, verbose_name='\u0434\u0430\u0442\u0430 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0439 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438', blank=True)),  # noqa
                ('photo', models.ImageField(default=None, upload_to=b'data/station/photo', null=True, verbose_name='\u0444\u043e\u0442\u043e \u0441\u0442\u0430\u043d\u0446\u0438\u0438', blank=True)),
                ('schema_image', models.ImageField(default=None, upload_to=b'data/station/schema_image', null=True, verbose_name='\u0421\u0445\u0435\u043c\u0430 \u0441\u0442\u0430\u043d\u0446\u0438\u0438', blank=True)),  # noqa
                ('panorama_url', models.URLField(null=True, verbose_name='\u0441\u0441\u044b\u043b\u043a\u0430 \u043d\u0430 \u043f\u0430\u043d\u043e\u0440\u0430\u043c\u0443', blank=True)),
                ('show_settlement', models.BooleanField(default=True, help_text='\u043f\u0438\u0441\u0430\u0442\u044c \u043b\u0438 \u043f\u0435\u0440\u0435\u0434 \u0430\u0434\u0440\u0435\u0441\u043e\u043c \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0433\u043e\u0440\u043e\u0434\u0430 \u0441\u0442\u0430\u043d\u0446\u0438\u0438', verbose_name='\u043f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u0433\u043e\u0440\u043e\u0434 \u0432 \u0430\u0434\u0440\u0435\u0441\u0435')),  # noqa
                ('tablo_state', models.CharField(default=b'', max_length=10, verbose_name='\u0442\u0430\u0431\u043b\u043e', blank=True, choices=[(b'', '\u043d\u0435\u0442 \u0442\u0430\u0431\u043b\u043e'), (b'statuses', '\u0442\u043e\u043b\u044c\u043a\u043e \u0441\u0442\u0430\u0442\u0443\u0441\u044b'), (b'real', '\u0441\u0442\u0430\u0442\u0443\u0441\u044b \u0438 \u0432\u0440\u0435\u043c\u044f'), (b'nodata', '\u043d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445')])),  # noqa
                ('tablo_state_prev', models.CharField(default=b'', max_length=10, verbose_name='\u0442\u0430\u0431\u043b\u043e (\u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0435\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435)', blank=True, choices=[(b'', '\u043d\u0435\u0442 \u0442\u0430\u0431\u043b\u043e'), (b'statuses', '\u0442\u043e\u043b\u044c\u043a\u043e \u0441\u0442\u0430\u0442\u0443\u0441\u044b'), (b'real', '\u0441\u0442\u0430\u0442\u0443\u0441\u044b \u0438 \u0432\u0440\u0435\u043c\u044f'), (b'nodata', '\u043d\u0435\u0442 \u0434\u0430\u043d\u043d\u044b\u0445')])),  # noqa
                ('fuzzy_only', models.BooleanField(default=False, verbose_name='\u0442\u043e\u043b\u044c\u043a\u043e \u043d\u0435\u0447\u0435\u0442\u043a\u0438\u0435 rtstations')),
                ('virtual_end', models.BooleanField(default=False, verbose_name='\u0432\u0438\u0440\u0442\u0443\u0430\u043b\u044c\u043d\u0430\u044f \u043a\u043e\u043d\u0435\u0447\u043d\u0430\u044f')),
                ('incomplete_bus_schedule', models.BooleanField(default=False, verbose_name='\u043d\u0435\u043f\u043e\u043b\u043d\u043e\u0435 \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0430\u0432\u0442\u043e\u0431\u0443\u0441\u043e\u0432')),  # noqa
                ('show_mode', models.CharField(default=b'block', max_length=5, verbose_name='\u0440\u0435\u0436\u0438\u043c \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f \u0430\u0432\u0442\u043e\u0431\u0443\u0441\u043e\u0432', choices=[(b'block', '\u0431\u043b\u043e\u0447\u043d\u043e\u0435 \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0435'), (b'simpl', '\u043f\u043e\u0441\u0442\u0440\u043e\u0447\u043d\u043e\u0435 \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0435')])),  # noqa
                ('meta_title', models.CharField(max_length=255, null=True, verbose_name='meta title', blank=True)),
                ('meta_description', models.TextField(null=True, verbose_name='meta description', blank=True)),
                ('is_fuzzy', models.BooleanField(default=False, verbose_name='\u043d\u0435\u0447\u0435\u0442\u043a\u043e\u0435 \u0432\u0440\u0435\u043c\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f/\u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f')),  # noqa
                ('is_searchable_to', models.BooleanField(default=True, verbose_name='\u0438\u0441\u043a\u0430\u0442\u044c \u0434\u043e \u0441\u0442\u0430\u043d\u0446\u0438\u0438')),
                ('is_searchable_from', models.BooleanField(default=True, verbose_name='\u0438\u0441\u043a\u0430\u0442\u044c \u043e\u0442 \u0441\u0442\u0430\u043d\u0446\u0438\u0438')),
                ('in_station_schedule', models.BooleanField(default=True, verbose_name='\u0432 \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0438 \u043f\u043e \u0441\u0442\u0430\u043d\u0446\u0438\u0438')),  # noqa
                ('in_thread', models.BooleanField(default=True, verbose_name='\u043f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u043d\u0430 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435 \u043d\u0438\u0442\u043a\u0438')),  # noqa
                ('show_tablo_stat', models.BooleanField(default=True, verbose_name='\u043f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u043e\u0442\u043c\u0435\u043d\u044b \u0438 \u0437\u0430\u0434\u0435\u0440\u0436\u043a\u0438 \u043f\u043e \u0441\u0442\u0430\u043d\u0446\u0438\u0438 \u043d\u0430 \u0433\u043b\u0430\u0432\u043d\u043e\u0439 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435 \u0420\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0439')),  # noqa
                ('modified_at', models.DateTimeField(auto_now=True, verbose_name='\u0414\u0430\u0442\u0430-\u0432\u0440\u0435\u043c\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f')),
                ('short_title', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043a\u043e\u0440\u043e\u0442\u043a\u043e\u0435 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435', blank=True)),  # noqa
                ('short_title_ru', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043a\u043e\u0440\u043e\u0442\u043a\u043e\u0435 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (ru)', blank=True)),  # noqa
                ('short_title_en', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043a\u043e\u0440\u043e\u0442\u043a\u043e\u0435 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (en)', blank=True)),  # noqa
                ('short_title_tr', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043a\u043e\u0440\u043e\u0442\u043a\u043e\u0435 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (tr)', blank=True)),  # noqa
                ('short_title_uk', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043a\u043e\u0440\u043e\u0442\u043a\u043e\u0435 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (uk)', blank=True)),  # noqa
                ('how_to_get_to_city_ru', models.TextField(null=True, verbose_name='\u043a\u0430\u043a \u0434\u043e\u0435\u0445\u0430\u0442\u044c \u0434\u043e \u0433\u043e\u0440\u043e\u0434\u0430 (ru)', blank=True)),  # noqa
                ('how_to_get_to_city_en', models.TextField(null=True, verbose_name='\u043a\u0430\u043a \u0434\u043e\u0435\u0445\u0430\u0442\u044c \u0434\u043e \u0433\u043e\u0440\u043e\u0434\u0430 (en)', blank=True)),  # noqa
                ('how_to_get_to_city_tr', models.TextField(null=True, verbose_name='\u043a\u0430\u043a \u0434\u043e\u0435\u0445\u0430\u0442\u044c \u0434\u043e \u0433\u043e\u0440\u043e\u0434\u0430 (tr)', blank=True)),  # noqa
                ('how_to_get_to_city_uk', models.TextField(null=True, verbose_name='\u043a\u0430\u043a \u0434\u043e\u0435\u0445\u0430\u0442\u044c \u0434\u043e \u0433\u043e\u0440\u043e\u0434\u0430 (uk)', blank=True)),  # noqa
                ('popular_title', TrimmedCharField(default=None, max_length=100, blank=True, help_text='\u043f\u043e\u043f\u0443\u043b\u044f\u0440\u043d\u043e\u0435 \u0432 \u043d\u0430\u0440\u043e\u0434\u043d\u044b\u0445 \u043c\u0430\u0441\u0441\u0430\u0445 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435', null=True, verbose_name='\u043d\u0430\u0440\u043e\u0434\u043d\u043e\u0435 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435', db_index=True)),  # noqa
                ('popular_title_ru', TrimmedCharField(default=None, max_length=100, blank=True, help_text='\u043f\u043e\u043f\u0443\u043b\u044f\u0440\u043d\u043e\u0435 \u0432 \u043d\u0430\u0440\u043e\u0434\u043d\u044b\u0445 \u043c\u0430\u0441\u0441\u0430\u0445 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435', null=True, verbose_name='\u043d\u0430\u0440\u043e\u0434\u043d\u043e\u0435 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (ru)', db_index=True)),  # noqa
                ('popular_title_en', TrimmedCharField(default=None, max_length=100, blank=True, help_text='\u043f\u043e\u043f\u0443\u043b\u044f\u0440\u043d\u043e\u0435 \u0432 \u043d\u0430\u0440\u043e\u0434\u043d\u044b\u0445 \u043c\u0430\u0441\u0441\u0430\u0445 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435', null=True, verbose_name='\u043d\u0430\u0440\u043e\u0434\u043d\u043e\u0435 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (en)', db_index=True)),  # noqa
                ('popular_title_tr', TrimmedCharField(default=None, max_length=100, blank=True, help_text='\u043f\u043e\u043f\u0443\u043b\u044f\u0440\u043d\u043e\u0435 \u0432 \u043d\u0430\u0440\u043e\u0434\u043d\u044b\u0445 \u043c\u0430\u0441\u0441\u0430\u0445 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435', null=True, verbose_name='\u043d\u0430\u0440\u043e\u0434\u043d\u043e\u0435 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (tr)', db_index=True)),  # noqa
                ('popular_title_uk', TrimmedCharField(default=None, max_length=100, blank=True, help_text='\u043f\u043e\u043f\u0443\u043b\u044f\u0440\u043d\u043e\u0435 \u0432 \u043d\u0430\u0440\u043e\u0434\u043d\u044b\u0445 \u043c\u0430\u0441\u0441\u0430\u0445 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435', null=True, verbose_name='\u043d\u0430\u0440\u043e\u0434\u043d\u043e\u0435 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (uk)', db_index=True)),  # noqa
                ('title', TrimmedCharField(default=None, max_length=100, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435', db_index=True)),
                ('title_ru', TrimmedCharField(default=None, max_length=100, blank=True, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (ru)', db_index=True)),  # noqa
                ('title_ru_override', models.BooleanField(default=False, verbose_name='\u043d\u0435 \u043e\u0431\u043d\u043e\u0432\u043b\u044f\u0442\u044c \u0438\u0437 \u0442\u0430\u043d\u043a\u0435\u0440\u0430 (ru)')),  # noqa
                ('title_en', TrimmedCharField(default=None, max_length=100, blank=True, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (en)', db_index=True)),  # noqa
                ('title_en_override', models.BooleanField(default=False, verbose_name='\u043d\u0435 \u043e\u0431\u043d\u043e\u0432\u043b\u044f\u0442\u044c \u0438\u0437 \u0442\u0430\u043d\u043a\u0435\u0440\u0430 (en)')),  # noqa
                ('title_tr', TrimmedCharField(default=None, max_length=100, blank=True, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (tr)', db_index=True)),  # noqa
                ('title_tr_override', models.BooleanField(default=False, verbose_name='\u043d\u0435 \u043e\u0431\u043d\u043e\u0432\u043b\u044f\u0442\u044c \u0438\u0437 \u0442\u0430\u043d\u043a\u0435\u0440\u0430 (tr)')),  # noqa
                ('title_uk', TrimmedCharField(default=None, max_length=100, blank=True, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (uk)', db_index=True)),  # noqa
                ('title_uk_override', models.BooleanField(default=False, verbose_name='\u043d\u0435 \u043e\u0431\u043d\u043e\u0432\u043b\u044f\u0442\u044c \u0438\u0437 \u0442\u0430\u043d\u043a\u0435\u0440\u0430 (uk)')),  # noqa
                ('address', TrimmedCharField(default=None, max_length=200, null=True, verbose_name='\u0430\u0434\u0440\u0435\u0441', blank=True)),
                ('address_ru', TrimmedCharField(default=None, max_length=200, null=True, verbose_name='\u0430\u0434\u0440\u0435\u0441 (ru)', blank=True)),
                ('address_en', TrimmedCharField(default=None, max_length=200, null=True, verbose_name='\u0430\u0434\u0440\u0435\u0441 (en)', blank=True)),
                ('address_tr', TrimmedCharField(default=None, max_length=200, null=True, verbose_name='\u0430\u0434\u0440\u0435\u0441 (tr)', blank=True)),
                ('address_uk', TrimmedCharField(default=None, max_length=200, null=True, verbose_name='\u0430\u0434\u0440\u0435\u0441 (uk)', blank=True)),
                ('is_base', models.BooleanField(default=False, help_text='\u041f\u0440\u0438\u0437\u043d\u0430\u043a \u0431\u0430\u0437\u043e\u0432\u043e\u0433\u043e \u0430\u0432\u0442\u043e\u0432\u043e\u043a\u0437\u0430\u043b\u0430 (\u0442\u0430\u0441\u043a RASPADMIN-183)', verbose_name='\u042f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0431\u0430\u0437\u043e\u0432\u044b\u043c \u0430\u0432\u0442\u043e\u0432\u043e\u043a\u0437\u0430\u043b\u043e\u043c')),  # noqa
                ('country', models.ForeignKey(default=None, blank=True, to='www.Country', null=True, verbose_name='\u0441\u0442\u0440\u0430\u043d\u0430')),
                ('district', models.ForeignKey(default=None, blank=True, to='www.District', null=True, verbose_name='\u0440\u0430\u0439\u043e\u043d')),
            ],
            options={
                'abstract': False,
                'db_table': 'www_station',
                'verbose_name': '\u0441\u0442\u0430\u043d\u0446\u0438\u044f',
                'verbose_name_plural': '\u0441\u0442\u0430\u043d\u0446\u0438\u0438',
            },
            bases=(models.Model, TimeZoneMixin, TransLocalMixin, Point),
        ),
        migrations.CreateModel(
            name='Station2Settlement',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('settlement', models.ForeignKey(verbose_name='\u0433\u043e\u0440\u043e\u0434', to='www.Settlement')),
                ('station', models.ForeignKey(verbose_name='\u0441\u0442\u0430\u043d\u0446\u0438\u044f', to='www.Station')),
            ],
            options={
                'ordering': ('settlement', 'station'),
                'db_table': 'www_station2settlement',
                'verbose_name': '\u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438e \u0441\u0442\u0430\u043d\u0446\u0438\u0438 \u0438 \u0433\u043e\u0440\u043e\u0434\u0430',
                'verbose_name_plural': '\u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u044f \u0441\u0442\u0430\u043d\u0446\u0438\u0439 \u0438 \u0433\u043e\u0440\u043e\u0434\u043e\u0432',  # noqa
            },
        ),
        migrations.CreateModel(
            name='StationCode',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('code', CodeCharField(max_length=50, verbose_name='\u043a\u043e\u0434', db_index=True)),
                ('station', models.ForeignKey(related_name='code_set', verbose_name='\u0441\u0442\u0430\u043d\u0446\u0438\u044f', to='www.Station')),
                ('system', models.ForeignKey(verbose_name='\u0441\u0438\u0441\u0442\u0435\u043c\u0430 \u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f', to='www.CodeSystem')),
            ],
            options={
                'ordering': ('station__id',),
                'db_table': 'www_stationcode',
                'verbose_name': '\u043a\u043e\u0434 \u0441\u0442\u0430\u043d\u0446\u0438\u0438',
                'verbose_name_plural': '\u043a\u043e\u0434\u044b \u0441\u0442\u0430\u043d\u0446\u0438\u0439',
            },
        ),
        migrations.CreateModel(
            name='StationExpressAlias',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('alias', CodeCharField(unique=True, max_length=50, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435', db_index=True)),
                ('station', models.ForeignKey(related_name='expressalias_set', verbose_name='\u0441\u0442\u0430\u043d\u0446\u0438\u044f', to='www.Station')),
            ],
            options={
                'db_table': 'www_stationexpressalias',
                'verbose_name': '\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u042d\u043a\u0441\u043f\u0440\u0435\u0441\u0441',
            },
        ),
        migrations.CreateModel(
            name='StationMajority',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('code', models.CharField(verbose_name='\u043a\u043e\u0434 \u0434\u043b\u044f \u043f\u0438\u0442\u043e\u043d\u0430', max_length=50, editable=False)),
                ('title_ru', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (ru)', blank=True)),  # noqa
                ('title_en', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (en)', blank=True)),  # noqa
                ('title_tr', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (tr)', blank=True)),  # noqa
                ('title_uk', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (uk)', blank=True)),  # noqa
            ],
            options={
                'db_table': 'www_stationmajority',
                'verbose_name': '\u0432\u0430\u0436\u043d\u043e\u0441\u0442\u044c \u0441\u0442\u0430\u043d\u0446\u0438\u0438',
                'verbose_name_plural': '\u0432\u0430\u0436\u043d\u043e\u0441\u0442\u0438 \u0441\u0442\u0430\u043d\u0446\u0438\u0439',
            },
        ),
        migrations.CreateModel(
            name='StationPassage',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('duration', models.IntegerField(default=None, null=True, verbose_name='\u0434\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u043f\u0435\u0440\u0435\u0445\u043e\u0434\u0430', blank=True)),  # noqa
                ('is_dual', models.BooleanField(default=True, verbose_name='\u043f\u0435\u0440\u0435\u0445\u043e\u0434 \u0434\u0432\u0443\u0441\u0442\u043e\u0440\u043e\u043d\u043d\u0438\u0439')),
                ('station_from', models.ForeignKey(related_name='outgoing_passages', verbose_name='\u0441 \u043a\u0430\u043a\u043e\u0439 \u0441\u0442\u0430\u043d\u0446\u0438\u0438', to='www.Station')),  # noqa
                ('station_to', models.ForeignKey(related_name='incoming_passages', verbose_name='\u0434\u043e \u043a\u0430\u043a\u043e\u0439 \u0441\u0442\u0430\u043d\u0446\u0438\u0438', to='www.Station')),  # noqa
            ],
            options={
                'db_table': 'www_stationpassage',
                'verbose_name': '\u043f\u0435\u0440\u0435\u0445\u043e\u0434 \u043c\u0435\u0436\u0434\u0443 \u0441\u0442\u0430\u043d\u0446\u0438\u044f\u043c\u0438',
                'verbose_name_plural': '\u043f\u0435\u0440\u0435\u0445\u043e\u0434\u044b \u043c\u0435\u0436\u0434\u0443 \u0441\u0442\u0430\u043d\u0446\u0438\u044f\u043c\u0438',
            },
        ),
        migrations.CreateModel(
            name='StationPhone',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('phone', models.CharField(max_length=255, verbose_name='\u0442\u0435\u043b\u0435\u0444\u043e\u043d')),
                ('note', models.TextField(default=None, null=True, verbose_name='\u043f\u0440\u0438\u043c\u0435\u0447\u0430\u043d\u0438\u0435', blank=True)),
                ('station', models.ForeignKey(verbose_name='\u0441\u0442\u0430\u043d\u0446\u0438\u044f', to='www.Station')),
            ],
            options={
                'ordering': ('phone',),
                'verbose_name': '\u0442\u0435\u043b\u0435\u0444\u043e\u043d \u0441\u0442\u0430\u043d\u0446\u0438\u0438',
                'verbose_name_plural': '\u0442\u0435\u043b\u0435\u0444\u043e\u043d\u044b \u0441\u0442\u0430\u043d\u0446\u0438\u0439',
            },
        ),
        migrations.CreateModel(
            name='StationProperty',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=100, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435')),
                ('description', models.TextField(default=None, null=True, verbose_name='\u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435', blank=True)),
                ('order', models.IntegerField(default=10, help_text='\u0447\u0435\u043c \u0431\u043e\u043b\u044c\u0448\u0435 \u0446\u0438\u0444\u0440\u0430, \u0442\u0435\u043c \u0445\u0443\u0436\u0435 \u043f\u0440\u0438\u0437\u043d\u0430\u043a')),  # noqa
            ],
            options={
                'ordering': ('title',),
                'db_table': 'www_stationproperty',
                'verbose_name': '\u0441\u0432\u043e\u0439\u0441\u0442\u0432\u043e \u0441\u0442\u0430\u043d\u0446\u0438\u0438',
                'verbose_name_plural': '\u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430 \u0441\u0442\u0430\u043d\u0446\u0438\u0439',
            },
        ),
        migrations.CreateModel(
            name='StationSchedule',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('stops', models.TextField(null=True)),
                ('stops_translations', models.TextField(null=True)),
                ('is_fuzzy', models.BooleanField(default=False)),
                ('route', models.ForeignKey(to='www.Route')),
                ('rtstation', models.OneToOneField(related_name='schedule', to='www.RTStation')),
                ('station', models.ForeignKey(to='www.Station')),
                ('thread', models.ForeignKey(to='www.RThread', null=True)),
            ],
        ),
        migrations.CreateModel(
            name='StationTeleportMap',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('teleport_time', models.IntegerField(help_text='\u0432 \u043c\u0438\u043d\u0443\u0442\u0430\u0445 (\u0446\u0435\u043b\u043e\u0435 \u0447\u0438\u0441\u043b\u043e)', verbose_name='\u0432\u0440\u0435\u043c\u044f \u043d\u0430 \u043f\u0435\u0440\u0435\u0441\u0430\u0434\u043a\u0443')),  # noqa
                ('settlement_from', models.ForeignKey(related_name='station_teleport_map_from', verbose_name='\u0433\u043e\u0440\u043e\u0434 \u043e\u0442', blank=True, to='www.Settlement', null=True)),  # noqa
                ('settlement_to', models.ForeignKey(related_name='station_teleport_map_to', verbose_name='\u0433\u043e\u0440\u043e\u0434 \u0434\u043e', blank=True, to='www.Settlement', null=True)),
                ('station_from', models.ForeignKey(related_name='station_teleport_map_from', verbose_name='\u0441\u0442\u0430\u043d\u0446\u0438\u044f \u043e\u0442', blank=True, to='www.Station', null=True)),  # noqa
                ('station_to', models.ForeignKey(related_name='station_teleport_map_to', verbose_name='\u0441\u0442\u0430\u043d\u0446\u0438\u044f \u0434\u043e', blank=True, to='www.Station', null=True)),  # noqa
            ],
            options={
                'verbose_name': '\u0441\u0432\u044f\u0437\u044c \u043c\u0435\u0436\u0434\u0443 \u0441\u0442\u0430\u043d\u0446\u0438\u044f\u043c\u0438',
                'verbose_name_plural': '\u0441\u0432\u044f\u0437\u0438 \u043c\u0435\u0436\u0434\u0443 \u0441\u0442\u0430\u043d\u0446\u0438\u044f\u043c\u0438',
            },
        ),
        migrations.CreateModel(
            name='StationTerminal',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', TrimmedCharField(max_length=50, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435')),
                ('sirena_id', CodeCharField(max_length=6, null=True, verbose_name='\u0414\u0438\u0430\u043d\u0430 \u043a\u043e\u0434 \u0442\u0435\u0440\u043c\u0438\u043d\u0430\u043b\u0430', blank=True)),  # noqa
                ('sirena_letter', CodeCharField(max_length=6, null=True, verbose_name='\u0421\u0438\u0440\u0435\u043d\u0430 \u0431\u0443\u043a\u0432\u0430 \u0442\u0435\u0440\u043c\u0438\u043d\u0430\u043b\u0430', blank=True)),  # noqa
                ('longitude', models.FloatField(default=None, null=True, verbose_name='\u0434\u043e\u043b\u0433\u043e\u0442\u0430', blank=True)),
                ('latitude', models.FloatField(default=None, null=True, verbose_name='\u0448\u0438\u0440\u043e\u0442\u0430', blank=True)),
                ('station', models.ForeignKey(verbose_name='\u0441\u0442\u0430\u043d\u0446\u0438\u044f', to='www.Station')),
            ],
            options={
                'db_table': 'www_stationterminal',
                'verbose_name': '\u0442\u0435\u0440\u043c\u0438\u043d\u0430\u043b',
                'verbose_name_plural': '\u0442\u0435\u0440\u043c\u0438\u043d\u0430\u043b\u044b',
            },
        ),
        migrations.CreateModel(
            name='StationType',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name_ru_genitive', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0440\u043e\u0434\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u043c \u043f\u0430\u0434\u0435\u0436\u0435', blank=True)),  # noqa
                ('name_ru_accusative', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0432\u0438\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u043c \u043f\u0430\u0434\u0435\u0436\u0435', blank=True)),  # noqa
                ('name_ru_dative', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0432 \u0434\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u043c \u043f\u0430\u0434\u0435\u0436\u0435', blank=True)),  # noqa
                ('title_regex', RegExpField(default=None, max_length=100, null=True, verbose_name='\u0448\u0430\u0431\u043b\u043e\u043d \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u044f \u0441\u0442\u0430\u043d\u0446\u0438\u0438', blank=True)),  # noqa
                ('railway_prefix_ru', TrimmedCharField(default=None, max_length=100, blank=True, help_text='\u0434\u043b\u044f \u0441\u043f\u0438\u0441\u043a\u0430 \u0441\u0442\u0430\u043d\u0446\u0438\u0439 \u043d\u0430 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435 \u0436\u0434 \u0440\u0435\u0439\u0441\u0430', null=True, verbose_name='\u043f\u0440\u0435\u0444\u0438\u043a\u0441 \u0434\u043b\u044f \u0436\u0434 (ru)')),  # noqa
                ('railway_prefix_en', TrimmedCharField(default=None, max_length=100, blank=True, help_text='\u0434\u043b\u044f \u0441\u043f\u0438\u0441\u043a\u0430 \u0441\u0442\u0430\u043d\u0446\u0438\u0439 \u043d\u0430 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435 \u0436\u0434 \u0440\u0435\u0439\u0441\u0430', null=True, verbose_name='\u043f\u0440\u0435\u0444\u0438\u043a\u0441 \u0434\u043b\u044f \u0436\u0434 (en)')),  # noqa
                ('railway_prefix_tr', TrimmedCharField(default=None, max_length=100, blank=True, help_text='\u0434\u043b\u044f \u0441\u043f\u0438\u0441\u043a\u0430 \u0441\u0442\u0430\u043d\u0446\u0438\u0439 \u043d\u0430 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435 \u0436\u0434 \u0440\u0435\u0439\u0441\u0430', null=True, verbose_name='\u043f\u0440\u0435\u0444\u0438\u043a\u0441 \u0434\u043b\u044f \u0436\u0434 (tr)')),  # noqa
                ('railway_prefix_uk', TrimmedCharField(default=None, max_length=100, blank=True, help_text='\u0434\u043b\u044f \u0441\u043f\u0438\u0441\u043a\u0430 \u0441\u0442\u0430\u043d\u0446\u0438\u0439 \u043d\u0430 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435 \u0436\u0434 \u0440\u0435\u0439\u0441\u0430', null=True, verbose_name='\u043f\u0440\u0435\u0444\u0438\u043a\u0441 \u0434\u043b\u044f \u0436\u0434 (uk)')),  # noqa
                ('prefix_ru', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043f\u0440\u0435\u0444\u0438\u043a\u0441 (ru)', blank=True)),
                ('prefix_en', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043f\u0440\u0435\u0444\u0438\u043a\u0441 (en)', blank=True)),
                ('prefix_tr', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043f\u0440\u0435\u0444\u0438\u043a\u0441 (tr)', blank=True)),
                ('prefix_uk', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043f\u0440\u0435\u0444\u0438\u043a\u0441 (uk)', blank=True)),
                ('name_ru', TrimmedCharField(default=None, max_length=255, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (ru)')),
                ('name_en', TrimmedCharField(default=None, max_length=255, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (en)', blank=True)),
                ('name_tr', TrimmedCharField(default=None, max_length=255, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (tr)', blank=True)),
                ('name_uk', TrimmedCharField(default=None, max_length=255, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (uk)', blank=True)),
            ],
            options={
                'db_table': 'www_stationtype',
                'verbose_name': '\u0442\u0438\u043f \u0441\u0442\u0430\u043d\u0446\u0438\u0438',
                'verbose_name_plural': '\u0442\u0438\u043f\u044b \u0441\u0442\u0430\u043d\u0446\u0438\u0439',
            },
        ),
        migrations.CreateModel(
            name='SuburbanTariff',
            fields=[
                ('code', TrimmedCharField(max_length=10, serialize=False, verbose_name='\u043a\u043e\u0434', primary_key=True)),
                ('tariff', models.FloatField(verbose_name='\u0446\u0435\u043d\u0430')),
            ],
            options={
                'verbose_name': '\u0442\u0430\u0440\u0438\u0444 \u043f\u0440\u0438\u0433\u043e\u0440\u043e\u0434\u043d\u043e\u0433\u043e \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430',
                'verbose_name_plural': '\u0442\u0430\u0440\u0438\u0444\u044b \u043f\u0440\u0438\u0433\u043e\u0440\u043e\u0434\u043d\u043e\u0433\u043e \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430',  # noqa
            },
        ),
        migrations.CreateModel(
            name='SuburbanZone',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('code', models.CharField(unique=True, max_length=100, verbose_name='\u043a\u043e\u0434 \u0437\u043e\u043d\u044b')),
                ('title_from', models.CharField(max_length=100, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0442\u0443\u0434\u0430(\u043e\u0442 \u041c\u043e\u0441\u043a\u0432\u044b)')),  # noqa
                ('title_to', models.CharField(max_length=100, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043e\u0431\u0440\u0430\u0442\u043d\u043e(\u043d\u0430 \u041c\u043e\u0441\u043a\u0432\u0443)')),  # noqa
                ('title', TrimmedCharField(default=None, max_length=200, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435')),
                ('title_ru', TrimmedCharField(default=None, max_length=200, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (ru)', blank=True)),
                ('title_en', TrimmedCharField(default=None, max_length=200, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (en)', blank=True)),
                ('title_tr', TrimmedCharField(default=None, max_length=200, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (tr)', blank=True)),
                ('title_uk', TrimmedCharField(default=None, max_length=200, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 (uk)', blank=True)),
                ('settlement', models.ForeignKey(related_name='zone_settlement', verbose_name='\u043e\u0441\u043d\u043e\u0432\u043d\u043e\u0439 \u0433\u043e\u0440\u043e\u0434 \u0437\u043e\u043d\u044b', to='www.Settlement')),  # noqa
            ],
            options={
                'ordering': ('title',),
                'db_table': 'www_suburbanzone',
                'verbose_name': '\u043f\u0440\u0438\u0433\u043e\u0440\u043e\u0434\u043d\u0430\u044f \u0437\u043e\u043d\u0430',
                'verbose_name_plural': '\u043f\u0440\u0438\u0433\u043e\u0440\u043e\u0434\u043d\u044b\u0435 \u0437\u043e\u043d\u044b',
            },
        ),
        migrations.CreateModel(
            name='Suggest',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', TrimmedCharField(max_length=100, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435')),
                ('title_ru', TrimmedCharField(max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (ru)', blank=True)),
                ('title_uk', TrimmedCharField(max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (uk)', blank=True)),
                ('title_tr', TrimmedCharField(max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (tr)', blank=True)),
                ('title_en', TrimmedCharField(max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (en)', blank=True)),
                ('full_title', TrimmedCharField(default=b'', max_length=100, verbose_name='\u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0435\u043c\u043e\u0435 \u0438\u043c\u044f')),  # noqa
                ('full_title_ru', TrimmedCharField(default=b'', max_length=100, verbose_name='\u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0435\u043c\u043e\u0435 \u0438\u043c\u044f (ru)')),  # noqa
                ('full_title_tr', TrimmedCharField(default=b'', max_length=100, verbose_name='\u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0435\u043c\u043e\u0435 \u0438\u043c\u044f (tr)')),  # noqa
                ('full_title_uk', TrimmedCharField(default=b'', max_length=100, verbose_name='\u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0435\u043c\u043e\u0435 \u0438\u043c\u044f (uk)')),  # noqa
                ('full_title_en', TrimmedCharField(default=b'', max_length=100, verbose_name='\u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0435\u043c\u043e\u0435 \u0438\u043c\u044f (en)')),  # noqa
                ('ttype', models.CharField(default=None, max_length=100, null=True, verbose_name='\u0442\u0438\u043f \u0422\u0421', blank=True)),
                ('type', models.CharField(default=None, max_length=100, null=True, verbose_name='\u0442\u0438\u043f \u043e\u0431\u044a\u0435\u043a\u0442\u0430', blank=True)),
                ('object_id', models.IntegerField(default=None, null=True, verbose_name='\u043a\u043e\u0434 \u043e\u0431\u044a\u0435\u043a\u0442\u0430', blank=True)),
                ('majority', models.IntegerField(default=None, null=True, verbose_name='\u0432\u0430\u0436\u043d\u043e\u0441\u0442\u044c \u043e\u0431\u044a\u0435\u043a\u0442\u0430', blank=True)),
                ('order', models.IntegerField(default=100, verbose_name='\u043f\u043e\u0440\u044f\u0434\u043e\u043a')),
                ('country', models.ForeignKey(default=None, blank=True, to='www.Country', null=True, verbose_name='\u0441\u0442\u0440\u0430\u043d\u0430')),
                ('region', models.ForeignKey(default=None, blank=True, to='www.Region', null=True, verbose_name='\u043e\u0431\u043b\u0430\u0441\u0442\u044c')),
                ('zone', models.ForeignKey(default=None, blank=True, to='www.SuburbanZone', null=True, verbose_name='\u043f\u0440\u0438\u0433\u043e\u0440\u043e\u0434\u043d\u0430\u044f \u0437\u043e\u043d\u0430')),  # noqa
            ],
            options={
                'ordering': ('title',),
                'verbose_name': '\u0441\u0430\u0433\u0433\u0435\u0441\u0442',
                'verbose_name_plural': '\u0441\u0430\u0433\u0433\u0435\u0441\u0442\u044b',
            },
        ),
        migrations.CreateModel(
            name='Supplier',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=100, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430')),  # noqa
                ('code', CodeCharField(unique=True, max_length=100, verbose_name='\u043a\u043e\u0434 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430', validators=[django.core.validators.RegexValidator('(?u)^([0-9a-zA-Z-]*|airport\\_donetsk|airport\\_kharkov|airport\\_simferopol|arch\\_av|avto\\_siktivcar|a\\_linii|b2\\_msq|bb\\_travel|BS\\_Tushinskaya|chel\\_gortrans|dyc\\_ast|ekb\\_northav|IP\\_Bezuglov|IP\\_Stachanov|IP\\_Vildanova|Kostroma\\_avia|kvc\\_tula|maykop\\_av|middle\\_station\\_route\\_af|msk\\_subway|next\\_bus\\_tour|Nordexpress\\_Rybinsk|STK\\_Parus|Tarasovskoe\\_ATP|tis\\_from\\_hp|zd\\_syktyvkar)$', '\u0412 \u043a\u043e\u0434\u0435 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430 \u043c\u043e\u0433\u0443\u0442 \u0443\u0447\u0430\u0432\u0441\u0442\u0432\u043e\u0432\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0430\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0435 \u0431\u0443\u043a\u0432\u044b \u0446\u0438\u0444\u0440\u044b \u0438 \u0437\u043d\u0430\u043a \u043c\u0438\u043d\u0443\u0441')])),  # noqa
                ('lmt', models.DateTimeField(help_text='\u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0422\u0418\u0421', verbose_name='\u0434\u0430\u0442\u0430 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0433\u043e \u0438\u043c\u043f\u043e\u0440\u0442\u0430', auto_now_add=True)),  # noqa
                ('filename', models.CharField(max_length=100, null=True, verbose_name='\u0444\u0430\u0439\u043b \u0434\u043b\u044f \u0438\u043c\u043f\u043e\u0440\u0442\u0430', blank=True)),
                ('hide_in_filters', models.BooleanField(default=False, verbose_name='\u041d\u0435 \u043f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u0432 \u0444\u0438\u043b\u044c\u0442\u0440\u0430\u0445')),  # noqa
                ('exclude_from_external_api', models.BooleanField(default=False, verbose_name='\u0418\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0438\u0437 \u0432\u043d\u0435\u0448\u043d\u0435\u0433\u043e API')),  # noqa
                ('can_buy_ru', models.BooleanField(default=False, verbose_name='\u0420\u0430\u0437\u0440\u0435\u0448\u0438\u0442\u044c \u043f\u0440\u043e\u0434\u0430\u0436\u0443 \u0431\u0438\u043b\u0435\u0442\u043e\u0432 (ru)')),  # noqa
                ('can_buy_ua', models.BooleanField(default=False, verbose_name='\u0420\u0430\u0437\u0440\u0435\u0448\u0438\u0442\u044c \u043f\u0440\u043e\u0434\u0430\u0436\u0443 \u0431\u0438\u043b\u0435\u0442\u043e\u0432 (ua)')),  # noqa
                ('can_buy_tr', models.BooleanField(default=False, verbose_name='\u0420\u0430\u0437\u0440\u0435\u0448\u0438\u0442\u044c \u043f\u0440\u043e\u0434\u0430\u0436\u0443 \u0431\u0438\u043b\u0435\u0442\u043e\u0432 (tr)')),  # noqa
                ('logo', models.ImageField(default=None, upload_to=b'data/supplier_logo', null=True, verbose_name='\u041b\u043e\u0433\u043e\u0442\u0438\u043f', blank=True)),
                ('sale_url_template', models.CharField(default='', validators=[StringTemplateValidator(fields=(b'from_code', b'to_code', b'departure'))], max_length=1024, blank=True, help_text='\u041d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, https://example.org/buy/?from={from_code}&to={to_code}&date={departure:%Y-%m-%d}&time={departure:%H:%M}', verbose_name='\u0428\u0430\u0431\u043b\u043e\u043d \u0441\u0441\u044b\u043b\u043a\u0438')),  # noqa
                ('sale_start_days', models.IntegerField(help_text='\u0417\u0430 \u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0441\u0443\u0442\u043e\u043a \u0434\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043d\u0430\u0447\u0438\u043d\u0430\u0435\u0442\u0441\u044f \u043f\u0440\u043e\u0434\u0430\u0436\u0430', null=True, verbose_name='\u0414\u043d\u0438 \u043f\u0440\u043e\u0434\u0430\u0436\u0438', blank=True)),  # noqa
                ('sale_stop_hours', models.IntegerField(help_text='\u0417\u0430 \u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0447\u0430\u0441\u043e\u0432 \u0434\u043e \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0437\u0430\u043a\u0430\u043d\u0447\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u043f\u0440\u043e\u0434\u0430\u0436\u0430', null=True, verbose_name='\u0427\u0430\u0441\u044b \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u043f\u0440\u043e\u0434\u0430\u0436\u0438', blank=True)),  # noqa
                ('add_to_route_changes_report', models.BooleanField(default=True, verbose_name='\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u0442\u044c \u0432 \u0441\u0442\u0430\u0442\u0438\u0441\u0442\u0438\u043a\u0443 \u043f\u043e \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043d\u044b\u043c \u0440\u0435\u0439\u0441\u0430\u043c')),  # noqa
            ],
            options={
                'abstract': False,
                'db_table': 'www_supplier',
                'verbose_name': '\u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a \u0434\u0430\u043d\u043d\u044b\u0445',
                'verbose_name_plural': '\u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0438 \u0434\u0430\u043d\u043d\u044b\u0445',
            },
        ),
        migrations.CreateModel(
            name='TariffGroup',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=100, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0433\u0440\u0443\u043f\u043f\u044b \u0442\u0430\u0440\u0438\u0444\u0430')),
            ],
            options={
                'verbose_name': '\u0413\u0440\u0443\u043f\u043f\u0430 \u0442\u0430\u0440\u0438\u0444\u043e\u0432',
                'verbose_name_plural': '\u0413\u0440\u0443\u043f\u043f\u044b \u0442\u0430\u0440\u0438\u0444\u043e\u0432',
            },
        ),
        migrations.CreateModel(
            name='TariffType',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('link', TrimmedCharField(max_length=255, verbose_name='\u0421\u0441\u044b\u043b\u043a\u0430', blank=True)),
                ('category', models.CharField(default=b'usual', max_length=20, verbose_name='\u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044f', choices=[(b'season_ticket', '\u0410\u0431\u043e\u043d\u0435\u043c\u0435\u043d\u0442'), (b'usual', '\u041e\u0431\u044b\u0447\u043d\u044b\u0439'), (b'special', '\u0421\u043f\u0435\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0439')])),  # noqa
                ('code', CodeCharField(unique=True, max_length=20, verbose_name='\u043a\u043e\u0434')),
                ('order', models.IntegerField(default=0, verbose_name='\u043f\u043e\u0440\u044f\u0434\u043e\u043a \u043f\u043e\u043a\u0430\u0437\u0430')),
                ('title', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0442\u0438\u043f\u0430', blank=True)),  # noqa
                ('title_ru', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0442\u0438\u043f\u0430 (ru)', blank=True)),  # noqa
                ('title_en', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0442\u0438\u043f\u0430 (en)', blank=True)),  # noqa
                ('title_tr', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0442\u0438\u043f\u0430 (tr)', blank=True)),  # noqa
                ('title_uk', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0442\u0438\u043f\u0430 (uk)', blank=True)),  # noqa
                ('tariff_groups', models.ManyToManyField(to='www.TariffGroup', verbose_name='\u0413\u0440\u0443\u043f\u043f\u044b \u0442\u0430\u0440\u0438\u0444\u043e\u0432')),
            ],
            options={
                'ordering': ('order',),
                'verbose_name': '\u0422\u0438\u043f \u0442\u0430\u0440\u0438\u0444\u0430',
                'verbose_name_plural': '\u0422\u0438\u043f\u044b \u0442\u0430\u0440\u0438\u0444\u043e\u0432',
            },
        ),
        migrations.CreateModel(
            name='Teaser',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=255, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435')),
                ('content', models.TextField(verbose_name='\u0442\u0435\u043a\u0441\u0442')),
                ('mobile_content', models.TextField(default=b'', verbose_name='\u043c\u043e\u0431\u0438\u043b\u044c\u043d\u044b\u0439', blank=True)),
                ('url', models.URLField(null=True, verbose_name='url', blank=True)),
                ('image', models.ImageField(upload_to=b'data/teasers', null=True, verbose_name='\u043a\u0430\u0440\u0442\u0438\u043d\u043a\u0430', blank=True)),
                ('template', models.CharField(max_length=20, null=True, verbose_name='\u0448\u0430\u0431\u043b\u043e\u043d', blank=True)),
                ('is_active_rasp', models.BooleanField(default=False, verbose_name='\u0430\u043a\u0442\u0438\u0432\u0435\u043d \u0432 \u041f\u041c')),
                ('is_active_ticket', models.BooleanField(default=False, verbose_name='\u0430\u043a\u0442\u0438\u0432\u0435\u043d \u0432 \u041a\u0411')),
                ('is_active_export', models.BooleanField(default=False, verbose_name='\u0410\u043a\u0442\u0438\u0432\u0435\u043d \u0432 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f\u0445 (export)')),  # noqa
                ('mode', models.CharField(default=b'normal', max_length=20, verbose_name='\u0442\u0438\u043f', choices=[(b'normal', '\u041e\u0431\u044b\u0447\u043d\u044b\u0439'), (b'ahtung', '\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435'), (b'special', '\u0421\u043f\u0435\u0446\u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u0435'), (b'banner', '\u0411\u0430\u043d\u043d\u0435\u0440')])),  # noqa
                ('importance', models.PositiveIntegerField(default=0, help_text='\u0447\u0435\u043c \u0431\u043e\u043b\u044c\u0448\u0435 \u0446\u0438\u0444\u0440\u0430, \u0442\u0435\u043c \u0432\u0430\u0436\u043d\u0435\u0435', verbose_name='\u0432\u0430\u0436\u043d\u043e\u0441\u0442\u044c')),  # noqa
                ('date_start', models.DateField(verbose_name='\u0434\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u043a\u0430\u043c\u043f\u0430\u043d\u0438\u0438')),
                ('date_finish', models.DateField(verbose_name='\u0434\u0430\u0442\u0430 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u043a\u0430\u043c\u043f\u0430\u043d\u0438\u0438')),
                ('lang', models.CharField(default=b'ru', max_length=25, verbose_name='\u042f\u0437\u044b\u043a', choices=[(b'ru', '\u0420\u0443\u0441\u0441\u043a\u0438\u0439'), (b'be', '\u0411\u0435\u043b\u043e\u0440\u0443\u0441\u0441\u043a\u0438\u0439'), (b'kk', '\u041a\u0430\u0437\u0430\u0445\u0441\u043a\u0438\u0439'), (b'tt', '\u0422\u0430\u0442\u0430\u0440\u0441\u043a\u0438\u0439'), (b'uk', '\u0423\u043a\u0440\u0430\u0438\u043d\u0441\u043a\u0438\u0439'), (b'en', '\u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439'), (b'tr', '\u0422\u0443\u0440\u0435\u0446\u043a\u0438\u0439')])),  # noqa
                ('national_version', models.CharField(default=b'ru', max_length=25, null=True, verbose_name='\u041d\u0430\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u0430\u044f \u0432\u0435\u0440\u0441\u0438\u044f', choices=[(b'ru', b'ru'), (b'ua', b'ua'), (b'tr', b'tr')])),  # noqa
                ('companies', models.ManyToManyField(default=None, to='www.Company', verbose_name='\u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a\u0438', blank=True)),
                ('countries', models.ManyToManyField(default=None, to='www.Country', verbose_name='\u0441\u0442\u0440\u0430\u043d\u044b', blank=True)),
                ('directions', models.ManyToManyField(default=None, related_name='directions', verbose_name='\u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f', to='www.ExternalDirection', blank=True)),  # noqa
                ('pages', models.ManyToManyField(default=None, to='www.Page', verbose_name='\u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b', blank=True)),
                ('settlements', models.ManyToManyField(default=None, related_name='settlements', verbose_name='\u0433\u043e\u0440\u043e\u0434\u0430', to='www.Settlement', blank=True)),
                ('stations', models.ManyToManyField(default=None, related_name='stations', verbose_name='\u0441\u0442\u0430\u043d\u0446\u0438\u0438', to='www.Station', blank=True)),
                ('threads', models.ManyToManyField(default=None, related_name='threads', verbose_name='\u043d\u0438\u0442\u043a\u0438', to='www.RThread', blank=True)),
            ],
            options={
                'verbose_name': '\u0442\u0438\u0437\u0435\u0440',
                'verbose_name_plural': '\u0442\u0438\u0437\u0435\u0440\u044b',
            },
        ),
        migrations.CreateModel(
            name='ThreadSchedule',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('schedule_oid', models.IntegerField(verbose_name='\u043d\u043e\u043c\u0435\u0440 \u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u0432\u043d\u0443\u0442\u0440\u0438 \u043d\u0438\u0442\u043a\u0438')),  # noqa
                ('start_date', models.DateField(verbose_name='\u043d\u0430\u0447\u0430\u043b\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430')),
                ('end_date', models.DateField(verbose_name='\u043a\u043e\u043d\u0435\u0446 \u043f\u0435\u0440\u0438\u043e\u0434\u0430')),
                ('start_time', models.TimeField(verbose_name='\u0432\u0440\u0435\u043c\u044f \u043d\u0430\u0447\u0430\u043b\u0430 \u043f\u0440\u043e\u043c\u0435\u0436\u0443\u0442\u043a\u0430')),
                ('end_time', models.TimeField(verbose_name='\u0432\u0440\u0435\u043c\u044f \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u043f\u0440\u043e\u043c\u0435\u0436\u0443\u0442\u043a\u0430')),  # noqa
                ('frequency', models.IntegerField(default=None, null=True, verbose_name='\u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b \u0445\u043e\u0436\u0434\u0435\u043d\u0438\u044f', blank=True)),  # noqa
                ('times', models.CharField(default=None, max_length=255, null=True, verbose_name='\u0432\u0440\u0435\u043c\u044f \u0445\u043e\u0436\u0434\u0435\u043d\u0438\u044f \u0432\u043d\u0435 \u0438\u043d\u0442\u0435\u0440\u0432\u0430\u043b\u043e\u0432', blank=True)),  # noqa
                ('week_days', models.CharField(default=b'1234567', max_length=20, null=True, verbose_name='\u0434\u043d\u0438 \u043d\u0435\u0434\u0435\u043b\u0438', blank=True)),
                ('is_cancel', models.BooleanField(default=False, verbose_name='\u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043b\u0438 \u043e\u0442\u043c\u0435\u043d\u043e\u0439')),
                ('time_zone', models.CharField(max_length=30, verbose_name='\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f \u0437\u043e\u043d\u0430')),
                ('thread', models.ForeignKey(verbose_name='\u043d\u0438\u0442\u043a\u0430', to='www.RThread')),
            ],
            options={
                'verbose_name': '\u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0434\u0432\u0438\u0436\u0435\u043d\u0438\u044f \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430',  # noqa
                'verbose_name_plural': '\u0440\u0430\u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u0434\u0432\u0438\u0436\u0435\u043d\u0438\u044f \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430',  # noqa
            },
        ),
        migrations.CreateModel(
            name='ThreadTariff',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('thread_uid', models.CharField(help_text='\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0434\u043b\u044f \u043e\u0434\u043d\u043e\u0437\u043d\u0430\u0447\u043d\u043e\u0433\u043e \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u044f \u043d\u0438\u0442\u043a\u0438', max_length=100, verbose_name='\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440', db_index=True)),  # noqa
                ('year_days', ThreadCalendarField(default='', verbose_name='\u0428\u0430\u0431\u043b\u043e\u043d \u0434\u043d\u0435\u0439 \u0445\u043e\u0436\u0434\u0435\u043d\u0438\u044f \u0434\u043b\u044f \u0434\u043d\u0435\u0439 \u043a\u043e\u0433\u0434\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0443\u0435\u0442 \u044d\u0442\u0430 \u0446\u0435\u043d\u0430')),  # noqa
                ('tariff', models.FloatField(verbose_name='\u0426\u0435\u043d\u0430')),
                ('currency', models.CharField(default=None, max_length=10, null=True, verbose_name='\u0412\u0430\u043b\u044e\u0442\u0430', blank=True)),
                ('is_min_tariff', models.BooleanField(default=False, verbose_name='\u042d\u0442\u043e \u043c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u0430\u044f \u0446\u0435\u043d\u0430 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430, \u043c\u043e\u0433\u0443\u0442 \u0431\u044b\u0442\u044c \u0438 \u0432\u044b\u0448\u0435')),  # noqa
                ('url', TrimmedCharField(default=b'', max_length=255, verbose_name='order Url', blank=True)),
                ('data', models.TextField(default=b'', verbose_name='\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435')),
                ('year_days_from', ThreadCalendarField(default=b'000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000', verbose_name='\u041a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044c \u0432\u043e \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439 \u0437\u043e\u043d\u0435 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f')),  # noqa
                ('time_zone_from', models.CharField(max_length=30, verbose_name='\u0412\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f \u0437\u043e\u043d\u0430 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f')),  # noqa
                ('time_from', models.TimeField(verbose_name='\u0412\u0440\u0435\u043c\u044f \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0441 \u0443\u0447\u0435\u0442\u043e\u043c \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439 \u0437\u043e\u043d\u044b')),  # noqa
                ('duration', models.IntegerField(verbose_name='\u0412\u0440\u0435\u043c\u044f \u0432 \u043f\u0443\u0442\u0438 (\u0432 \u043c\u0438\u043d\u0443\u0442\u0430\u0445).')),
                ('time_zone_to', models.CharField(max_length=30, verbose_name='\u0412\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f \u0437\u043e\u043d\u0430 \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f')),  # noqa
                ('time_to', models.TimeField(verbose_name='\u0412\u0440\u0435\u043c\u044f \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f \u0441 \u0443\u0447\u0435\u0442\u043e\u043c \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439 \u0437\u043e\u043d\u044b')),  # noqa
                ('number', models.CharField(default='', max_length=100, verbose_name='\u041d\u043e\u043c\u0435\u0440 \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430', blank=True)),
                ('settlement_from', models.ForeignKey(related_name='tariffs_from', verbose_name='\u0413\u043e\u0440\u043e\u0434 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438', to='www.Settlement', null=True)),  # noqa
                ('settlement_to', models.ForeignKey(related_name='tariffs_to', verbose_name='\u0413\u043e\u0440\u043e\u0434 \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f', to='www.Settlement', null=True)),  # noqa
                ('station_from', models.ForeignKey(related_name='route_tariffs_from', verbose_name='\u041f\u0435\u0440\u0432\u0430\u044f \u0441\u0442\u0430\u043d\u0446\u0438\u044f', to='www.Station')),  # noqa
                ('station_to', models.ForeignKey(related_name='route_tariffs_to', verbose_name='\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u044f\u044f \u0441\u0442\u0430\u043d\u0446\u0438\u044f', to='www.Station')),  # noqa
                ('supplier', models.ForeignKey(verbose_name='\u041f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a \u0442\u0430\u0440\u0438\u0444\u0430', to='www.Supplier')),
            ],
            options={
                'abstract': False,
                'verbose_name': '\u0442\u0430\u0440\u0438\u0444 \u043d\u0438\u0442\u043a\u0430-\u0442\u043e\u0447\u043a\u0430-\u0442\u043e\u0447\u043a\u0430',
                'verbose_name_plural': '\u0442\u0430\u0440\u0438\u0444\u044b \u043d\u0438\u0442\u043a\u0430-\u0442\u043e\u0447\u043a\u0430-\u0442\u043e\u0447\u043a\u0430',
            },
        ),
        migrations.CreateModel(
            name='TicketOffice',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=200, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435')),
                ('postal_code', models.CharField(default=None, max_length=200, null=True, verbose_name='\u043f\u043e\u0447\u0442\u043e\u0432\u044b\u0439 \u0438\u043d\u0434\u0435\u043a\u0441', blank=True)),  # noqa
                ('address', models.CharField(default=None, max_length=200, null=True, verbose_name='\u0430\u0434\u0440\u0435\u0441', blank=True)),
                ('home_number', models.CharField(default=None, max_length=100, null=True, verbose_name='\u0434\u043e\u043c', blank=True)),
                ('address2', models.CharField(default=None, max_length=200, null=True, verbose_name='\u0434\u043e\u043f. \u0410\u0434\u0440\u0435\u0441', blank=True)),
                ('phone', models.CharField(default=None, max_length=100, null=True, verbose_name='\u0442\u0435\u043b\u0435\u0444\u043e\u043d', blank=True)),
                ('fax', models.CharField(default=None, max_length=100, null=True, verbose_name='\u0444\u0430\u043a\u0441', blank=True)),
                ('home_site', models.CharField(default=None, max_length=100, null=True, verbose_name='\u0441\u0430\u0439\u0442', blank=True)),
                ('email', models.EmailField(default=None, max_length=100, null=True, verbose_name='\u044d\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u0430\u044f \u043f\u043e\u0447\u0442\u0430', blank=True)),  # noqa
                ('plane', models.BooleanField(default=False, verbose_name='\u043d\u0430 \u0441\u0430\u043c\u043e\u043b\u0435\u0442')),
                ('train', models.BooleanField(default=False, verbose_name='\u043d\u0430 \u043f\u043e\u0435\u0437\u0434')),
                ('companies', models.TextField(default=None, null=True, verbose_name='\u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u043d\u044b\u0435 \u043a\u043e\u043c\u043f\u0430\u043d\u0438\u0438', blank=True)),  # noqa
                ('longitude', models.FloatField(default=None, null=True, verbose_name='\u0434\u043e\u043b\u0433\u043e\u0442\u0430', blank=True)),
                ('latitude', models.FloatField(default=None, null=True, verbose_name='\u0448\u0438\u0440\u043e\u0442\u0430', blank=True)),
                ('settlement', models.ForeignKey(verbose_name='\u0433\u043e\u0440\u043e\u0434', to='www.Settlement')),
            ],
            options={
                'ordering': ('title',),
                'verbose_name': '\u0431\u0438\u043b\u0435\u0442\u043d\u0430\u044f \u043a\u0430\u0441\u0441\u0430',
                'verbose_name_plural': '\u0431\u0438\u043b\u0435\u0442\u043d\u044b\u0435 \u043a\u0430\u0441\u0441\u044b',
            },
        ),
        migrations.CreateModel(
            name='Timestamp',
            fields=[
                ('code', models.CharField(max_length=16, serialize=False, primary_key=True)),
                ('value', models.DateTimeField(null=True)),
            ],
        ),
        migrations.CreateModel(
            name='TrainPseudoStationMap',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('number', TrimmedCharField(max_length=50, verbose_name='\u043d\u043e\u043c\u0435\u0440')),
                ('pseudo_station', models.ForeignKey(related_name='pseudo_pseudo_station_set', verbose_name='\u043f\u0441\u0435\u0432\u0434\u043e\u0441\u0442\u0430\u043d\u0446\u0438\u044f', to='www.Station')),  # noqa
                ('station', models.ForeignKey(related_name='pseudo_station_set', verbose_name='\u0441\u0442\u0430\u043d\u0446\u0438\u044f', to='www.Station')),
            ],
            options={
                'verbose_name': '\u0437\u0430\u043c\u0435\u043d\u0430 \u043f\u0441\u0435\u0432\u0434\u043e\u0441\u0442\u0430\u043d\u0446\u0438\u0438',
                'verbose_name_plural': '\u0437\u0430\u043c\u0435\u043d\u044b \u043f\u0441\u0435\u0432\u0434\u043e\u0441\u0442\u0430\u043d\u0446\u0438\u0439',
            },
        ),
        migrations.CreateModel(
            name='TrainSchedulePlan',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', TrimmedCharField(default=None, max_length=255, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0433\u0440\u0430\u0444\u0444\u0438\u043a\u0430', blank=True)),  # noqa
                ('start_date', models.DateField(verbose_name='\u0434\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430(\u0432\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u043e)')),  # noqa
                ('end_date', models.DateField(verbose_name='\u0434\u0430\u0442\u0430 \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f(\u0432\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u043e)')),  # noqa
                ('code', CodeCharField(unique=True, max_length=50, verbose_name='\u043a\u043e\u0434')),
                ('appendix_type', models.CharField(default=b'from', max_length=4, verbose_name='\u0441\u0435\u043b\u0435\u043a\u0442\u043e\u0440 \u0441/\u043f\u043e', choices=[(b'from', '\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c "c"'), (b'to', '\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c "\u043f\u043e"')])),  # noqa
            ],
            options={
                'db_table': 'www_trainscheduleplan',
                'verbose_name': '\u0433\u0440\u0430\u0444\u0438\u043a \u043f\u043e\u0435\u0437\u0434\u043e\u0432 \u0438 \u044d\u043b\u0435\u043a\u0442\u0440\u0438\u0447\u0435\u043a',
                'verbose_name_plural': '\u0433\u0440\u0430\u0444\u0438\u043a\u0438 \u043f\u043e\u0435\u0437\u0434\u043e\u0432 \u0438 \u044d\u043b\u0435\u043a\u0442\u0440\u0438\u0447\u0435\u043a',
            },
        ),
        migrations.CreateModel(
            name='TransportModel',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=100, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435')),
                ('title_en', models.CharField(default='', max_length=100, verbose_name='\u0430\u043d\u0433\u043b. \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435', blank=True)),  # noqa
                ('template_page', models.CharField(max_length=100, null=True, verbose_name='\u0438\u043c\u044f \u0448\u0430\u0431\u043b\u043e\u043d\u0430', blank=True)),
                ('code', CodeCharField(null=True, default=None, max_length=10, blank=True, unique=True, verbose_name='\u043a\u043e\u0434')),
                ('code_en', CodeCharField(null=True, default=None, max_length=10, blank=True, unique=True, verbose_name='\u043a\u043e\u0434 \u0410\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0439')),  # noqa
                ('img', models.ImageField(default=None, upload_to=b'data/transportmodel/img', null=True, verbose_name='\u0444\u043e\u0442\u043e \u0422\u0421', blank=True)),
                ('background', models.ImageField(default=None, upload_to=b'data/transportmodel/background', null=True, verbose_name='\u043a\u0430\u0440\u0442\u0438\u043d\u043a\u0430 \u0434\u043b\u044f \u0444\u043e\u043d\u0430', blank=True)),  # noqa
                ('ttx', models.TextField(default=None, null=True, verbose_name='\u0442\u0422\u0425', blank=True)),
                ('descr', models.TextField(default=None, null=True, verbose_name='\u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435', blank=True)),
                ('is_cargo', models.BooleanField(default=False, verbose_name='\u0433\u0440\u0443\u0437\u043e\u0432\u043e\u0439')),
            ],
            options={
                'db_table': 'www_transportmodel',
                'verbose_name': '\u043c\u043e\u0434\u0435\u043b\u044c \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430',
                'verbose_name_plural': '\u043c\u043e\u0434\u0435\u043b\u0438 \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430',
            },
        ),
        migrations.CreateModel(
            name='TransportScheme',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435', blank=True)),
                ('img', models.ImageField(upload_to=b'data/transportscheme/img', verbose_name='\u0441\u0445\u0435\u043c\u0430')),
                ('transport_img', models.ImageField(default=None, upload_to=b'data/transportscheme/transport_img', null=True, verbose_name='\u0444\u043e\u0442\u043e \u0422\u0421', blank=True)),
                ('company', models.ForeignKey(default=None, blank=True, to='www.Company', null=True, verbose_name='\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u044f-\u043f\u0435\u0440\u0435\u0432\u043e\u0437\u0447\u0438\u043a')),  # noqa
                ('transport', models.ForeignKey(default=None, blank=True, to='www.TransportModel', null=True, verbose_name='\u043c\u043e\u0434\u0435\u043b\u044c \u0422\u0421')),
            ],
            options={
                'ordering': ('title',),
                'verbose_name': '\u0441\u0445\u0435\u043c\u0430 \u0441\u0430\u043b\u043e\u043d\u0430 \u0422\u0421',
                'verbose_name_plural': '\u0441\u0445\u0435\u043c\u044b \u0441\u0430\u043b\u043e\u043d\u043e\u0432 \u0422\u0421',
            },
        ),
        migrations.CreateModel(
            name='TransportSubtype',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('code', models.CharField(unique=True, max_length=50, verbose_name='\u043a\u043e\u0434', validators=[django.core.validators.RegexValidator('^[0-9a-zA-Z-]+$', '\u0412 \u043a\u043e\u0434\u0435 \u043f\u043e\u0434\u0442\u0438\u043f\u0430 \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430 \u043c\u043e\u0433\u0443\u0442 \u0443\u0447\u0430\u0432\u0441\u0442\u0432\u043e\u0432\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0430\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0435 \u0431\u0443\u043a\u0432\u044b \u0446\u0438\u0444\u0440\u044b \u0438 \u0437\u043d\u0430\u043a \u043c\u0438\u043d\u0443\u0441')])),  # noqa
                ('icon', TransportSubtypeIconField(default=None, validators=[FileSizeValidator(size_limit_in_bytes=1048576), SvgValidator()], upload_to=transportsubtypeiconfield_generate_filename, blank=True, null=True, verbose_name='\u0418\u043a\u043e\u043d\u043a\u0430 (svg)')),  # noqa
                ('comment', TrimmedTextField(default=b'', verbose_name='\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439', blank=True)),
                ('title_ru', TrimmedCharField(default=None, max_length=100, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (ru)')),
                ('title_en', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (en)', blank=True)),  # noqa
                ('title_tr', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (tr)', blank=True)),  # noqa
                ('title_uk', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (uk)', blank=True)),  # noqa
                ('station_name_plural_ru', TrimmedCharField(default=None, max_length=100, blank=True, help_text="\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, \u0434\u043b\u044f \u043f\u043e\u0435\u0437\u0434\u043e\u0432 - '\u0432\u043e\u043a\u0437\u0430\u043b\u044b'.", null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u0442\u0430\u043d\u0446\u0438\u0439 (ru)')),  # noqa
                ('station_name_plural_en', TrimmedCharField(default=None, max_length=100, blank=True, help_text="\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, \u0434\u043b\u044f \u043f\u043e\u0435\u0437\u0434\u043e\u0432 - '\u0432\u043e\u043a\u0437\u0430\u043b\u044b'.", null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u0442\u0430\u043d\u0446\u0438\u0439 (en)')),  # noqa
                ('station_name_plural_tr', TrimmedCharField(default=None, max_length=100, blank=True, help_text="\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, \u0434\u043b\u044f \u043f\u043e\u0435\u0437\u0434\u043e\u0432 - '\u0432\u043e\u043a\u0437\u0430\u043b\u044b'.", null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u0442\u0430\u043d\u0446\u0438\u0439 (tr)')),  # noqa
                ('station_name_plural_uk', TrimmedCharField(default=None, max_length=100, blank=True, help_text="\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, \u0434\u043b\u044f \u043f\u043e\u0435\u0437\u0434\u043e\u0432 - '\u0432\u043e\u043a\u0437\u0430\u043b\u044b'.", null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u0442\u0430\u043d\u0446\u0438\u0439 (uk)')),  # noqa
                ('title_plural_ru', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043c\u043d\u043e\u0436\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0435 (ru)', blank=True)),  # noqa
                ('title_plural_en', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043c\u043d\u043e\u0436\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0435 (en)', blank=True)),  # noqa
                ('title_plural_tr', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043c\u043d\u043e\u0436\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0435 (tr)', blank=True)),  # noqa
                ('title_plural_uk', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043c\u043d\u043e\u0436\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0435 (uk)', blank=True)),  # noqa
                ('title_partner_page_ru', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0434\u043b\u044f \u0441\u0442\u0430\u043d\u0438\u0446\u044b \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u043e\u0432 (ru)', blank=True)),  # noqa
                ('title_partner_page_en', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0434\u043b\u044f \u0441\u0442\u0430\u043d\u0438\u0446\u044b \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u043e\u0432 (en)', blank=True)),  # noqa
                ('title_partner_page_tr', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0434\u043b\u044f \u0441\u0442\u0430\u043d\u0438\u0446\u044b \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u043e\u0432 (tr)', blank=True)),  # noqa
                ('title_partner_page_uk', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0434\u043b\u044f \u0441\u0442\u0430\u043d\u0438\u0446\u044b \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u043e\u0432 (uk)', blank=True)),  # noqa
                ('station_name_ru', TrimmedCharField(default=None, max_length=100, blank=True, help_text="\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, \u0434\u043b\u044f \u043f\u043e\u0435\u0437\u0434\u043e\u0432 - '\u0432\u043e\u043a\u0437\u0430\u043b'.", null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u0442\u0430\u043d\u0446\u0438\u0438 (ru)')),  # noqa
                ('station_name_en', TrimmedCharField(default=None, max_length=100, blank=True, help_text="\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, \u0434\u043b\u044f \u043f\u043e\u0435\u0437\u0434\u043e\u0432 - '\u0432\u043e\u043a\u0437\u0430\u043b'.", null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u0442\u0430\u043d\u0446\u0438\u0438 (en)')),  # noqa
                ('station_name_tr', TrimmedCharField(default=None, max_length=100, blank=True, help_text="\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, \u0434\u043b\u044f \u043f\u043e\u0435\u0437\u0434\u043e\u0432 - '\u0432\u043e\u043a\u0437\u0430\u043b'.", null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u0442\u0430\u043d\u0446\u0438\u0438 (tr)')),  # noqa
                ('station_name_uk', TrimmedCharField(default=None, max_length=100, blank=True, help_text="\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, \u0434\u043b\u044f \u043f\u043e\u0435\u0437\u0434\u043e\u0432 - '\u0432\u043e\u043a\u0437\u0430\u043b'.", null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u0442\u0430\u043d\u0446\u0438\u0438 (uk)')),  # noqa
            ],
            options={
                'db_table': 'www_transportsubtype',
                'verbose_name': '\u043f\u043e\u0434\u0442\u0438\u043f \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430',
                'verbose_name_plural': '\u043f\u043e\u0434\u0442\u0438\u043f\u044b \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430',
            },
        ),
        migrations.CreateModel(
            name='TransportSubtypeColor',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('code', models.CharField(unique=True, max_length=50, verbose_name='\u041a\u043e\u0434', validators=[django.core.validators.RegexValidator('^[0-9a-zA-Z-]+$', '\u0412 \u043a\u043e\u0434\u0435 \u0446\u0432\u0435\u0442\u0430 \u043c\u043e\u0433\u0443\u0442 \u0443\u0447\u0430\u0432\u0441\u0442\u0432\u043e\u0432\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0430\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0435 \u0431\u0443\u043a\u0432\u044b \u0446\u0438\u0444\u0440\u044b \u0438 \u0437\u043d\u0430\u043a \u043c\u0438\u043d\u0443\u0441')])),  # noqa
                ('color', TrimmedCharField(max_length=10, verbose_name='\u0426\u0432\u0435\u0442', validators=[django.core.validators.RegexValidator('^#[0-9a-fA-F]{6}$', '\u0426\u0432\u0435\u0442 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0437\u0430\u0434\u0430\u043d \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 #123456')])),  # noqa
            ],
            options={
                'verbose_name': '\u0426\u0432\u0435\u0442 \u043f\u043e\u0434\u0442\u0438\u043f\u0430 \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430',
                'verbose_name_plural': '\u0426\u0432\u0435\u0442\u0430 \u043f\u043e\u0434\u0442\u0438\u043f\u043e\u0432 \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430',
            },
        ),
        migrations.CreateModel(
            name='TransportType',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('code', models.CharField(unique=True, max_length=50, verbose_name='\u043a\u043e\u0434', validators=[django.core.validators.RegexValidator('^[0-9a-zA-Z-]+$', '\u0412 \u043a\u043e\u0434\u0435 \u0442\u0438\u043f\u0430 \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430 \u043c\u043e\u0433\u0443\u0442 \u0443\u0447\u0430\u0432\u0441\u0442\u0432\u043e\u0432\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0430\u043d\u0433\u043b\u0438\u0439\u0441\u043a\u0438\u0435 \u0431\u0443\u043a\u0432\u044b \u0446\u0438\u0444\u0440\u044b \u0438 \u0437\u043d\u0430\u043a \u043c\u0438\u043d\u0443\u0441')])),  # noqa
                ('title_ru', TrimmedCharField(default=None, max_length=100, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (ru)')),
                ('title_en', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (en)', blank=True)),  # noqa
                ('title_tr', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (tr)', blank=True)),  # noqa
                ('title_uk', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 (uk)', blank=True)),  # noqa
                ('station_name_plural_ru', TrimmedCharField(default=None, max_length=100, blank=True, help_text="\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, \u0434\u043b\u044f \u043f\u043e\u0435\u0437\u0434\u043e\u0432 - '\u0432\u043e\u043a\u0437\u0430\u043b\u044b'.", null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u0442\u0430\u043d\u0446\u0438\u0439 (ru)')),  # noqa
                ('station_name_plural_en', TrimmedCharField(default=None, max_length=100, blank=True, help_text="\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, \u0434\u043b\u044f \u043f\u043e\u0435\u0437\u0434\u043e\u0432 - '\u0432\u043e\u043a\u0437\u0430\u043b\u044b'.", null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u0442\u0430\u043d\u0446\u0438\u0439 (en)')),  # noqa
                ('station_name_plural_tr', TrimmedCharField(default=None, max_length=100, blank=True, help_text="\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, \u0434\u043b\u044f \u043f\u043e\u0435\u0437\u0434\u043e\u0432 - '\u0432\u043e\u043a\u0437\u0430\u043b\u044b'.", null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u0442\u0430\u043d\u0446\u0438\u0439 (tr)')),  # noqa
                ('station_name_plural_uk', TrimmedCharField(default=None, max_length=100, blank=True, help_text="\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, \u0434\u043b\u044f \u043f\u043e\u0435\u0437\u0434\u043e\u0432 - '\u0432\u043e\u043a\u0437\u0430\u043b\u044b'.", null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u0442\u0430\u043d\u0446\u0438\u0439 (uk)')),  # noqa
                ('title_plural_ru', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043c\u043d\u043e\u0436\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0435 (ru)', blank=True)),  # noqa
                ('title_plural_en', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043c\u043d\u043e\u0436\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0435 (en)', blank=True)),  # noqa
                ('title_plural_tr', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043c\u043d\u043e\u0436\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0435 (tr)', blank=True)),  # noqa
                ('title_plural_uk', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u043c\u043d\u043e\u0436\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0435 (uk)', blank=True)),  # noqa
                ('title_partner_page_ru', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0434\u043b\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u043e\u0432 (ru)', blank=True)),  # noqa
                ('title_partner_page_en', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0434\u043b\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u043e\u0432 (en)', blank=True)),  # noqa
                ('title_partner_page_tr', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0434\u043b\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u043e\u0432 (tr)', blank=True)),  # noqa
                ('title_partner_page_uk', TrimmedCharField(default=None, max_length=100, null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0434\u043b\u044f \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b \u043f\u0430\u0440\u0442\u043d\u0435\u0440\u043e\u0432 (uk)', blank=True)),  # noqa
                ('station_name_ru', TrimmedCharField(default=None, max_length=100, blank=True, help_text="\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, \u0434\u043b\u044f \u043f\u043e\u0435\u0437\u0434\u043e\u0432 - '\u0432\u043e\u043a\u0437\u0430\u043b'.", null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u0442\u0430\u043d\u0446\u0438\u0438 (ru)')),  # noqa
                ('station_name_en', TrimmedCharField(default=None, max_length=100, blank=True, help_text="\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, \u0434\u043b\u044f \u043f\u043e\u0435\u0437\u0434\u043e\u0432 - '\u0432\u043e\u043a\u0437\u0430\u043b'.", null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u0442\u0430\u043d\u0446\u0438\u0438 (en)')),  # noqa
                ('station_name_tr', TrimmedCharField(default=None, max_length=100, blank=True, help_text="\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, \u0434\u043b\u044f \u043f\u043e\u0435\u0437\u0434\u043e\u0432 - '\u0432\u043e\u043a\u0437\u0430\u043b'.", null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u0442\u0430\u043d\u0446\u0438\u0438 (tr)')),  # noqa
                ('station_name_uk', TrimmedCharField(default=None, max_length=100, blank=True, help_text="\u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, \u0434\u043b\u044f \u043f\u043e\u0435\u0437\u0434\u043e\u0432 - '\u0432\u043e\u043a\u0437\u0430\u043b'.", null=True, verbose_name='\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u0442\u0430\u043d\u0446\u0438\u0438 (uk)')),  # noqa
            ],
            options={
                'db_table': 'www_transporttype',
                'verbose_name': '\u0442\u0438\u043f \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430',
                'verbose_name_plural': '\u0442\u0438\u043f\u044b \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430',
            },
        ),
        migrations.CreateModel(
            name='VehicleProducer',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=100, verbose_name='\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435')),
                ('t_type', models.ForeignKey(verbose_name='\u0442\u0438\u043f \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430', to='www.TransportType')),
            ],
            options={
                'ordering': ('title',),
                'db_table': 'www_vehicleproducer',
                'verbose_name': '\u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u0435\u043b\u044c \u0422\u0421',
                'verbose_name_plural': '\u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u0435\u043b\u0438 \u0422\u0421',
            },
        ),
        migrations.AddField(
            model_name='transportsubtype',
            name='color',
            field=models.ForeignKey(default=None, blank=True, to='www.TransportSubtypeColor', null=True, verbose_name='\u0426\u0432\u0435\u0442'),
        ),
        migrations.AddField(
            model_name='transportsubtype',
            name='t_type',
            field=models.ForeignKey(related_name='subtype', verbose_name='\u0422\u0438\u043f \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430', to='www.TransportType'),
        ),
        migrations.AddField(
            model_name='transportmodel',
            name='producer',
            field=models.ForeignKey(default=None, blank=True, to='www.VehicleProducer', null=True, verbose_name='\u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u0435\u043b\u044c'),
        ),
        migrations.AddField(
            model_name='transportmodel',
            name='t_subtype',
            field=models.ForeignKey(default=None, blank=True, to='www.TransportSubtype', null=True, verbose_name='\u043f\u043e\u0434\u0442\u0438\u043f'),
        ),
        migrations.AddField(
            model_name='transportmodel',
            name='t_type',
            field=models.ForeignKey(verbose_name='\u0442\u0438\u043f', to='www.TransportType'),
        ),
        migrations.AddField(
            model_name='threadtariff',
            name='t_type',
            field=models.ForeignKey(verbose_name='\u0422\u0438\u043f \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430', to='www.TransportType'),
        ),
        migrations.AddField(
            model_name='stationtype',
            name='default_for_t_type',
            field=models.ForeignKey(null=True, default=None, to='www.TransportType', blank=True, unique=True, verbose_name='\u043f\u043e \u0443\u043c\u043e\u0447\u0430\u043d\u0438\u044e \u0434\u043b\u044f \u0442\u0438\u043f\u0430 \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430'),  # noqa
        ),
        migrations.AddField(
            model_name='stationpassage',
            name='terminal_from',
            field=models.ForeignKey(related_name='outgoing_passages', default=None, blank=True, to='www.StationTerminal', null=True, verbose_name='\u0441 \u043a\u0430\u043a\u043e\u0433\u043e \u0432\u044b\u0445\u043e\u0434\u0430'),  # noqa
        ),
        migrations.AddField(
            model_name='stationpassage',
            name='terminal_to',
            field=models.ForeignKey(related_name='incoming_passages', default=None, blank=True, to='www.StationTerminal', null=True, verbose_name='\u0434\u043e \u043a\u0430\u043a\u043e\u0433\u043e \u0432\u044b\u0445\u043e\u0434\u0430'),  # noqa
        ),
        migrations.AddField(
            model_name='station',
            name='majority',
            field=models.ForeignKey(verbose_name='\u0432\u0430\u0436\u043d\u043e\u0441\u0442\u044c \u0441\u0442\u0430\u043d\u0446\u0438\u0438', to='www.StationMajority'),
        ),
        migrations.AddField(
            model_name='station',
            name='properties',
            field=models.ManyToManyField(default=None, to='www.StationProperty', verbose_name='\u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430', blank=True),
        ),
        migrations.AddField(
            model_name='station',
            name='region',
            field=models.ForeignKey(default=None, blank=True, to='www.Region', null=True, verbose_name='\u043e\u0431\u043b\u0430\u0441\u0442\u044c'),
        ),
        migrations.AddField(
            model_name='station',
            name='settlement',
            field=models.ForeignKey(default=None, blank=True, to='www.Settlement', null=True, verbose_name='\u0433\u043e\u0440\u043e\u0434'),
        ),
        migrations.AddField(
            model_name='station',
            name='station_type',
            field=models.ForeignKey(default=12, verbose_name='\u0442\u0438\u043f \u0441\u0442\u0430\u043d\u0446\u0438\u0438', to='www.StationType'),
        ),
        migrations.AddField(
            model_name='station',
            name='suburban_zone',
            field=models.ForeignKey(default=None, blank=True, to='www.SuburbanZone', null=True, verbose_name='\u043f\u0440\u0438\u0433\u043e\u0440\u043e\u0434\u043d\u0430\u044f \u0437\u043e\u043d\u0430'),  # noqa
        ),
        migrations.AddField(
            model_name='station',
            name='supplier',
            field=models.ForeignKey(default=None, blank=True, to='www.Supplier', null=True, verbose_name='\u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a'),
        ),
        migrations.AddField(
            model_name='station',
            name='t_type',
            field=models.ForeignKey(default=1, verbose_name='\u0442\u0438\u043f \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430', to='www.TransportType'),
        ),
        migrations.AddField(
            model_name='specialoffer',
            name='airport_from',
            field=models.ForeignKey(related_name='special_offers_from', verbose_name='\u0430\u044d\u0440\u043e\u043f\u043e\u0440\u0442 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f', blank=True, to='www.Station', null=True),  # noqa
        ),
        migrations.AddField(
            model_name='specialoffer',
            name='airport_to',
            field=models.ForeignKey(related_name='special_offers_to', verbose_name='\u0430\u044d\u0440\u043e\u043f\u043e\u0440\u0442 \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f', blank=True, to='www.Station', null=True),  # noqa
        ),
        migrations.AddField(
            model_name='specialoffer',
            name='company',
            field=models.ForeignKey(verbose_name='\u0430\u0432\u0438\u0430\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u044f', to='www.Company'),
        ),
        migrations.AddField(
            model_name='specialoffer',
            name='settlement_from',
            field=models.ForeignKey(related_name='special_offers_from', verbose_name='\u0433\u043e\u0440\u043e\u0434 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f', to='www.Settlement'),  # noqa
        ),
        migrations.AddField(
            model_name='specialoffer',
            name='settlement_to',
            field=models.ForeignKey(related_name='special_offers_to', verbose_name='\u0433\u043e\u0440\u043e\u0434 \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f', to='www.Settlement'),
        ),
        migrations.AddField(
            model_name='settlementrelatedstations',
            name='station',
            field=models.ForeignKey(related_name='related_settlements', verbose_name='\u0441\u0442\u0430\u043d\u0446\u0438\u044f', to='www.Station'),
        ),
        migrations.AddField(
            model_name='settlement',
            name='properties',
            field=models.ManyToManyField(default=None, to='www.SettlementProperty', verbose_name='\u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430', blank=True),
        ),
        migrations.AddField(
            model_name='settlement',
            name='region',
            field=models.ForeignKey(default=None, blank=True, to='www.Region', null=True, verbose_name='\u043e\u0431\u043b\u0430\u0441\u0442\u044c'),
        ),
        migrations.AddField(
            model_name='settlement',
            name='suburban_zone',
            field=models.ForeignKey(related_name='settlement_set', blank=True, to='www.SuburbanZone', help_text='\u043f\u0440\u0438\u0433\u043e\u0440\u043e\u0434\u043d\u0430\u044f \u0437\u043e\u043d\u0430, \u0432 \u043a\u043e\u0442\u043e\u0440\u0443\u044e \u0432\u0445\u043e\u0434\u0438\u0442 \u0433\u043e\u0440\u043e\u0434', null=True, verbose_name='\u043f\u0440\u0438\u0433\u043e\u0440\u043e\u0434\u043d\u0430\u044f \u0437\u043e\u043d\u0430'),  # noqa
        ),
        migrations.AddField(
            model_name='scheduleexclusion',
            name='end_station',
            field=models.ForeignKey(related_name='scheduleexclusion_end_set', verbose_name='\u041a\u043e\u043d\u0435\u0447\u043d\u0430\u044f \u0441\u0442\u0430\u043d\u0446\u0438\u044f \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430', to='www.Station'),  # noqa
        ),
        migrations.AddField(
            model_name='scheduleexclusion',
            name='exclude_station',
            field=models.ForeignKey(verbose_name='\u0418\u0441\u043a\u043b\u044e\u0447\u0430\u0435\u043c\u0430\u044f \u0441\u0442\u0430\u043d\u0438\u044f', to='www.Station'),
        ),
        migrations.AddField(
            model_name='scheduleexclusion',
            name='start_station',
            field=models.ForeignKey(related_name='scheduleexclusion_start_set', verbose_name='\u041d\u0430\u0447\u0430\u043b\u044c\u043d\u0430\u044f \u0441\u0442\u0430\u043d\u0446\u0438\u044f \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430', to='www.Station'),  # noqa
        ),
        migrations.AddField(
            model_name='rtstation',
            name='arrival_t_model',
            field=models.ForeignKey(related_name='arrival_rtstation_set', default=None, blank=True, to='www.TransportModel', null=True, verbose_name='\u043c\u043e\u0434\u0435\u043b\u044c \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f'),  # noqa
        ),
        migrations.AddField(
            model_name='rtstation',
            name='departure_direction',
            field=models.ForeignKey(related_name='departure_rtstation_set', blank=True, to='www.Direction', help_text='\u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f', null=True, verbose_name='dep_direction'),  # noqa
        ),
        migrations.AddField(
            model_name='rtstation',
            name='departure_t_model',
            field=models.ForeignKey(related_name='departure_rtstation_set', default=None, blank=True, to='www.TransportModel', null=True, verbose_name='\u043c\u043e\u0434\u0435\u043b\u044c \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f'),  # noqa
        ),
        migrations.AddField(
            model_name='rtstation',
            name='next_station',
            field=models.ForeignKey(related_name='rtstation_next_station_set', verbose_name='\u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0430\u044f \u0441\u0442\u0430\u043d\u0446\u0438\u044f', to='www.Station', null=True),  # noqa
        ),
        migrations.AddField(
            model_name='rtstation',
            name='prev_station',
            field=models.ForeignKey(related_name='rtstation_prev_station_set', verbose_name='\u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0430\u044f \u0441\u0442\u0430\u043d\u0446\u0438\u044f', to='www.Station', null=True),  # noqa
        ),
        migrations.AddField(
            model_name='rtstation',
            name='station',
            field=models.ForeignKey(verbose_name='\u0441\u0442\u0430\u043d\u0446\u0438\u044f', to='www.Station'),
        ),
        migrations.AddField(
            model_name='rtstation',
            name='terminal',
            field=models.ForeignKey(default=None, blank=True, to='www.StationTerminal', null=True, verbose_name='\u0442\u0435\u0440\u043c\u0438\u043d\u0430\u043b'),
        ),
        migrations.AddField(
            model_name='rtstation',
            name='thread',
            field=models.ForeignKey(verbose_name='\u043d\u0438\u0442\u043a\u0430', to='www.RThread'),
        ),
        migrations.AddField(
            model_name='rthread',
            name='schedule_plan',
            field=models.ForeignKey(default=None, blank=True, to='www.TrainSchedulePlan', null=True, verbose_name='\u0433\u0440\u0430\u0444\u0438\u043a \u043f\u043e\u0435\u0437\u0434\u043e\u0432'),
        ),
        migrations.AddField(
            model_name='rthread',
            name='supplier',
            field=models.ForeignKey(default=None, blank=True, to='www.Supplier', null=True, verbose_name='\u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a \u043d\u0438\u0442\u043a\u0438'),
        ),
        migrations.AddField(
            model_name='rthread',
            name='t_model',
            field=models.ForeignKey(verbose_name='\u043c\u043e\u0434\u0435\u043b\u044c', blank=True, to='www.TransportModel', null=True),
        ),
        migrations.AddField(
            model_name='rthread',
            name='t_subtype',
            field=models.ForeignKey(default=None, blank=True, to='www.TransportSubtype', null=True, verbose_name='\u041f\u043e\u0434\u0442\u0438\u043f \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430'),  # noqa
        ),
        migrations.AddField(
            model_name='rthread',
            name='t_type',
            field=models.ForeignKey(verbose_name='\u0442\u0438\u043f \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430', to='www.TransportType'),
        ),
        migrations.AddField(
            model_name='rthread',
            name='tariff_type',
            field=models.ForeignKey(default=None, blank=True, to='www.TariffType', null=True, verbose_name='\u0442\u0438\u043f \u0446\u0435\u043d \u043d\u0430 \u044d\u043b\u0435\u043a\u0442\u0440\u0438\u0447\u043a\u0438'),  # noqa
        ),
        migrations.AddField(
            model_name='rthread',
            name='type',
            field=models.ForeignKey(default=None, verbose_name='\u0442\u0438\u043f', to='www.RThreadType'),
        ),
        migrations.AddField(
            model_name='routepath',
            name='station_from',
            field=models.ForeignKey(related_name='routesegment_directions_from', blank=True, to='www.Station', help_text='\u043d\u0430\u0447\u0430\u043b\u043e \u0433\u0435\u043e\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u043e\u0433\u043e \u0443\u0447\u0430\u0441\u0442\u043a\u0430', null=True, verbose_name='\u043e\u0442 \u0441\u0442\u0430\u043d\u0446\u0438\u0438'),  # noqa
        ),
        migrations.AddField(
            model_name='routepath',
            name='station_to',
            field=models.ForeignKey(related_name='routesegment_directions_to', blank=True, to='www.Station', help_text='\u043a\u043e\u043d\u0435\u0446 \u0433\u0435\u043e\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u043e\u0433\u043e \u0443\u0447\u0430\u0441\u0442\u043a\u0430', null=True, verbose_name='\u0434\u043e \u0441\u0442\u0430\u043d\u0446\u0438\u0438'),  # noqa
        ),
        migrations.AddField(
            model_name='routeimportinfo',
            name='supplier',
            field=models.ForeignKey(verbose_name='\u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a', to='www.Supplier'),
        ),
        migrations.AddField(
            model_name='routeimportinfo',
            name='t_type',
            field=models.ForeignKey(verbose_name='\u0442\u0438\u043f \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430', to='www.TransportType'),
        ),
        migrations.AddField(
            model_name='route',
            name='supplier',
            field=models.ForeignKey(verbose_name='\u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a', blank=True, to='www.Supplier'),
        ),
        migrations.AddField(
            model_name='route',
            name='t_type',
            field=models.ForeignKey(verbose_name='\u0442\u0438\u043f \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430', to='www.TransportType'),
        ),
        migrations.AddField(
            model_name='replaceexception',
            name='city_from',
            field=models.ForeignKey(related_name='city_from', verbose_name='\u0433\u043e\u0440\u043e\u0434 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f', to='www.Settlement'),
        ),
        migrations.AddField(
            model_name='replaceexception',
            name='city_to',
            field=models.ForeignKey(related_name='city_to', verbose_name='\u0433\u043e\u0440\u043e\u0434 \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f', blank=True, to='www.Settlement', null=True),
        ),
        migrations.AddField(
            model_name='replaceexception',
            name='station_to',
            field=models.ForeignKey(related_name='station_to', verbose_name='\u0441\u0442\u0430\u043d\u0446\u0438\u044f \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f', blank=True, to='www.Station', null=True),  # noqa
        ),
        migrations.AddField(
            model_name='gortranscitylink',
            name='city',
            field=models.ForeignKey(verbose_name='\u0433\u043e\u0440\u043e\u0434', to='www.Settlement'),
        ),
        migrations.AddField(
            model_name='facedirection',
            name='arrival_settlement',
            field=models.ForeignKey(related_name='arrival_facedirections', verbose_name='\u0413\u043e\u0440\u043e\u0434 \u043f\u0440\u0438\u0431\u044b\u0442\u0438\u044f', to='www.Settlement'),
        ),
        migrations.AddField(
            model_name='facedirection',
            name='departure_settlement',
            field=models.ForeignKey(related_name='departure_facedirections', verbose_name='\u0413\u043e\u0440\u043e\u0434 \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f', to='www.Settlement'),  # noqa
        ),
        migrations.AddField(
            model_name='facedirection',
            name='ttype',
            field=models.ForeignKey(verbose_name='\u0422\u0438\u043f \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430', to='www.TransportType'),
        ),
        migrations.AddField(
            model_name='externaldirectionmarker',
            name='station',
            field=models.ForeignKey(verbose_name='\u0441\u0442\u0430\u043d\u0446\u0438\u044f', to='www.Station'),
        ),
        migrations.AddField(
            model_name='externaldirection',
            name='base_station',
            field=models.ForeignKey(verbose_name='\u0431\u0430\u0437\u043e\u0432\u044b\u0439 \u0432\u043e\u043a\u0437\u0430\u043b', blank=True, to='www.Station', null=True),
        ),
        migrations.AddField(
            model_name='externaldirection',
            name='suburban_zone',
            field=models.ForeignKey(blank=True, to='www.SuburbanZone', help_text='\u043f\u0440\u0438\u0433\u043e\u0440\u043e\u0434\u043d\u0430\u044f \u0437\u043e\u043d\u0430, \u0432 \u043a\u043e\u0442\u043e\u0440\u0443\u044e \u0432\u0445\u043e\u0434\u0438\u0442 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435', null=True, verbose_name='\u043f\u0440\u0438\u0433\u043e\u0440\u043e\u0434\u043d\u0430\u044f \u0437\u043e\u043d\u0430'),  # noqa
        ),
        migrations.AddField(
            model_name='expressnumber',
            name='supplier',
            field=models.ForeignKey(verbose_name='\u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a', to='www.Supplier'),
        ),
        migrations.AddField(
            model_name='district',
            name='region',
            field=models.ForeignKey(verbose_name='\u043e\u0431\u043b\u0430\u0441\u0442\u044c', to='www.Region'),
        ),
        migrations.AddField(
            model_name='district',
            name='settlement',
            field=models.ForeignKey(related_name='districts', default=None, blank=True, to='www.Settlement', null=True, verbose_name='\u0433\u043e\u0440\u043e\u0434'),
        ),
        migrations.AddField(
            model_name='directionmarker',
            name='station',
            field=models.ForeignKey(blank=True, to='www.Station', help_text='\u0435\u0441\u043b\u0438 \u0441\u0442\u0430\u043d\u0446\u0438\u044f \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u0430, \u0442\u043e \u044d\u0442\u043e \u0441\u0442\u0440\u0435\u043b\u043a\u0430', null=True, verbose_name='\u0441\u0442\u0430\u043d\u0446\u0438\u044f'),  # noqa
        ),
        migrations.AddField(
            model_name='direction',
            name='suburban_zone',
            field=models.ForeignKey(blank=True, to='www.SuburbanZone', help_text='\u043f\u0440\u0438\u0433\u043e\u0440\u043e\u0434\u043d\u0430\u044f \u0437\u043e\u043d\u0430, \u0432 \u043a\u043e\u0442\u043e\u0440\u0443\u044e \u0432\u0445\u043e\u0434\u0438\u0442 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435', null=True, verbose_name='\u043f\u0440\u0438\u0433\u043e\u0440\u043e\u0434\u043d\u0430\u044f \u0437\u043e\u043d\u0430'),  # noqa
        ),
        migrations.AddField(
            model_name='defaultpoint',
            name='settlement',
            field=models.ForeignKey(verbose_name='\u0413\u043e\u0440\u043e\u0434', blank=True, to='www.Settlement', null=True),
        ),
        migrations.AddField(
            model_name='defaultpoint',
            name='station',
            field=models.ForeignKey(verbose_name='\u0421\u0442\u0430\u043d\u0446\u0438\u044f', blank=True, to='www.Station', null=True),
        ),
        migrations.AddField(
            model_name='companyoffice',
            name='main_station',
            field=models.ForeignKey(default=None, blank=True, to='www.Station', null=True, verbose_name='\u0413\u043b\u0430\u0432\u043d\u0430\u044f \u0441\u0442\u0430\u043d\u0446\u0438\u044f'),
        ),
        migrations.AddField(
            model_name='companyoffice',
            name='settlement',
            field=models.ForeignKey(verbose_name='\u0413\u043e\u0440\u043e\u0434', to='www.Settlement'),
        ),
        migrations.AddField(
            model_name='company',
            name='country',
            field=models.ForeignKey(default=None, blank=True, to='www.Country', null=True, verbose_name='\u0441\u0442\u0440\u0430\u043d\u0430'),
        ),
        migrations.AddField(
            model_name='company',
            name='home_station',
            field=models.ForeignKey(verbose_name='\u0433\u043b\u0430\u0432\u043d\u0430\u044f \u0441\u0442\u0430\u043d\u0446\u0438\u044f', blank=True, to='www.Station', null=True),
        ),
        migrations.AddField(
            model_name='company',
            name='t_type',
            field=models.ForeignKey(default=None, blank=True, to='www.TransportType', null=True, verbose_name='\u0442\u0438\u043f \u0442\u0440\u0430\u043d\u0441\u043f\u043e\u0440\u0442\u0430'),
        ),
        migrations.AddField(
            model_name='aeroextariff',
            name='station_from',
            field=models.ForeignKey(related_name='aeroex_tariffs_from', verbose_name='\u043f\u0435\u0440\u0432\u0430\u044f \u0441\u0442\u0430\u043d\u0446\u0438\u044f', to='www.Station'),
        ),
        migrations.AddField(
            model_name='aeroextariff',
            name='station_to',
            field=models.ForeignKey(related_name='aeroex_tariffs_to', verbose_name='\u043f\u043e\u0441\u043b\u0435\u0434\u043d\u044f\u044f \u0441\u0442\u0430\u043d\u0446\u0438\u044f', to='www.Station'),  # noqa
        ),
        migrations.AddField(
            model_name='aeroextariff',
            name='type',
            field=models.ForeignKey(default=1, to='www.TariffType'),
        ),
        migrations.AlterUniqueTogether(
            name='trainpseudostationmap',
            unique_together=set([('number', 'station')]),
        ),
        migrations.AlterIndexTogether(
            name='threadtariff',
            index_together=set([('settlement_from', 'settlement_to'), ('settlement_from', 'station_to'), ('station_from', 'settlement_to'), ('station_from', 'station_to')]),
        ),
        migrations.AlterUniqueTogether(
            name='stationcode',
            unique_together=set([('system', 'code'), ('station', 'system')]),
        ),
        migrations.AlterUniqueTogether(
            name='settlementcode',
            unique_together=set([('system', 'code'), ('settlement', 'system')]),
        ),
        migrations.AlterUniqueTogether(
            name='rthread',
            unique_together=set([('route', 'ordinal_number')]),
        ),
        migrations.AlterUniqueTogether(
            name='routeimportinfo',
            unique_together=set([('number', 'supplier')]),
        ),
        migrations.AlterUniqueTogether(
            name='route2company',
            unique_together=set([('number', 'company')]),
        ),
        migrations.AlterUniqueTogether(
            name='route',
            unique_together=set([('route_uid', 't_type', 'supplier')]),
        ),
        migrations.AlterUniqueTogether(
            name='externaldirectionmarker',
            unique_together=set([('external_direction', 'order'), ('external_direction', 'station')]),
        ),
        migrations.AlterUniqueTogether(
            name='directionmarker',
            unique_together=set([('direction', 'order'), ('direction', 'station')]),
        ),
        migrations.AlterUniqueTogether(
            name='aeroextariff',
            unique_together=set([('station_from', 'station_to', 'type', 'precalc')]),
        ),
    ]
