# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models
import django.core.validators


class Migration(migrations.Migration):

    dependencies = [
        ('www', '0002_default_for_t_type'),
    ]

    operations = [
        migrations.CreateModel(
            name='RouteSchedule',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('station_from', models.ForeignKey(related_name='+', to='www.Station')),
                ('station_to', models.ForeignKey(related_name='+', to='www.Station')),
                ('route_number', models.CharField(max_length=16)),
                ('t_model', models.ForeignKey(to='www.TransportModel', null=True)),
                ('run_mask', models.CharField(max_length=372, validators=[django.core.validators.MinLengthValidator(372)])),
            ],
            options={
                'db_table': 'www_routeschedule',
            },
        ),
        migrations.AlterUniqueTogether(
            name='routeschedule',
            unique_together=set([('station_from', 'station_to', 'route_number', 't_model')]),
        ),
    ]
