# -*- coding: utf-8 -*-
from django.db import migrations

from travel.avia.library.python.common.utils.geobase import geobase


def _text_attributes(apps):
    AviaAlliance = apps.get_model('www', 'AviaAlliance')
    Company = apps.get_model('www', 'Company')
    Station = apps.get_model('www', 'Station')

    return {
        AviaAlliance: (
            'new_L_description',
        ),
        Company: (
            'new_L_registration_phone',
            'new_L_registration_url',
        ),
        Station: (
            'new_L_address',
            'new_L_how_to_get_to_city',
        ),
    }


def _title_attributes(apps):
    AviaAlliance = apps.get_model('www', 'AviaAlliance')
    DefaultSuggest = apps.get_model('www', 'DefaultSuggest')
    DeluxeTrain = apps.get_model('www', 'DeluxeTrain')
    PlatformTranslation = apps.get_model('www', 'PlatformTranslation')
    Company = apps.get_model('www', 'Company')
    Country = apps.get_model('www', 'Country')
    ExternalDirection = apps.get_model('www', 'ExternalDirection')
    Region = apps.get_model('www', 'Region')
    Settlement = apps.get_model('www', 'Settlement')
    Station = apps.get_model('www', 'Station')
    StationMajority = apps.get_model('www', 'StationMajority')
    StationType = apps.get_model('www', 'StationType')
    SuburbanZone = apps.get_model('www', 'SuburbanZone')

    return {
        AviaAlliance: (
            'new_L_title',
        ),
        DefaultSuggest: (
            'new_L_value',
        ),
        DeluxeTrain: (
            'new_L_title',
        ),
        PlatformTranslation: (
            'new_L_platform',
        ),
        Company: (
            'new_L_short_title',
            'new_L_title',
        ),
        Country: (
            'new_L_title',
        ),
        ExternalDirection: (
            'new_L_full_title',
            'new_L_title',
        ),
        Region: (
            'new_L_title',
        ),
        Settlement: (
            'new_L_abbr_title',
            'new_L_title',
        ),
        Station: (
            'new_L_title',
            'new_L_popular_title',
            'new_L_short_title',
        ),
        StationMajority: (
            'new_L_title',
        ),
        StationType: (
            'new_L_name',
            'new_L_prefix',
            'new_L_railway_prefix',
        ),
        SuburbanZone: (
            'new_L_title',
        ),
    }


def _add_text_translations(apps, schema_editor):
    TranslatedText = apps.get_model('www', 'TranslatedText')

    for model, new_fields in _text_attributes(apps).iteritems():
        for entity in model.objects.all():
            for new_field in new_fields:
                old_field = new_field.replace('new_L_', '')

                text = TranslatedText(**{
                    lang: getattr(
                        entity, u'{}_{}'.format(old_field, lang), None
                    ) or None
                    for lang in ('ru', 'en', 'uk', 'tr')
                })
                if not text.ru:
                    text.ru = getattr(entity, old_field, None) or None
                text.save()

                setattr(entity, new_field, text)

            entity.save()


def _add_title_translations(apps, schema_editor):
    TranslatedTitle = apps.get_model('www', 'TranslatedTitle')

    for model, new_fields in _title_attributes(apps).iteritems():
        for entity in model.objects.all():
            for new_field in new_fields:
                old_field = new_field.replace('new_L_', '')

                title = TranslatedTitle(**{
                    '{}_{}'.format(lang, case): (
                        getattr(entity, u'{}_{}_{}'.format(old_field, lang, case), None) or
                        (
                            (
                                getattr(entity, u'{}_{}'.format(old_field, lang), None) or
                                (
                                    getattr(entity, old_field, None)
                                    if lang == 'ru'
                                    else None
                                )
                            )
                            if case == 'nominative'
                            else None
                        )
                    ) or (
                        getattr(geobase.linguistics(entity._geo_id, lang), case, None)
                        if new_field == 'new_L_title' and
                           getattr(entity, '_geo_id', None) is not None
                        else None
                    )

                    for lang, case in (
                        ('ru', 'nominative'),
                        ('ru', 'genitive'),
                        ('ru', 'dative'),
                        ('ru', 'accusative'),
                        ('ru', 'locative'),

                        ('en', 'nominative'),

                        ('tr', 'nominative'),

                        ('uk', 'accusative'),
                        ('uk', 'nominative'),
                    )
                })

                title.save()
                setattr(entity, new_field, title)

            entity.save()


class Migration(migrations.Migration):

    dependencies = [
        ('www', '0002_translation_models'),
    ]

    operations = [
        migrations.RunPython(code=_add_title_translations),
        migrations.RunPython(code=_add_text_translations),
    ]
