# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import codecs
import os
from collections import defaultdict

from django.db import migrations


def import_de_settlement_translations(apps, schema_editor):
    titles_by_geo_id = defaultdict(set)

    filename = os.path.join(
        os.path.dirname(__file__), 'data/de_settlements.yamr'
    )

    with codecs.open(filename, encoding='utf-8') as translations_file:
        for line in translations_file:
            city_id, title = line.strip().split('\t')
            titles_by_geo_id[city_id].add(title)

    nominative_by_geo_id = {
        int(city_id): list(titles)[0]
        for city_id, titles in titles_by_geo_id.iteritems()
        if len(titles) == 1
    }

    Settlement = apps.get_model('www', 'Settlement')

    for settlement in Settlement.objects.filter(
        _geo_id__in=nominative_by_geo_id.keys()
    ):
        l_title = settlement.new_L_title
        l_title.de_nominative = nominative_by_geo_id[settlement._geo_id]
        l_title.save()


class Migration(migrations.Migration):

    dependencies = [
        ('www', '0005_de_translations_fields'),
    ]

    operations = [
        migrations.RunPython(import_de_settlement_translations),
    ]
