# -*- coding: utf-8 -*-
from __future__ import unicode_literals
import json
import os

from django.db import migrations

from travel.avia.library.python.common.models.transport import TransportType


def fill_logo2(apps, schema_editor):
    Company = apps.get_model('www', 'Company')
    data_file = os.path.join(os.path.dirname(__file__), 'data/avatar_urls.json')

    with open(data_file) as f:
        urls = json.load(f)

    def get_url(field):
        if field:
            return urls.get('https://yastatic.net/rasp/media/{}'.format(field), 'foo')
        return 'bar'

    for c in Company.objects.filter(t_type_id=TransportType.PLANE_ID):
        c.svg_logo2 = get_url(c.svg_logo)
        c.svg2png_logo2 = get_url(c.svg2png_logo)
        c.save()


def clear_logo2(apps, schema_editor):
    pass


class Migration(migrations.Migration):

    dependencies = [
        ('www', '0006_auto_20170129_1255'),
    ]

    operations = [
        migrations.RunPython(fill_logo2, reverse_code=clear_logo2),
    ]
