# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations
from travel.avia.library.python.common.utils.fields import CodeCharField

from travel.avia.library.python.common.models.schedule import make_slug
from travel.avia.library.python.common.models.transport import TransportType


def fill_slug(apps, schema_editor):
    Company = apps.get_model('www', 'Company')

    for c in Company.objects.filter(t_type_id=TransportType.PLANE_ID):
        c.slug = make_slug(c)
        c.save()


def noop(apps, schema_editor):
    pass


class Migration(migrations.Migration):

    dependencies = [
        ('www', '0009_fill_production_avatar_urls'),
    ]

    operations = [
        migrations.AddField(
            model_name='company',
            name='slug',
            field=CodeCharField(null=True, default=None, max_length=255, blank=True, unique=True, verbose_name='\u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0434\u043b\u044f \u0427\u041f\u0423'),  # noqa
        ),
        migrations.RunPython(fill_slug, reverse_code=noop),
    ]
