# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import csv
import os
import logging

from django.db import migrations

from travel.avia.admin.lib.logs import add_stdout_handler, create_current_file_run_log


def read_dict_from_csv(filepath, **reader_kwargs):
    csv_reader = csv.reader(filepath, **reader_kwargs)
    return {
        unicode(key, 'utf-8'): unicode(value, 'utf-8')
        for key, value in csv_reader
    }


def append_german_translation(apps, schema_editor):
    log = logging.getLogger("www.migrations")
    create_current_file_run_log()
    add_stdout_handler(log)

    filename = os.path.join(
        os.path.dirname(__file__), 'data/countries_de.csv'
    )

    with open(filename, 'rU') as csvfile:
        countries = read_dict_from_csv(csvfile, delimiter=str(','))

    apps.get_model('www', 'TranslatedTitle')
    country_model = apps.get_model('www', 'Country')

    for country in country_model.objects.all():
        translation = country.new_L_title

        ru_title = translation.ru_nominative
        try:
            de_title = countries[ru_title]
            de_old = translation.de_nominative
            if de_old is not None:
                if de_old == de_title:
                    log.info("[Skip] ru: %s", ru_title)
                else:
                    log.info("[Conflict] ru: %s old_de: %s new_de %s", ru_title, de_old, de_title)
            else:
                translation.de_nominative = de_title
                translation.save()
                log.info("[Done] ru: %s", ru_title)
        except KeyError:
            log.info("[Not found] ru: %s", ru_title)


class Migration(migrations.Migration):

    dependencies = [
        ('www', '0012_de_settlement_translations'),
    ]

    operations = [
        migrations.RunPython(append_german_translation)
    ]
