# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import csv
import os
import logging

from django.db import migrations

from travel.avia.admin.lib.logs import add_stdout_handler, create_current_file_run_log


def read_dict_from_csv(filepath, **reader_kwargs):
    csv_reader = csv.reader(filepath, **reader_kwargs)
    return {
        unicode(key, 'utf-8'): unicode(value, 'utf-8')
        for key, value in csv_reader
    }


def add_settlemnt_to_station(apps, schema_editor):
    log = logging.getLogger('www.migrations')
    create_current_file_run_log()
    add_stdout_handler(log)

    filename = os.path.join(
        os.path.dirname(__file__), 'data/resorts.csv'
    )

    settlement_model = apps.get_model('www', 'Settlement')
    station2settlement_model = apps.get_model('www', 'Station2Settlement')
    station_model = apps.get_model('www', 'Station')

    with open(filename, 'rU') as csvfile:
        resorts = read_dict_from_csv(csvfile, delimiter=str(','))  # ResortId -> NearestCityGeoId

    for resort_geoid, settlement_geoid in resorts.iteritems():
        settlement = settlement_model.objects.filter(_geo_id=settlement_geoid).all()

        if len(settlement) != 1:
            if len(settlement) == 0:
                log.info('[Settlement not found] geoId: %s, resortGeoId: %s', settlement_geoid, resort_geoid)
            else:
                log.info('[MultipleSettlement] geoId: %s, resortGeoId: %s', settlement_geoid, resort_geoid)

            continue

        settlement = settlement[0]
        settlement_id = settlement.id

        stations = list(
            station_model.objects.filter(settlement_id=settlement_id, t_type_id=2).all()
        )
        stations.extend(
            station2settlement_model.objects.filter(settlement_id=settlement_id).all()
        )

        if len(stations) != 1:
            if len(stations) == 0:
                log.info('[Stations not found] geoId: %s, resortGeoId: %s', settlement_geoid, resort_geoid)
            else:
                log.info('[Many stations] geoId: %s, resortGeoId: %s', settlement_geoid, resort_geoid)

            continue

        station_id = stations[0].id

        resorts = settlement_model.objects.filter(_geo_id=resort_geoid).all()
        if len(resorts) != 1:
            if len(resorts) == 0:
                log.info('[Resort not found] resortGeoId: %s', resort_geoid)
            else:
                log.info('[Many resorts] resortGeoId: %s', resort_geoid)

            continue

        resort_id = resorts[0].id

        already_done = station2settlement_model.objects.filter(
            station_id=station_id,
            settlement_id=resort_id,
        ).all()

        if len(already_done) != 0:
            log.info(
                '[Skip] resortGeoId: %s, settlementGeoId: %s',
                resort_geoid,
                settlement_geoid,
            )
        else:
            station2settlement_model.objects.create(
                station_id=station_id,
                settlement_id=resort_id,
            )

            log.info(
                '[OK] resortGeoId: %s, settlementGeoId: %s',
                resort_geoid,
                settlement_geoid,
            )


class Migration(migrations.Migration):

    dependencies = [
        ('www', '0013_de_countries_translations'),
    ]

    operations = [
        migrations.RunPython(add_settlemnt_to_station)
    ]
