# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations


class Migration(migrations.Migration):

    dependencies = [
        ('www', '0015_transport-new-plane-fields'),
    ]
    operations = [
        migrations.RunSQL("""CREATE TABLE IF NOT EXISTS `www_threadtariff` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `thread_uid` varchar(100) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `station_from_id` int(11) NOT NULL,
  `station_to_id` int(11) NOT NULL,
  `tariff` double NOT NULL,
  `year_days` longtext NOT NULL,
  `currency` varchar(10) DEFAULT NULL,
  `url` varchar(255) NOT NULL,
  `data` longtext NOT NULL,
  `is_min_tariff` tinyint(1) NOT NULL,
  `settlement_from_id` int(11) DEFAULT NULL,
  `settlement_to_id` int(11) DEFAULT NULL,
  `year_days_from` longtext NOT NULL,
  `time_from` time NOT NULL,
  `time_zone_from` varchar(30) NOT NULL,
  `duration` int(11) NOT NULL,
  `time_to` time NOT NULL,
  `time_zone_to` varchar(30) NOT NULL,
  `supplier_id` int(11) NOT NULL,
  `number` varchar(100) NOT NULL DEFAULT '',
  `t_type_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `www_threadtariff__settlement_from_id__fk` FOREIGN KEY (`settlement_from_id`) REFERENCES `www_settlement` (`id`),
  CONSTRAINT `www_threadtariff__settlement_to_id__fk` FOREIGN KEY (`settlement_to_id`) REFERENCES `www_settlement` (`id`),
  CONSTRAINT `www_threadtariff__supplier_id__fk` FOREIGN KEY (`supplier_id`) REFERENCES `www_supplier` (`id`),
  CONSTRAINT `www_threadtariff__t_type_id__fk` FOREIGN KEY (`t_type_id`) REFERENCES `www_transporttype` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=435437404 DEFAULT CHARSET=utf8;""", reverse_sql=migrations.RunSQL.noop)
    ]
