# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import csv
import os

from django.db import migrations


def _create_scripts(apps, schema_editor):
    Script = apps.get_model('www', 'Script')

    for code, description, command, timeout in _read_scripts_from_file():
        Script(
            code=code,
            description=description,
            command=command,
            timeout=timeout
        ).save()


def _read_scripts_from_file():
    result = []
    filename = os.path.join(
        os.path.dirname(__file__), 'data/scripts.csv'
    )
    with open(filename, 'rU') as csvfile:
        csv_reader = csv.reader(csvfile, dialect='excel')
        next(csv_reader, None)
        for row in csv_reader:
            code, description, command, timeout = [unicode(cell, 'utf-8') for cell in row]
            result.append((code, description, command, int(timeout)))

    return result


class Migration(migrations.Migration):

    dependencies = [
        ('www', '0016_script_scriptresult'),
    ]

    operations = [
        migrations.RunPython(_create_scripts, reverse_code=migrations.RunPython.noop),
    ]
