# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations


def _create_scripts(apps, schema_editor):
    apps.get_model('www', 'Script')(
        code='rebuilld_partner_popularity',
        description='update partner popularity by national versions and routes',
        command='python -W ignore '
                '{project_root}/avia_scripts/rebuilld_partner_popularity.py',
        timeout=2700
    ).save()


class Migration(migrations.Migration):

    dependencies = [
        ('www', '0020_auto_20170806_0107'),
    ]

    operations = [
        migrations.RunPython(
            _create_scripts,
            reverse_code=migrations.RunPython.noop
        ),
    ]
