# -*- coding: utf-8 -*-
import csv
import os
from datetime import date
import logging
from itertools import chain

from django.db import migrations


def import_new_year_with_directions(apps, schema_editor):
    log = logging.getLogger("www.migrations")
    filename = os.path.join(
        os.path.dirname(__file__), 'data/new_year_directions.csv'
    )

    with open(filename, 'r') as csvfile:
        csv_reader = csv.reader(csvfile, delimiter=';')
        city_rows = list(csv_reader)

    Holiday = apps.get_model('www', 'Holiday')
    Settlement = apps.get_model('www', 'Settlement')

    new_year = Holiday(
        title='Новый год',
        first_segment_first_day=date(2018, 1, 1),
        first_segment_last_day=date(2018, 1, 8)
    )
    new_year.save()

    unique_city_ids = list(set(chain.from_iterable(city_rows)))

    existing_ids = Settlement.objects.filter(id__in=unique_city_ids).values_list('id', flat=True)

    filtered_city_rows = [
        row for row in city_rows
        if row[0] in existing_ids and row[1] in existing_ids
    ]

    for city_row in filtered_city_rows:
        log.info("row %r", city_row)

        new_year.holiday_directions.create(
            settlement_from_id=city_row[0],
            settlement_to_id=city_row[1]
        )


class Migration(migrations.Migration):
    dependencies = [
        ('www', '0027_auto_20171124_1657'),
    ]

    operations = [
        migrations.RunPython(import_new_year_with_directions),
    ]
