# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models


def _fill_team_and_services(apps, schema_editor):
    Team = apps.get_model('www', 'Team')
    Service = apps.get_model('www', 'Service')

    avia_team = Team(id=1, code='avia')
    avia_team.save()
    rasp_team = Team(id=2, code='rasp')
    rasp_team.save()

    code_to_team = {
        'rasp': rasp_team,
        'avia': avia_team
    }

    service_to_team = {
        (1, 'ticket', 'avia', 'Десктопная версия'),
        (2, 'm_avia', 'avia', 'Тач версия'),
        (3, 'api_avia', 'avia', 'Публичное апи'),
        (4, 'sovetnik', 'avia', 'Советник'),
        (5, '42', 'avia', 'Грелка'),
        (6, 'tours', 'avia', 'Яндекс.Путешествия'),
        (7, 'welcome2018', 'avia', 'Чемпионат мира по футболу 2018'),
        (8, 'rasp_api_public', 'rasp', 'Публичное апи расписаний'),
        (9, 'rasp_mobile', 'rasp', 'PDA версия расписаний'),
        (10, 'rasp_morda', 'rasp', 'Старая десктопная версия расписаний'),
        (11, 'rasp_morda_backend', 'rasp', 'Бэкэнд расписания'),
        (12, 'rasp_touch', 'rasp', 'Тач версия расписаний'),
    }

    for pk, service_code, team_code, description in service_to_team:
        Service(
            id=pk,
            code=service_code,
            team=code_to_team[team_code],
            description=description
        ).save()


def _fill_cabin_classes(apps, schema_editor):
    CabinClass = apps.get_model('www', 'CabinClass')
    CabinClass(id=1, code='economy').save()
    CabinClass(id=2, code='business').save()


class Migration(migrations.Migration):

    dependencies = [
        ('www', '0029_merge'),
    ]

    operations = [
        migrations.CreateModel(
            name='CabinClass',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('code', models.CharField(unique=True, max_length=10, verbose_name='\u043a\u043e\u0434')),
            ],
            options={
                'db_table': 'www_cabinclass',
                'verbose_name': '\u0442\u0438\u043f \u043a\u043b\u0430\u0441\u0441\u0430 \u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u044f',
                'verbose_name_plural': '\u0442\u0438\u043f\u044b \u043a\u043b\u0430\u0441\u0441\u0430 \u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u044f',
            },
        ),
        migrations.CreateModel(
            name='Service',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('code', models.CharField(unique=True, max_length=20, verbose_name='\u043a\u043e\u0434')),
                ('description', models.CharField(max_length=255, verbose_name='\u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435')),
            ],
            options={
                'db_table': 'www_service',
                'verbose_name': '\u0441\u0435\u0440\u0432\u0438\u0441',
                'verbose_name_plural': '\u0441\u0435\u0440\u0432\u0438\u0441\u044b',
            },
        ),
        migrations.CreateModel(
            name='Team',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('code', models.CharField(unique=True, max_length=10, verbose_name='\u043a\u043e\u0434')),
                ('description', models.CharField(max_length=255, verbose_name='\u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435')),
            ],
            options={
                'db_table': 'www_team',
                'verbose_name': '\u043a\u043e\u043c\u0430\u043d\u0434\u0430',
                'verbose_name_plural': '\u043a\u043e\u043c\u0430\u043d\u0434\u044b',
            },
        ),
        migrations.AddField(
            model_name='service',
            name='team',
            field=models.ForeignKey(related_name='team_service', verbose_name='\u043a\u043e\u043c\u0430\u043d\u0434\u0430', to='www.Team'),
        ),
        migrations.RunPython(_fill_cabin_classes),
        migrations.RunPython(_fill_team_and_services),
    ]
