# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import os
import ujson

from django.db import migrations
from django.core.exceptions import ObjectDoesNotExist

from travel.avia.library.python.common.models.schedule import Company, CompanySynonym


def _get_raw_companies_synonyms():
    current_directory = os.path.dirname(os.path.realpath(__file__))
    synonyms_local_path = 'data/initial_airlines_synonyms.json'
    synonyms_path = os.path.join(current_directory, synonyms_local_path)

    with open(synonyms_path, 'r') as input_file:
        return ujson.load(input_file)


def _get_companies_synonyms(raw_data):
    all_companies = Company.objects.all()

    companies_synonyms = []

    for airline in raw_data:
        airline_id = int(airline['id'])

        for language, synonyms in airline['synonyms'].iteritems():
            for synonym in synonyms:
                try:
                    company = all_companies.get(id=airline_id)

                    companies_synonyms.append(
                        CompanySynonym(
                            synonym=synonym,
                            language=language,
                            company=company
                        )
                    )
                except ObjectDoesNotExist:
                    continue

    return companies_synonyms


def fill_companysynonym(apps, schema_editor):
    raw_companies_synonyms = _get_raw_companies_synonyms()
    companies_synonyms = _get_companies_synonyms(raw_companies_synonyms)
    CompanySynonym.objects.bulk_create(companies_synonyms)


class Migration(migrations.Migration):

    dependencies = [
        ('avia_data', '0053_volgograd_time_zone_stations'),
        ('www', '0031_companysynonym'),
    ]

    operations = [
        migrations.RunPython(fill_companysynonym)
    ]
