# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations


def _update_service_table(apps, schema_editor):
    Team = apps.get_model('www', 'Team')
    Service = apps.get_model('www', 'Service')

    teams = Team.objects.all()
    code_to_team = {team.code: team for team in teams}

    service_to_team = {
        (13, 'wizard', 'avia', 'Колдунщик авиабилетов'),
        (14, 'email_subscriptions', 'avia', 'Подписки на изменение цен'),
    }

    for pk, service_code, team_code, description in service_to_team:
        Service(
            id=pk,
            code=service_code,
            team=code_to_team[team_code],
            description=description
        ).save()


class Migration(migrations.Migration):
    dependencies = [
        ('www', '0032_initial_companysynonym_data'),
    ]

    operations = [
        migrations.RunPython(_update_service_table)
    ]
