# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations


class Migration(migrations.Migration):

    dependencies = [
        ('importinfo', '0001_initial'),
        ('order', '0063_partner_variants_ttl'),
        ('avia_data', '0078_add_missing_foreign_key_constraints'),
        ('www', '0037_add-foreign-key-from-www_stationcode-to-www_station'),
    ]

    create_add_missing_foreign_key_constraints_to_www_country_procedure = """
        CREATE PROCEDURE add_missing_foreign_key_constraints_to_www_country()
        BEGIN
            DECLARE referrer_table char(64) DEFAULT NULL;
            DECLARE referrer_table_fk char(64) DEFAULT NULL;
            DECLARE done TINYINT DEFAULT FALSE;
            DECLARE is_nullable TINYINT DEFAULT FALSE;
            DECLARE referrer_table_fetcher
                CURSOR FOR
                select table_name, column_name, is_nullable from information_schema.columns where
                column_name regexp '^(.+_)?country(_from|_to)?_idx?$'
                    and table_schema = DATABASE()
                and table_name not in
                  (     select table_name
                  FROM information_schema.KEY_COLUMN_USAGE
                  WHERE          REFERENCED_TABLE_NAME = "www_country"
                  AND REFERENCED_COLUMN_NAME = "id"
                  AND CONSTRAINT_SCHEMA = DATABASE() );
            DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = TRUE;
            OPEN referrer_table_fetcher;
            offset_loop:
            LOOP
                FETCH NEXT FROM referrer_table_fetcher INTO referrer_table, referrer_table_fk, is_nullable;
                SELECT concat(referrer_table, ' ', referrer_table_fk);
                IF done THEN
                    LEAVE offset_loop;
                ELSE
                    IF is_nullable THEN
                        SET @query = CONCAT(' UPDATE ', referrer_table, ' SET ', referrer_table_fk,
                                            '=NULL WHERE ', referrer_table_fk, ' NOT IN (SELECT id from www_country)');
                        PREPARE statement FROM @query;
                        EXECUTE statement;
                        DEALLOCATE PREPARE statement;
                    ELSE
                        SET @query = CONCAT(' DELETE FROM ', referrer_table, ' WHERE ', referrer_table_fk,
                                            ' NOT IN (SELECT id from www_country)');
                        PREPARE statement FROM @query;
                        EXECUTE statement;
                        DEALLOCATE PREPARE statement;
                    END IF;
                    SET @query = CONCAT(' ALTER TABLE ', referrer_table, ' ADD CONSTRAINT ',
                                        ' FOREIGN KEY (', referrer_table_fk, ') ', ' REFERENCES www_country  (id)
                                        ON UPDATE CASCADE ON DELETE CASCADE;');
                    PREPARE statement FROM @query;
                    EXECUTE statement;
                    DEALLOCATE PREPARE statement;
                END IF;
            END LOOP;
        END;
    """

    create_fix_existing_foreign_key_constraints_to_www_country_procedure = """
        CREATE PROCEDURE fix_existing_foreign_key_constraints_to_www_country(referrer_table_name CHAR(64), referer_column_name CHAR(64))
        BEGIN

            DECLARE referrer_table char(64) DEFAULT NULL;
            DECLARE referrer_table_fk char(64) DEFAULT NULL;
            DECLARE referrer_table_constraint char(64) DEFAULT NULL;

            DECLARE done TINYINT DEFAULT FALSE;

            DECLARE referrer_table_fetcher
                CURSOR FOR
                SELECT TABLE_NAME, COLUMN_NAME, CONSTRAINT_NAME
                FROM information_schema.KEY_COLUMN_USAGE
                WHERE REFERENCED_TABLE_NAME = "www_country"
                  AND REFERENCED_COLUMN_NAME = "id"
                  AND TABLE_NAME = referrer_table_name
                  AND COLUMN_NAME = referer_column_name
                  AND CONSTRAINT_SCHEMA = DATABASE();

            # catch exception when cursour runs out of rows
            DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = TRUE;

            OPEN referrer_table_fetcher;

            offset_loop:
            LOOP

                FETCH NEXT FROM referrer_table_fetcher INTO referrer_table, referrer_table_fk, referrer_table_constraint;
                SELECT concat(referrer_table, ' ', referrer_table_fk, ' ', referrer_table_constraint);
                IF done THEN
                    LEAVE offset_loop;
                ELSE
                    # prepared statements are used as a way to pass things like table name to query.
                    SET @query = CONCAT('ALTER TABLE ', referrer_table, ' DROP FOREIGN KEY ', referrer_table_constraint, ';');
                    PREPARE statement FROM @query;
                    EXECUTE statement;
                    DEALLOCATE PREPARE statement;

                    SET @query = CONCAT(' ALTER TABLE ', referrer_table, ' ADD CONSTRAINT ', referrer_table_constraint,
                                        ' FOREIGN KEY (', referrer_table_fk, ') ', ' REFERENCES www_country(id)',
                                        ' ON UPDATE CASCADE ON DELETE CASCADE;');
                    PREPARE statement FROM @query;
                    EXECUTE statement;
                    DEALLOCATE PREPARE statement;

                END IF;

            END LOOP;

        END;
    """

    operations = [
        migrations.RunSQL('DROP PROCEDURE IF EXISTS add_missing_foreign_key_constraints_to_www_country', reverse_sql=''),
        migrations.RunSQL(create_add_missing_foreign_key_constraints_to_www_country_procedure, reverse_sql=''),
        migrations.RunSQL('CALL add_missing_foreign_key_constraints_to_www_country()', reverse_sql=''),
        migrations.RunSQL('DROP PROCEDURE IF EXISTS add_missing_foreign_key_constraints_to_www_country', reverse_sql=''),

        migrations.RunSQL('DROP PROCEDURE IF EXISTS fix_existing_foreign_key_constraints_to_www_country;', reverse_sql=''),
        migrations.RunSQL(create_fix_existing_foreign_key_constraints_to_www_country_procedure, reverse_sql=''),
        migrations.RunSQL('CALL fix_existing_foreign_key_constraints_to_www_country("avia_selfbookdirection","country_from_id")', reverse_sql=''),
        migrations.RunSQL('CALL fix_existing_foreign_key_constraints_to_www_country("avia_selfbookdirection","country_to_id")', reverse_sql=''),
        migrations.RunSQL('DROP PROCEDURE IF EXISTS fix_existing_foreign_key_constraints_to_www_country;', reverse_sql=''),
    ]
