# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations


class Migration(migrations.Migration):

    dependencies = [
        ('importinfo', '0001_initial'),
        ('order', '0063_partner_variants_ttl'),
        ('avia_data', '0078_add_missing_foreign_key_constraints'),
        ('www', '0039_country_add_field_code3'),
    ]

    create_add_missing_foreign_key_constraints_to_www_region_procedure = """
        CREATE PROCEDURE add_missing_foreign_key_constraints_to_www_region()
        BEGIN
            DECLARE referrer_table char(64) DEFAULT NULL;
            DECLARE referrer_table_fk char(64) DEFAULT NULL;
            DECLARE done TINYINT DEFAULT FALSE;
            DECLARE is_nullable TINYINT DEFAULT FALSE;
            DECLARE referrer_table_fetcher
                CURSOR FOR
                    SELECT table_name, column_name, is_nullable
                    FROM information_schema.columns
                    WHERE
                        column_name = "region_id"
                        AND table_schema = DATABASE()
                        AND table_name not in
                        (
                            SELECT table_name
                            FROM information_schema.KEY_COLUMN_USAGE
                            WHERE
                                REFERENCED_TABLE_NAME = "www_region"
                                AND REFERENCED_COLUMN_NAME = "id"
                                AND CONSTRAINT_SCHEMA = DATABASE()
                        );
            DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = TRUE;
            OPEN referrer_table_fetcher;
            offset_loop:
            LOOP
                FETCH NEXT FROM referrer_table_fetcher INTO referrer_table, referrer_table_fk, is_nullable;
                SELECT concat(referrer_table, ' ', referrer_table_fk);
                IF done THEN
                    LEAVE offset_loop;
                ELSE
                    IF is_nullable THEN
                        SET @query = CONCAT(' UPDATE ', referrer_table, ' SET ', referrer_table_fk,
                                            '=NULL WHERE ', referrer_table_fk, ' NOT IN (SELECT id from www_region)');
                        PREPARE statement FROM @query;
                        EXECUTE statement;
                        DEALLOCATE PREPARE statement;
                    ELSE
                        SET @query = CONCAT(' DELETE FROM ', referrer_table, ' WHERE ', referrer_table_fk,
                                            ' NOT IN (SELECT id from www_region)');
                        PREPARE statement FROM @query;
                        EXECUTE statement;
                        DEALLOCATE PREPARE statement;
                    END IF;
                    SET @query = CONCAT(' ALTER TABLE ', referrer_table, ' ADD CONSTRAINT ',
                                        ' FOREIGN KEY (', referrer_table_fk, ') ', ' REFERENCES www_region (id)
                                        ON UPDATE CASCADE ON DELETE CASCADE;');
                    PREPARE statement FROM @query;
                    EXECUTE statement;
                    DEALLOCATE PREPARE statement;
                END IF;
            END LOOP;
        END;
    """

    operations = [
        migrations.RunSQL('DROP PROCEDURE IF EXISTS add_missing_foreign_key_constraints_to_www_region', reverse_sql=''),
        migrations.RunSQL(create_add_missing_foreign_key_constraints_to_www_region_procedure, reverse_sql=''),
        migrations.RunSQL('CALL add_missing_foreign_key_constraints_to_www_region()', reverse_sql=''),
        migrations.RunSQL('DROP PROCEDURE IF EXISTS add_missing_foreign_key_constraints_to_www_region', reverse_sql=''),
    ]
