# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations


class Migration(migrations.Migration):

    dependencies = [
        ('www', '0040_fix_region_fk'),
    ]

    create_www_region_change_scotland_id_and_increase_auto_increment_procedure = """
        CREATE PROCEDURE www_region_change_scotland_id_and_increase_auto_increment()
        BEGIN
            SET @new_id := 0;
            SET @max_id_query = "SELECT GREATEST(MAX(id) + 1, 200000) INTO @new_id from www_region;";
            PREPARE max_id_statement FROM @max_id_query;
            EXECUTE max_id_statement;
            DEALLOCATE PREPARE max_id_statement;

            SET @update_query = CONCAT("UPDATE www_region SET id = ", @new_id, " WHERE id = 23696 AND _geo_id=104521 AND title='Шотландия';");
            PREPARE update_statement FROM @update_query;
            EXECUTE update_statement;
            DEALLOCATE PREPARE update_statement;

            SET @auto_id := @new_id + 1;
            START TRANSACTION;
            SET @update_id_query = CONCAT("INSERT INTO www_region(id, hidden, country_id, title, disputed_territory, new_L_title_id) ",
                                          "VALUES(", CAST(@auto_id AS CHAR), ", 1, 225, 'temp region', 0, 1);");
            PREPARE update_id_statement FROM @update_id_query;
            EXECUTE update_id_statement;
            DEALLOCATE PREPARE update_id_statement;
            ROLLBACK;
        END;
    """

    operations = [
        migrations.RunSQL('DROP PROCEDURE IF EXISTS www_region_change_scotland_id_and_increase_auto_increment', reverse_sql=''),
        migrations.RunSQL(create_www_region_change_scotland_id_and_increase_auto_increment_procedure, reverse_sql=''),
        migrations.RunSQL('CALL www_region_change_scotland_id_and_increase_auto_increment()', reverse_sql=''),
        migrations.RunSQL('DROP PROCEDURE IF EXISTS www_region_change_scotland_id_and_increase_auto_increment', reverse_sql=''),
    ]
