# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations


class Migration(migrations.Migration):

    dependencies = [
        ('www', '0042_fix_currency_currency_fk'),
    ]

    create_auto_add_missing_foreign_key_constraints_to_www_settlement_procedure = """
        CREATE PROCEDURE auto_add_missing_foreign_key_constraints_to_www_settlement()
        BEGIN
            DECLARE referrer_table char(64) DEFAULT NULL;
            DECLARE referrer_table_fk char(64) DEFAULT NULL;
            DECLARE done TINYINT DEFAULT FALSE;
            DECLARE is_nullable TINYINT DEFAULT FALSE;
            DECLARE referrer_table_fetcher
                CURSOR FOR
                SELECT table_name, column_name, is_nullable
                FROM information_schema.columns
                WHERE
                    column_name regexp '^(.+_)?settlement(_from|_to)?_idx?$'
                    AND table_schema = DATABASE()
                    AND table_name not in (
                        SELECT table_name
                        FROM information_schema.KEY_COLUMN_USAGE
                        WHERE
                            REFERENCED_TABLE_NAME = "www_settlement"
                            AND REFERENCED_COLUMN_NAME = "id"
                            AND CONSTRAINT_SCHEMA = DATABASE()
                    );
            DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = TRUE;
            OPEN referrer_table_fetcher;
            offset_loop:
            LOOP
                FETCH NEXT FROM referrer_table_fetcher INTO referrer_table, referrer_table_fk, is_nullable;
                SELECT concat(referrer_table, ' ', referrer_table_fk);
                IF done THEN
                    LEAVE offset_loop;
                ELSE
                    IF is_nullable THEN
                        SET @query = CONCAT(' UPDATE ', referrer_table, ' SET ', referrer_table_fk,
                                            '=NULL WHERE ', referrer_table_fk, ' NOT IN (SELECT id from www_settlement)');
                        PREPARE statement FROM @query;
                        EXECUTE statement;
                        DEALLOCATE PREPARE statement;
                    ELSE
                        SET @query = CONCAT(' DELETE FROM ', referrer_table, ' WHERE ', referrer_table_fk,
                                            ' NOT IN (SELECT id from www_settlement)');
                        PREPARE statement FROM @query;
                        EXECUTE statement;
                        DEALLOCATE PREPARE statement;
                    END IF;
                    SET @query = CONCAT(' ALTER TABLE ', referrer_table, ' ADD CONSTRAINT ',
                                        ' FOREIGN KEY (', referrer_table_fk, ') ', ' REFERENCES www_settlement  (id)
                                        ON UPDATE CASCADE ON DELETE CASCADE;');
                    PREPARE statement FROM @query;
                    EXECUTE statement;
                    DEALLOCATE PREPARE statement;
                END IF;
            END LOOP;
        END;
    """

    create_fix_existing_foreign_key_constraints_to_www_settlement_procedure = """
        CREATE PROCEDURE fix_existing_foreign_key_constraints_to_www_settlement(referrer_table_name CHAR(64), referer_column_name CHAR(64))
        BEGIN

            DECLARE referrer_table char(64) DEFAULT NULL;
            DECLARE referrer_table_fk char(64) DEFAULT NULL;
            DECLARE referrer_table_constraint char(64) DEFAULT NULL;

            DECLARE done TINYINT DEFAULT FALSE;

            DECLARE referrer_table_fetcher
                CURSOR FOR
                SELECT TABLE_NAME, COLUMN_NAME, CONSTRAINT_NAME
                FROM information_schema.KEY_COLUMN_USAGE
                WHERE REFERENCED_TABLE_NAME = "www_settlement"
                  AND REFERENCED_COLUMN_NAME = "id"
                  AND TABLE_NAME = referrer_table_name
                  AND COLUMN_NAME = referer_column_name
                  AND CONSTRAINT_SCHEMA = DATABASE();

            # catch exception when cursour runs out of rows
            DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = TRUE;

            OPEN referrer_table_fetcher;

            offset_loop:
            LOOP

                FETCH NEXT FROM referrer_table_fetcher INTO referrer_table, referrer_table_fk, referrer_table_constraint;
                SELECT concat(referrer_table, ' ', referrer_table_fk, ' ', referrer_table_constraint);
                IF done THEN
                    LEAVE offset_loop;
                ELSE
                    # prepared statements are used as a way to pass things like table name to query.
                    SET @query = CONCAT('ALTER TABLE ', referrer_table, ' DROP FOREIGN KEY ', referrer_table_constraint, ';');
                    PREPARE statement FROM @query;
                    EXECUTE statement;
                    DEALLOCATE PREPARE statement;

                    SET @query = CONCAT(' ALTER TABLE ', referrer_table, ' ADD CONSTRAINT ', referrer_table_constraint,
                                        ' FOREIGN KEY (', referrer_table_fk, ') ', ' REFERENCES www_settlement(id)',
                                        ' ON UPDATE CASCADE ON DELETE CASCADE;');
                    PREPARE statement FROM @query;
                    EXECUTE statement;
                    DEALLOCATE PREPARE statement;

                END IF;

            END LOOP;

        END;
    """

    create_manual_add_missing_foreign_key_constraints_to_www_settlement_procedure = """
        CREATE PROCEDURE manual_add_missing_foreign_key_constraints_to_www_settlement(
            referrer_table_name CHAR(64),
            referer_column_name CHAR(64)
        )
        BEGIN
            DECLARE referrer_table char(64) DEFAULT NULL;
            DECLARE referrer_table_fk char(64) DEFAULT NULL;
            DECLARE done TINYINT DEFAULT FALSE;
            DECLARE is_nullable TINYINT DEFAULT FALSE;
            DECLARE referrer_table_fetcher
                CURSOR FOR
                SELECT table_name, column_name, is_nullable
                FROM information_schema.columns
                WHERE
                    column_name = referer_column_name
                    AND table_name = referrer_table_name
                    AND table_schema = DATABASE()
                    AND column_name not in (
                        SELECT column_name
                        FROM information_schema.KEY_COLUMN_USAGE
                        WHERE
                            column_name = referer_column_name
                            AND table_name = referrer_table_name
                            AND REFERENCED_TABLE_NAME = "www_settlement"
                            AND REFERENCED_COLUMN_NAME = "id"
                            AND CONSTRAINT_SCHEMA = DATABASE()
                    );
            DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = TRUE;
            OPEN referrer_table_fetcher;
            offset_loop:
            LOOP
                FETCH NEXT FROM referrer_table_fetcher INTO referrer_table, referrer_table_fk, is_nullable;
                SELECT concat(referrer_table, ' ', referrer_table_fk);
                IF done THEN
                    LEAVE offset_loop;
                ELSE
                    IF is_nullable THEN
                        SET @query = CONCAT(' UPDATE ', referrer_table, ' SET ', referrer_table_fk,
                                            '=NULL WHERE ', referrer_table_fk, ' NOT IN (SELECT id from www_settlement)');
                        PREPARE statement FROM @query;
                        EXECUTE statement;
                        DEALLOCATE PREPARE statement;
                    ELSE
                        SET @query = CONCAT(' DELETE FROM ', referrer_table, ' WHERE ', referrer_table_fk,
                                            ' NOT IN (SELECT id from www_settlement)');
                        PREPARE statement FROM @query;
                        EXECUTE statement;
                        DEALLOCATE PREPARE statement;
                    END IF;
                    SET @query = CONCAT(' ALTER TABLE ', referrer_table, ' ADD CONSTRAINT ',
                                        ' FOREIGN KEY (', referrer_table_fk, ') ', ' REFERENCES www_settlement  (id)
                                        ON UPDATE CASCADE ON DELETE CASCADE;');
                    PREPARE statement FROM @query;
                    EXECUTE statement;
                    DEALLOCATE PREPARE statement;
                END IF;
            END LOOP;
        END;
    """

    operations = [
        # 1. fix missing FK (auto)
        migrations.RunSQL('DROP PROCEDURE IF EXISTS auto_add_missing_foreign_key_constraints_to_www_settlement', reverse_sql=''),
        migrations.RunSQL(create_auto_add_missing_foreign_key_constraints_to_www_settlement_procedure, reverse_sql=''),
        migrations.RunSQL('CALL auto_add_missing_foreign_key_constraints_to_www_settlement()', reverse_sql=''),
        migrations.RunSQL('DROP PROCEDURE IF EXISTS auto_add_missing_foreign_key_constraints_to_www_settlement', reverse_sql=''),

        # 2. fix existing FK (list them all here)
        migrations.RunSQL('DROP PROCEDURE IF EXISTS fix_existing_foreign_key_constraints_to_www_settlement;', reverse_sql=''),
        migrations.RunSQL(create_fix_existing_foreign_key_constraints_to_www_settlement_procedure, reverse_sql=''),
        migrations.RunSQL('CALL fix_existing_foreign_key_constraints_to_www_settlement("avia_air_traffic_recovery_stat", "arrival_settlement_id")', reverse_sql=''),
        migrations.RunSQL('CALL fix_existing_foreign_key_constraints_to_www_settlement("avia_air_traffic_recovery_stat", "departure_settlement_id")', reverse_sql=''),
        migrations.RunSQL('CALL fix_existing_foreign_key_constraints_to_www_settlement("avia_relevant_city_airline", "settlement_to_id")', reverse_sql=''),
        migrations.RunSQL('CALL fix_existing_foreign_key_constraints_to_www_settlement("avia_selfbookdirection", "settlement_from_id")', reverse_sql=''),
        migrations.RunSQL('CALL fix_existing_foreign_key_constraints_to_www_settlement("avia_selfbookdirection", "settlement_to_id")', reverse_sql=''),
        migrations.RunSQL('CALL fix_existing_foreign_key_constraints_to_www_settlement("order_pricelist", "settlement_from_id")', reverse_sql=''),
        migrations.RunSQL('CALL fix_existing_foreign_key_constraints_to_www_settlement("order_pricelist", "settlement_to_id")', reverse_sql=''),
        migrations.RunSQL('CALL fix_existing_foreign_key_constraints_to_www_settlement("route_search_nearestsuburbandirection", "settlement_id")', reverse_sql=''),
        migrations.RunSQL('CALL fix_existing_foreign_key_constraints_to_www_settlement("www_holiday_direction", "settlement_from_id")', reverse_sql=''),
        migrations.RunSQL('CALL fix_existing_foreign_key_constraints_to_www_settlement("www_holiday_direction", "settlement_to_id")', reverse_sql=''),
        migrations.RunSQL('CALL fix_existing_foreign_key_constraints_to_www_settlement("www_threadtariff", "settlement_from_id")', reverse_sql=''),
        migrations.RunSQL('CALL fix_existing_foreign_key_constraints_to_www_settlement("www_threadtariff", "settlement_to_id")', reverse_sql=''),
        migrations.RunSQL('DROP PROCEDURE IF EXISTS fix_existing_foreign_key_constraints_to_www_settlement;', reverse_sql=''),

        # 3. Fix missing FK with strange names (not catch by auto)
        migrations.RunSQL('DROP PROCEDURE IF EXISTS manual_add_missing_foreign_key_constraints_to_www_settlement', reverse_sql=''),
        migrations.RunSQL(create_manual_add_missing_foreign_key_constraints_to_www_settlement_procedure, reverse_sql=''),
        migrations.RunSQL('CALL manual_add_missing_foreign_key_constraints_to_www_settlement("www_settlementnearest", "nearest_id")', reverse_sql=''),
        migrations.RunSQL('CALL manual_add_missing_foreign_key_constraints_to_www_settlement("www_replaceexception", "city_from_id")', reverse_sql=''),
        migrations.RunSQL('CALL manual_add_missing_foreign_key_constraints_to_www_settlement("www_replaceexception", "city_to_id")', reverse_sql=''),
        migrations.RunSQL('CALL manual_add_missing_foreign_key_constraints_to_www_settlement("www_gortranscitylink", "city_id")', reverse_sql=''),
        migrations.RunSQL('CALL manual_add_missing_foreign_key_constraints_to_www_settlement("avia_customcachetimedirection", "point_from_id")', reverse_sql=''),
        migrations.RunSQL('CALL manual_add_missing_foreign_key_constraints_to_www_settlement("avia_customcachetimedirection", "point_to_id")', reverse_sql=''),
        migrations.RunSQL('CALL manual_add_missing_foreign_key_constraints_to_www_settlement("avia_aviawizarddirection", "settlement_1_id")', reverse_sql=''),
        migrations.RunSQL('CALL manual_add_missing_foreign_key_constraints_to_www_settlement("avia_aviawizarddirection", "settlement_2_id")', reverse_sql=''),
        migrations.RunSQL('CALL manual_add_missing_foreign_key_constraints_to_www_settlement("avia_similardirection", "similar_from_id")', reverse_sql=''),
        migrations.RunSQL('CALL manual_add_missing_foreign_key_constraints_to_www_settlement("avia_similardirection", "similar_to_id")', reverse_sql=''),
        migrations.RunSQL('CALL manual_add_missing_foreign_key_constraints_to_www_settlement("avia_seodirection", "point_from_id")', reverse_sql=''),
        migrations.RunSQL('CALL manual_add_missing_foreign_key_constraints_to_www_settlement("avia_seodirection", "point_to_id")', reverse_sql=''),
        migrations.RunSQL('DROP PROCEDURE IF EXISTS manual_add_missing_foreign_key_constraints_to_www_settlement', reverse_sql=''),
    ]
