# -*- coding: utf-8 -*-
from __future__ import absolute_import

from django import template

register = template.Library()


@register.inclusion_tag('block_route_stations.html', takes_context=True)
def route_stations(context, route_data, direction):
    """Две станции маршрута"""
    context.update(route_data)
    context['direction'] = direction
    context['direction_title'] = {'forward': u'Туда', 'backward': u'Обратно'}[direction]
    context['hide_back_link'] = direction == 'backward' or 'route_backward' not in context['order_form'].cleaned_data
    return context
