# -*- coding: utf-8 -*-
from __future__ import absolute_import

import re
from urllib import urlencode

from django import template
# from django_russian.templatetags.russian import human_date
from django.core.urlresolvers import reverse

from travel.avia.admin.lib.translation import ugettext
from travel.avia.admin.lib.jinja import Library

register = template.Library()
jinja = Library()


@register.filter
def bold_duration(duration_str):
    """ Делает слово 'дней' жирным
        Вход: длительность в человеческом формате (1 день 2 часа)
        Выход: <span class='days_duration'>1 день</span> 2 часа
    """
    def replace(matchobj):
        return "<span class='days_duration'>" + matchobj.group(0) + "</span>"
    return re.sub(ur'(\d+ (д[^\s]+))', replace, duration_str)


# commented out because of django_russian
# def wrong_date_disclaimer(departure, thread):
#     try:
#         thread_departure = thread.departure
#     except AttributeError:
#         thread_departure = thread['departure']
#
#     return departure and departure.date() != thread_departure.date() \
#             and u'<div class="b-att-info">Информация по запрошенной вами дате (%s) недоступна. Информация по рейсу показывается на ближайшую доступную дату от текущего момента.</div>' % human_date(departure.date()) or ""  # noqa


@jinja.callable
def aeroexpress_link(airport):
    """ Ссылка на поиск аэроэкспрессов от аэропорта до города """
    url = get_aeroexpress_link(airport)
    if url:
        return u'<a class="b-link" href="%s">%s</a>' % (url, ugettext(u'Расписание аэроэкспрессов'))
    else:
        return ""


@jinja.callable
def get_aeroexpress_link(airport, reversed=False):
    if airport.has_aeroexpress and airport.t_type_id == 2 and airport.settlement:
        url = reverse('search', args=['suburban']) + '?'
        if reversed:
            url += urlencode({'fromName': airport.L_title().encode('utf8'),
                              'fromId': airport.point_key,
                              'toName': airport.settlement.L_title().encode('utf8'),
                              'toId': airport.settlement.point_key,
                              'aeroex': 'y',
                              }).replace('&', '&amp;')
        else:
            url += urlencode({'toName': airport.L_title().encode('utf8'),
                              'toId': airport.point_key,
                              'fromName': airport.settlement.L_title().encode('utf8'),
                              'fromId': airport.settlement.point_key,
                              'aeroex': 'y',
                              }).replace('&', '&amp;')

        return url

    else:
        return None


@jinja.callable
def aeroexpress_mobile_link(airport):
    """ Ссылка на поиск аэроэкспрессов от аэропорта до города """
    if airport.has_aeroexpress and airport.t_type_id == 2 and airport.settlement:
        url = reverse('aeroex', urlconf='mobile.urls') + '?' + urlencode({'station': airport.pk})
        return u'<li><a href="%s">Расписание аэроэкспрессов</a></li>' % url
    else:
        return ''


@jinja.filter
def fit_link(url, request):
    u""" Если в реквесте написано, что пришел робот яндекса, оторвать параметры ссылки """
    if request.yandex_spider and '?' in url:
        return url[:url.index('?')]
    else:
        return url
