# encoding: utf-8
from __future__ import absolute_import

from pytils.numeral import choose_plural

from travel.avia.admin.lib.jinja import Library

jinja = Library()


@jinja.filter
def round_duration(delta, show_minutes=False):
    """ Округление длительности
        Вход: длительность в timedelta
        Выход: <24 часов - целое число часов (если не show_minutes=True)
        >24 часов - 1 или 1,5 или 2 суток

        При этом в случае с сутками писать слово «около 2 суток»

        Общая схема округления:

        N суток М часов
        0 <= M < 8 -> N суток
        8 <= M < 16 -> N,5 суток
        16 <= M < 24 -> N+1 суток. """

    hours = (delta.seconds + 3600 - 1) / 3600  # округление в большую сторону
    days = delta.days

    if hours == 24:
        days = days + 1
        hours = 0

    if days > 0:
        if 8 <= hours < 16:
            days = "%d,5" % days
        elif hours >= 16:
            days += 1

        return u"около %s суток" % days
    else:
        minutes = (delta.seconds / 60) % 60
        if show_minutes and minutes:
            hours = hours = delta.seconds / 3600
            return "%d %s %d %s" % (hours, choose_plural(hours, (u'час', u'часа', u'часов')),
                                    minutes, choose_plural(minutes, (u'минута', u'минуты', u'минут')))
        else:
            return "%d %s" % (hours, choose_plural(hours, (u'час', u'часа', u'часов')))


@jinja.filter
def minutes(delta):
    return delta.seconds / 60 + delta.days * 24 * 60
