from __future__ import absolute_import

from django.utils.html import escape

from travel.avia.admin.lib.jinja import Library

jinja = Library()


class Tag(object):
    def __init__(self, tag, **attrs):
        self._tag = tag
        self._attrs = attrs

    def addClass(self, cls):
        self._attrs['class'] = " ".join(self._attrs.get('class', '').split() + [cls])

    def attr(self, key, value):
        self._attrs[key] = value

    def html(self, html=''):
        attrs = ''

        if self._attrs:
            attrs = ' ' + ' '.join('%s="%s"' % (key, escape(value)) for key, value in self._attrs.items())

        return '<%s%s>%s</%s>' % (self._tag, attrs, html, self._tag)


class HTML(object):
    jinja_name = 'html'

    def __getattr__(self, tag):
        def foo(**attrs):
            def bar():
                return Tag(tag, **attrs)

            return bar

        return foo

html = HTML()

jinja.global_(html)
