# encoding: utf-8
from __future__ import absolute_import

from travel.avia.admin.www.templatetags.common import url


def tablo_sett_nav_objects(pnode):
    """ Возвращает "строку навигации":
        список словарей: [{'id': .., 'title': .., 'type': ..}] """
    nav_objects = []
    node_class = pnode and pnode.__class__.__name__

    while node_class:
        nav_objects.insert(0, (url('change_' + node_class.lower(), pnode.id), pnode.title))

        if node_class == 'Settlement':
            pnode = pnode.region
        elif node_class == 'Region':
            pnode = pnode.country
        else:
            pnode = None

        node_class = pnode and pnode.__class__.__name__

    nav_objects.insert(0, (url('change'), u"Все страны"))

    return nav_objects
