# coding: utf-8
from __future__ import absolute_import

from travel.avia.library.python.common.utils.text import transliterate


def items_tds(items, row_len=3, vertical=1):
    """ Возвращает список объектов в виде списка списков
        Вход: items - список некоторых объектов,
              row_len - по сколько объектов возвращать в каждом списке
              vertical - выводить вертикально или горизонтально: 1 or 0
        Выход: [[obj, .., obj], [obj, .., obj], .., [obj, .., ..]]
    """
    items_tds = []
    rows_count = len(items) / row_len + int(len(items) % row_len != 0)
    for index in range(rows_count):
        new_tds_row = []
        for td_index in range(row_len):
            try:
                if vertical:
                    new_tds_row.append(items[index + rows_count*td_index])
                else:
                    new_tds_row.append(items[row_len*index + td_index])
            except IndexError:
                new_tds_row.append({})
        items_tds.append(new_tds_row)
    return items_tds


def change_similar(s, dest='rus'):
    """ Заменяет латинские буквы на похожие по написанию русские """
    lat = u'CAEOPHKXTcxyoepak'
    rus = u'САЕОРНКХТсхуоерак'

    from_chars = lat
    to_charts = rus

    if dest != 'rus':
        from_chars, to_charts = rus, lat

    res = ''
    for c in s:
        pos = from_chars.find(c)
        if pos >= 0:
            res += to_charts[pos]
        else:
            res += c

    return res


def rus2translit(text):
    return transliterate(text, 'cyr-lat')


class Storage(dict):
    u"""Вспомогательный класс для хранения данных."""
    def __init__(self, **kwargs):
        self.update(kwargs)

    def __getattr__(self, name):
        try:
            return self[name]
        except KeyError:
            raise AttributeError

    def __setattr__(self, name, value):
        self[name] = value

    def __hash__(self):
        try:
            return hash(self.id)
        except AttributeError:
            raise Exception(u'Для использования в словарях нужно назначить аттрибут id')

    def __eq__(self, other):
        try:
            return self.id == other.id
        except AttributeError:
            raise Exception(u'Для использования в словарях нужно назначить аттрибут id')

    def __unicode__(self):
        try:
            return unicode(self.title)
        except AttributeError:
            return super(Storage, self).__unicode__()

    def __repr__(self):
        repr_ = 'Storage(%s)' % dict.__repr__(self)
        return repr_

    def copy(self):
        copy_ = Storage(**self)
        return copy_
