# coding: utf-8
from __future__ import absolute_import

"""Функции для работы с языком"""

import re


city_preposition_locative_regexp = re.compile(ur'[влрф]ь?[бвгджзйклмнпрстфхцчшщ]', re.U | re.I)


def city_preposition_locative(name):
    '''Выбор предлога для города: "в" или "во"'''

    if city_preposition_locative_regexp.match(name):
        return u'во'
    else:
        return u'в'
