PY2_LIBRARY(avia_admin)

OWNER(g:avia)

PEERDIR(
    travel/avia/library/python/avia_data
    travel/avia/library/python/balance_client
    travel/avia/library/python/common
    travel/avia/library/python/http_geobase
    travel/avia/library/python/iata_correction
    travel/avia/library/python/image_processing
    travel/avia/library/python/proxy_pool
    travel/avia/library/python/route_search
    travel/avia/library/python/sirena_client/django
    travel/avia/library/python/shared_dicts
    travel/avia/library/python/shared_flights_client
    travel/avia/library/python/stationschedule
    travel/avia/library/python/tester

    travel/library/python/dicts
    travel/library/python/cloud_logger
    travel/library/python/tvm_ticket_provider
    travel/library/python/avia_mdb_replica_info

    library/python/blackbox
    library/python/django
    library/python/django-idm-api
    library/python/gunicorn
    library/python/python-django-tanker
    library/python/python-django-yauth
    library/python/statface_client
    library/python/vault_client
    yql/library/python
    yt/python/client
    yt/yt/python/yt_yson_bindings

    contrib/python/ipython
    contrib/python/MySQL-python
    contrib/python/raven
    contrib/python/Babel
    contrib/python/boto3
    contrib/python/ciso8601
    contrib/python/dateutil
    contrib/python/django/django-1.11
    contrib/python/django-filebrowser-no-grappelli
    contrib/python/gunicorn
    contrib/python/Jinja2
    contrib/python/lxml
    contrib/python/openpyxl
    contrib/python/Pillow
    contrib/python/python-magic
    contrib/python/pytils
    contrib/python/reportlab
    contrib/python/requests
    contrib/python/retrying
    contrib/python/setproctitle
    contrib/python/six
    contrib/python/sqlparse
    contrib/python/Wand
    contrib/python/timeout-decorator
    contrib/python/typing
    contrib/python/ujson
    contrib/python/Unidecode
    contrib/python/django-simple-history
    contrib/python/django-bulk-update
    contrib/python/cachetools

    # from deb-requirements
    contrib/python/chardet
    contrib/python/ipaddr
    contrib/python/python-memcached
    contrib/python/pyOpenSSL
    contrib/python/Shapely
    contrib/python/xlrd
)

PY_SRCS(
    admin/__init__.py
    admin/admin_tasks.py
    admin/apps.py
    admin/maintenance_settings/__init__.py
    admin/maintenance_settings/admin.py
    admin/maintenance_settings/models.py
    admin/management/__init__.py
    admin/management/commands/__init__.py
    admin/management/commands/run_task.py
    admin/management/commands/runtask.py
    admin/middleware/__init__.py
    admin/models.py
    admin/reports/__init__.py
    admin/reports/urls.py
    admin/reports/views.py
    admin/templatetags/__init__.py
    admin/templatetags/admin_foreign_objects.py
    admin/templatetags/admin_static.py
    admin/templatetags/get_klass.py
    admin/templatetags/rasp_sync.py
    admin/urls.py
    admin/utils.py
    admin/views/__init__.py
    admin/views/geoadmin.py
    admin/views/geomap.py
    admin/views/partnerka.py
    admin/www_stations/__init__.py
    admin/www_stations/api.py
    admin/www_stations/convertors.py
    admin/www_stations/urls.py
    api/__init__.py
    api/admin.py
    api/migrations/0001_initial.py
    api/migrations/__init__.py
    api/models.py
    app.py
    avia/__init__.py
    avia/management/__init__.py
    avia/management/commands/__init__.py
    avia/management/commands/_loggers.py
    avia/management/commands/_yt_build_good_prices.py
    avia/management/commands/build_good_prices.py
    avia/management/commands/compare_translations_with_iatacodes_api.py
    avia/management/commands/delete_from_saas.py
    avia/management/commands/empty_suggest_report.py
    avia/management/commands/find_alive_airports.py
    avia/management/commands/get_company_colors.py
    avia/management/commands/merge_logs_with_scheme.py
    avia/management/commands/rsync_import_rasp_media.py
    avia/management/commands/update_company_colors.py
    avia/models.py
    avia/settings.py
    avia/sync_rasp/__init__.py
    avia/sync_rasp/helpers.py
    avia/sync_rasp/import_rasp_info_schema.py
    avia_data_admin/__init__.py
    avia_data_admin/admin.py
    avia_data_admin/models.py
    avia_scripts/after_covid_resurrection.py
    avia_scripts/airports_recalc.py
    avia_scripts/build_avia_directions.py
    avia_scripts/build_best_offers.py
    avia_scripts/build_dynamic_cache.py
    avia_scripts/build_flexible_cache.py
    avia_scripts/build_flight_rating.py
    avia_scripts/build_flight_rating_v2.py
    avia_scripts/build_min_price.py
    avia_scripts/build_national_avia_directions.py
    avia_scripts/build_ohm_report.py
    avia_scripts/build_similar_airlines.py
    avia_scripts/build_similar_directions.py
    avia_scripts/build_top_directions.py
    avia_scripts/build_top_flights.py
    avia_scripts/build_wizard_min_price.py
    avia_scripts/build_yt_reference.py
    avia_scripts/calculate_airline_city_top.py
    avia_scripts/calculate_airline_rating.py
    avia_scripts/calculate_airlines_popular_scores.py
    avia_scripts/check_prices.py
    avia_scripts/check_review_dirty_lang.py
    avia_scripts/check_yt_tables.py
    avia_scripts/clean_script_results.py
    avia_scripts/compare_flight_wizards.py
    avia_scripts/compress_tablo.py
    avia_scripts/conversion/booking_yql.py
    avia_scripts/conversion/intervals.py
    avia_scripts/conversion/update_conversions.py
    avia_scripts/copy_yt_tables.py
    avia_scripts/create_company_tanker_fields.py
    avia_scripts/create_holiday_tanker_fields.py
    avia_scripts/create_partner_flags.py
    avia_scripts/export_airports_to_stat_admin.py
    avia_scripts/export_settlements_to_stat_admin.py
    avia_scripts/fail.py
    avia_scripts/fetch_amadeus.py
    avia_scripts/fetch_charterok.py
    avia_scripts/fetch_chartex.py
    avia_scripts/fetch_clickavia.py
    avia_scripts/fetch_dohop_vendors.py
    avia_scripts/fetch_moireis.py
    avia_scripts/fetch_pobeda.py
    avia_scripts/fetch_pobeda_v3.py
    avia_scripts/fetch_query_rules.py
    avia_scripts/fetch_redwings.py
    avia_scripts/fetch_regionalization/__init__.py
    avia_scripts/fetch_regionalization/azimuth.py
    avia_scripts/fetch_regionalization/smartavia.py
    avia_scripts/fetch_regionalization/tutu.py
    avia_scripts/fetch_taxi_cities.py
    avia_scripts/fetch_tours.py
    avia_scripts/fetch_tours_matrix.py
    avia_scripts/fill_com_data.py
    avia_scripts/fill_livestore_data.py
    avia_scripts/fill_tr_data.py
    avia_scripts/fix_redir_log_clid.py
    avia_scripts/flight_review_add_from_rasp.py
    avia_scripts/gen_rss_feed.py
    avia_scripts/heater_stat.py
    avia_scripts/import_airlines_inform.py
    avia_scripts/import_aviakompaniya.py
    avia_scripts/import_balance.py
    avia_scripts/import_balance_partner_stat.py
    avia_scripts/import_showlog.py
    avia_scripts/import_tickets_ua.py
    avia_scripts/import_topairlines.py
    avia_scripts/make_adwords_xml.py
    avia_scripts/make_new_images.py
    avia_scripts/merge_balance_logs.py
    avia_scripts/merge_start_and_success_logs.py
    avia_scripts/merge_yt_logs.py
    avia_scripts/notify_about_partner_statistic.py
    avia_scripts/rebuilld_partner_popularity.py
    avia_scripts/refresh_partners_balance.py
    avia_scripts/remerge_yt_logs.py
    avia_scripts/remove_old_logs.py
    avia_scripts/repair_table.py
    avia_scripts/send_agg_redirects_to_stat.py
    avia_scripts/send_companies_without_logo.py
    avia_scripts/send_redirects_to_razladki.py
    avia_scripts/send_redirects_to_stat.py
    avia_scripts/send_report_about_scripts.py
    avia_scripts/send_revise_log_to_stat.py
    avia_scripts/set_zero_redirect_price.py
    avia_scripts/set_zero_redirect_price_for_partner.py
    avia_scripts/single/RASPTICKETS_20260_fix_user_ip_in_redir_log.py
    avia_scripts/single/TRAVELAPP-1240_refresh_svg2png_logo2.py
    avia_scripts/split_balance_log.py
    avia_scripts/sync_aurora_aviatickets.py
    avia_scripts/sync_aurora_timetable.py
    avia_scripts/sync_country_covid_info.py
    avia_scripts/sync_with_rasp/helpers.py
    avia_scripts/sync_with_rasp/single_run/sync_company_id_with_rasp.py
    avia_scripts/sync_with_rasp/single_run/sync_www_station_id_with_rasp.py
    avia_scripts/sync_with_rasp/sync_all.py
    avia_scripts/sync_with_rasp/sync_currency_currency.py
    avia_scripts/sync_with_rasp/sync_www_aviaalliance.py
    avia_scripts/sync_with_rasp/sync_www_company_with_rasp.py
    avia_scripts/sync_with_rasp/sync_www_country.py
    avia_scripts/sync_with_rasp/sync_www_pointsynonym.py
    avia_scripts/sync_with_rasp/sync_www_region.py
    avia_scripts/sync_with_rasp/sync_www_settlement.py
    avia_scripts/sync_with_rasp/sync_www_station_with_rasp.py
    avia_scripts/synchronize_route_schedule.py
    avia_scripts/ttl_experiments/__init__.py
    avia_scripts/ttl_experiments/ttl_statistics.py
    avia_scripts/update_avg_check_coeff.py
    avia_scripts/update_conversions.py
    avia_scripts/update_cpc_price.py
    avia_scripts/update_heater_conf.py
    avia_scripts/update_images_in_mds.py
    avia_scripts/update_importcharts.py
    avia_scripts/update_servicemetrics.py
    avia_scripts/update_tradedoubler.py
    avia_scripts/upload_partners_from_prod_to_testing.py
    avia_scripts/utils/__init__.py
    avia_scripts/utils/argument_parser.py
    avia_scripts/utils/environment.py
    avia_scripts/utils/profiling.py
    avia_scripts/utils/yandex_turbo.py
    configure_logs.py
    contrib/__init__.py
    contrib/babeldjango/__init__.py
    contrib/babeldjango/extract.py
    contrib/babeldjango/middleware.py
    contrib/babeldjango/templatetags/__init__.py
    contrib/babeldjango/templatetags/babel.py
    contrib/dbf.py
    contrib/dict2xml/__init__.py
    contrib/dict2xml/logic.py
    contrib/memcache.py
    currency/__init__.py
    currency/admin.py
    currency/migrations/0001_initial.py
    currency/migrations/__init__.py
    currency/models.py
    currency/templatefilters.py
    currency/views.py
    environment_settings.py
    feature_flag_app/admin.py
    feature_flag_app/migrations/0001_initial.py
    feature_flag_app/migrations/0002_auto_20180125_1244.py
    feature_flag_app/migrations/0003_featureflag_startrack_id.py
    feature_flag_app/migrations/0004_auto_20180201_1243.py
    feature_flag_app/migrations/0005_extra_state_AB_for_flag.py
    feature_flag_app/models.py
    feature_flag_app/urls.py
    feature_flag_app/views.py
    geotargeting/__init__.py
    geotargeting/lookup.py
    geotargeting/models.py
    gunicorn_conf.py
    i18n/__init__.py
    i18n/admin.py
    i18n/jinja.py
    i18n/migrations/0001_initial.py
    i18n/migrations/__init__.py
    i18n/models.py
    importinfo/__init__.py
    importinfo/admin.py
    importinfo/migrations/0001_initial.py
    importinfo/migrations/__init__.py
    init_project.py
    leaflets/__init__.py
    leaflets/admin.py
    leaflets/views.py
    lib/__init__.py
    lib/admin_options.py
    lib/adminutils.py
    lib/airline_popular_score_updater.py
    lib/arcadia/convert_command.py
    lib/auth.py
    lib/balance.py
    lib/connect_to_replica.py
    lib/country_covid_info_updater.py
    lib/coverage.py
    lib/django_ext/__init__.py
    lib/django_ext/middleware.py
    lib/download_file.py
    lib/encoding.py
    lib/exceptions.py
    lib/exporters_for_stat_admin.py
    lib/feature_flags.py
    lib/feeds.py
    lib/fileutils.py
    lib/flight_frequency_collector.py
    lib/forms.py
    lib/grouping.py
    lib/gtfs.py
    lib/http_timeout_handler.py
    lib/hyphenize.py
    lib/import_bounds.py
    lib/iterators.py
    lib/jinja.py
    lib/lock.py
    lib/logs.py
    lib/maintenance/__init__.py
    lib/marker.py
    lib/mask_description.py
    lib/mda.py
    lib/merge_tables.py
    lib/mysqlutils.py
    lib/network.py
    lib/osutils.py
    lib/parallelize.py
    lib/partner_authorization.py
    lib/partner_errors_collector.py
    lib/partner_mail_sender.py
    lib/popular_partners_builder.py
    lib/pp.py
    lib/pricing.py
    lib/processes.py
    lib/redirect_provider.py
    lib/s3sync.py
    lib/schedule.py
    lib/scraper.py
    lib/script_helpers/__init__.py
    lib/script_helpers/environment_detector.py
    lib/script_helpers/mail_senders/__init__.py
    lib/script_helpers/mail_senders/fail_script_mail_sender.py
    lib/script_helpers/mail_senders/script_reports_mail_sender.py
    lib/script_helpers/script_reporter.py
    lib/script_helpers/script_result_cleaner.py
    lib/script_helpers/script_run_logger_factory.py
    lib/script_helpers/script_runner.py
    lib/settlement_cache.py
    lib/simple_daemon_client.py
    lib/sql.py
    lib/statface_helpers.py
    lib/suppliers/__init__.py
    lib/suppliers/agent.py
    lib/tablo_compressor.py
    lib/text.py
    lib/tmpfiles.py
    lib/translation.py
    lib/types.py
    lib/un7zip.py
    lib/unpack_with_fallback.py
    lib/unrar.py
    lib/unzip.py
    lib/utils.py
    lib/xls.py
    lib/xmlutils.py
    lib/yav.py
    lib/yql_helpers.py
    lib/yt_helpers.py
    local_settings.py
    managed_settings.py
    marker_callback/__init__.py
    marker_callback/ctrip.py
    marker_callback/urls.py
    migration_settings.py
    order/__init__.py
    order/admin.py
    order/migrations/0001_initial.py
    order/migrations/0002_auto_20160616_1430.py
    order/migrations/0003_partner_status_update_model.py
    order/migrations/0004_dohop_index.py
    order/migrations/0005_unique_dohop_index.py
    order/migrations/0006_partner_kz_fields.py
    order/migrations/0007_dohopvendor_kz_fields.py
    order/migrations/0008_unique_index_on_billing_order_id.py
    order/migrations/0009_custom_image_fields.py
    order/migrations/0010_variant_cache_ttl_for_partner.py
    order/migrations/0011_new_upper_bound_for_variant_cache_time.py
    order/migrations/0012_dohopvendor_national_kz_title.py
    order/migrations/0013_emailtype.py
    order/migrations/0014_fill_email_types.py
    order/migrations/0015_partneremail_emailtype.py
    order/migrations/0016_queryblacklist_allow.py
    order/migrations/0017_auto_20160918_1951.py
    order/migrations/0018_updatehistoryrecord.py
    order/migrations/0019_queryblacklist_national_version.py
    order/migrations/0020_auto_20160920_0917.py
    order/migrations/0021_fill_partneruser.py
    order/migrations/0022_partner_hidden.py
    order/migrations/0023_auto_20161005_1318.py
    order/migrations/0024_partner_regionalization_file.py
    order/migrations/0025_add-partneruser-yandex-assessor-role.py
    order/migrations/0026_change-partneruser-role-length.py
    order/migrations/0027_change_partneruser_role_length.py
    order/migrations/0028_auto_20170129_1253.py
    order/migrations/0029_auto_20170201_2349.py
    order/migrations/0030_fill_production_avatar_urls.py
    order/migrations/0031_dohopvendor_code.py
    order/migrations/0032_fill_dohopvendor_codes.py
    order/migrations/0033_add_dohop_vendor_foreign_key_to_dohop.py
    order/migrations/0034_update_dohop_vendor_foreign_key_to_dohop.py
    order/migrations/0035_auto_20170510_1715.py
    order/migrations/0036_remove_dohopvendor_query_module_name.py
    order/migrations/0037_partner_enabled_with_negative_balance.py
    order/migrations/0038_dohopvendor_site_url.py
    order/migrations/0039_partner_client_id.py
    order/migrations/0040_fill_ballance_client_ids.py
    order/migrations/0041_defaultclickprice_pricelist.py
    order/migrations/0042_fill_default_click_prices.py
    order/migrations/0043_fill_price_list.py
    order/migrations/0044_refill_price_list.py
    order/migrations/0045_add_wizard_to_partner.py
    order/migrations/0046_cpc_prices.py
    order/migrations/0047_redirecttype.py
    order/migrations/0048_auto_20190204_1526.py
    order/migrations/0049_auto_20190219_0830.py
    order/migrations/0050_auto_20190220_0624.py
    order/migrations/0051_partneruser_passportuid.py
    order/migrations/0052_auto_20190412_1315.py
    order/migrations/0053_auto_20190828_0938.py
    order/migrations/0053_base_model_for_partners.py
    order/migrations/0054_merge.py
    order/migrations/0055_pricing_model.py
    order/migrations/0056_regionalization_pobeda_fields.py
    order/migrations/0057_use_in_update_conversios.py
    order/migrations/0058_review_percent_by_nationals.py
    order/migrations/0059_alter_columns_in_dohopvendor_cpcprice_partner.py
    order/migrations/0060_change_default_in_marker_field_of_partner.py
    order/migrations/0061_partner__add_field__can_sale_by_installments.py
    order/migrations/0062_add_is_deleted_to_partner.py
    order/migrations/0063_partner_variants_ttl.py
    order/migrations/0064_alter_time_column_in_update_history_record.py
    order/migrations/0065_add_historical_partner_and_historical_dohop_vendor.py
    order/migrations/0066_auto_add_icon_svg_to_partners.py
    order/migrations/0067_auto_add_price_list_click_coeff.py
    order/migrations/__init__.py
    order/models.py
    order/settings.py
    order/utils.py
    partners/__init__.py
    partners/partner_statuses.py
    partners/urls.py
    precalc/__init__.py
    precalc/parts/__init__.py
    precalc/parts/avia_directions.py
    precalc/parts/search.py
    precalc/parts/search_totals.py
    precalc/parts/stops.py
    precalc/parts/threads.py
    precalc/utils/__init__.py
    precalc/utils/chunked.py
    precalc/utils/db.py
    precalc/utils/estimator.py
    precalc/utils/originalbox.py
    precalc/utils/route_number.py
    promosearch/__init__.py
    promosearch/admin.py
    promosearch/models.py
    scripts/__init__.py
    scripts/autotranslate_stations.py
    scripts/build_namesearchindex.py
    scripts/build_ufs_directions_days_ahead.py
    scripts/cache_currency_rates.py
    scripts/check_agent_settlements.py
    scripts/check_base_integrity.py
    scripts/check_tablo_routes.py
    scripts/clean_empty_threads.py
    scripts/clean_old_dates.py
    scripts/clean_old_tariffs.py
    scripts/cron_run.py
    scripts/db_name.py
    scripts/export/__init__.py
    scripts/export/export_main_threads.py
    scripts/export/export_nearest_suburban.py
    scripts/export/export_stations_list.py
    scripts/export/gen_t_types_by_geoid_for_mobile_morda.py
    scripts/geobase_consistency_reports.py
    scripts/get_cache.py
    scripts/get_settings.py
    scripts/helper/__init__.py
    scripts/helper/make_widget_bullets.py
    scripts/i18n/__init__.py
    scripts/i18n/collect_platform_translations.py
    scripts/i18n/dbtanker.py
    scripts/i18n/fill_translates.py
    scripts/i18n/load_models.py
    scripts/import_middle_stations.py
    scripts/import_pseudo_gortrans.py
    scripts/import_special_offer_travel.py
    scripts/invalidate_cache.py
    scripts/limepaths_check.py
    scripts/mail_reports.py
    scripts/refill_suggests.py
    scripts/regionalize_amargo.py
    scripts/remove_obsolete_af_schedule.py
    scripts/rotate_temporary_data.py
    scripts/rsync.py
    scripts/s3sync.py
    scripts/settings.py
    scripts/settlement_view_types.py
    scripts/single/__init__.py
    scripts/single/copy_media_avia.py
    scripts/single/raspfront_1825_fill_thread_tariff.py
    scripts/station_view_types.py
    scripts/support_methods.py
    scripts/tariffs_stats.py
    scripts/update_geobase.py
    scripts/update_plane_rtstations.py
    scripts/update_queryblacklist.py
    scripts/update_reversed_numbers.py
    scripts/utils/__init__.py
    scripts/utils/action_list.py
    scripts/utils/daily_update.py
    scripts/utils/delete_older_files.py
    scripts/utils/import_file_storage.py
    scripts/utils/to_python_parsers.py
    scripts/utils/uid_regeneration.py
    scripts/www_companies.py
    scripts/www_fill_country_title_of.py
    scripts/www_fill_preposition_in.py
    scripts/www_fix_station_types.py
    scripts/www_inflect_in_from_to.py
    scripts/www_rtstations.py
    scripts/www_settlements.py
    scripts/www_station_rise_majority.py
    scripts/www_stations.py
    scripts/z_station_schedule_test_schedule_length.py
    settings.py
    staticpages/__init__.py
    staticpages/admin.py
    staticpages/migrations/0001_initial.py
    staticpages/migrations/0002_auto_20160917_2216.py
    staticpages/migrations/0003_auto_20170329_1655.py
    staticpages/migrations/__init__.py
    staticpages/models.py
    staticpages/templatetags/__init__.py
    stats/__init__.py
    stats/admin.py
    stats/migrations/0001_initial.py
    stats/migrations/0002_auto_20160917_2216.py
    stats/migrations/__init__.py
    stats/models.py
    stats/urls.py
    stats/views.py
    suburban_change_notices/__init__.py
    suburban_change_notices/admin.py
    suburban_change_notices/management/__init__.py
    suburban_change_notices/management/commands/__init__.py
    suburban_change_notices/management/commands/send_suburban_notifications.py
    suburban_change_notices/models.py
    suburban_change_notices/sending.py
    suburban_change_notices/settings.py
    tariffs/__init__.py
    tariffs/admin.py
    tariffs/migrations/0001_initial.py
    tariffs/migrations/__init__.py
    tariffs/models.py
    tariffs/settings.py
    templates/__init__.py
    templates/bemhtml/__init__.py
    templates/bemhtml/validate.py
    urls.py
    wsgi.py
    www/__init__.py
    www/admin.py
    www/admin_models/__init__.py
    www/admin_models/scripts.py
    www/context.py
    www/db/__init__.py
    www/i18n.py
    www/management/__init__.py
    www/management/commands/__init__.py
    www/management/commands/_loggers.py
    www/management/commands/_yt_send_partners_stat.py
    www/management/commands/maketestdb.py
    www/management/commands/send_partners_stat.py
    www/management/commands/update.py
    www/management/commands/update_date_validator_js.py
    www/management/commands/update_i_time_translations.py
    www/management/commands/update_local_db.py
    www/management/commands/upload_media_to_avatar.py
    www/management/templatetags/__init__.py
    www/management/templatetags/tools.py
    www/middleware.py
    www/migrations/0001_initial.py
    www/migrations/0002_default_for_t_type.py
    www/migrations/0002_translation_models.py
    www/migrations/0003_routeschedule.py
    www/migrations/0003_translation_filling.py
    www/migrations/0004_setting_new_fields_to_not_null.py
    www/migrations/0004_synonym_uniq_index.py
    www/migrations/0005_de_translations_fields.py
    www/migrations/0005_pointsynonym_unique_index.py
    www/migrations/0006_auto_20170129_1255.py
    www/migrations/0006_de_traslations_fields_filling.py
    www/migrations/0007_auto_20170201_2349.py
    www/migrations/0007_merge.py
    www/migrations/0008_merge.py
    www/migrations/0009_fill_production_avatar_urls.py
    www/migrations/0010_company_slug.py
    www/migrations/0011_de_translations.py
    www/migrations/0012_de_settlement_translations.py
    www/migrations/0013_de_countries_translations.py
    www/migrations/0014_reserts.py
    www/migrations/0015_transport-new-plane-fields.py
    www/migrations/0016_restore_threadtariff.py
    www/migrations/0016_script_scriptresult.py
    www/migrations/0017_auto_20170627_1634.py
    www/migrations/0017_restore_routepath.py
    www/migrations/0018_merge.py
    www/migrations/0019_company_popular_score.py
    www/migrations/0020_auto_20170806_0107.py
    www/migrations/0021_auto_20170917_1042.py
    www/migrations/0022_delete_holiday.py
    www/migrations/0023_holiday.py
    www/migrations/0024_add_seo_description_to_company.py
    www/migrations/0025_change_holiday.py
    www/migrations/0026_auto_20171115_1652.py
    www/migrations/0027_auto_20171124_1657.py
    www/migrations/0027_auto_20171206_0022.py
    www/migrations/0028_new_year_directions_import.py
    www/migrations/0029_merge.py
    www/migrations/0030_auto_20180418_1035.py
    www/migrations/0031_companysynonym.py
    www/migrations/0032_initial_companysynonym_data.py
    www/migrations/0033_auto_20190129_1554.py
    www/migrations/0034_update_service_table_fields.py
    www/migrations/0035_auto_20190610_1425.py
    www/migrations/0036_pointsynonym_language.py
    www/migrations/0037_add-foreign-key-from-www_stationcode-to-www_station.py
    www/migrations/0038_fix_country_fk.py
    www/migrations/0039_country_add_field_code3.py
    www/migrations/0040_fix_region_fk.py
    www/migrations/0041_sync_id_for_www_region.py
    www/migrations/0042_fix_currency_currency_fk.py
    www/migrations/0043_fix_settlement_fk.py
    www/migrations/0044_add_settlement_old_avia_id.py
    www/migrations/0045_fill_settlement_old_avia_id.py
    www/migrations/0046_fix_id_intersection.py
    www/migrations/0047_add_country_covid_info_model.py
    www/migrations/__init__.py
    www/models/__init__.py
    www/models/geo.py
    www/models/precalc.py
    www/models/schedule.py
    www/models/suggests.py
    www/models/tariffs.py
    www/templatetags/__init__.py
    www/templatetags/block_found_routes.py
    www/templatetags/block_order.py
    www/templatetags/block_tablo.py
    www/templatetags/block_thread.py
    www/templatetags/common.py
    www/templatetags/durations.py
    www/templatetags/filters.py
    www/templatetags/html.py
    www/templatetags/quick_tree_add_obj.py
    www/templatetags/quick_tree_nav.py
    www/templatetags/tablo_sett_navigation.py
    www/templatetags/timezones.py
    www/templatetags/tools.py
    www/utils/__init__.py
    www/utils/common.py
    www/utils/data.py
    www/utils/exceptions.py
    www/utils/language.py
    www/utils/mysql.py
    www/utils/uids.py
    www/views/__init__.py
    www_admin/__init__.py
    www_admin/models/__init__.py
    www_admin/models/geo.py
    www_admin/models/route_search.py
    www_admin/models/schedule.py
    www_admin/models/tariffs.py
    xgettext/__init__.py
    xgettext/_common.py
    xgettext/i18n.py
)

RESOURCE_FILES(
    PREFIX travel/avia/admin/

    avia_scripts/data/aeroflot_ecpc.sql
    avia_scripts/data/flight_numbers.data.txt
    avia_scripts/data/get_popular_directions.sql
    avia_scripts/data/heater_stat.sql
    avia_scripts/data/redirect_error_stat.sql
    avia_scripts/data/redirect_stat.sql
    avia_scripts/data/top_avia_companies_on_front.sql

    avia_scripts/templates/tradedoubler.xml
    admin/templates/admin/avia/is_sync_field_comment.html
    admin/templates/admin/avia/neardirection/change_list.html
    admin/templates/admin/base_site.html
    admin/templates/admin/block_calendar.html
    admin/templates/admin/block_month.html
    admin/templates/admin/block_service_alert.html
    admin/templates/admin/change_form.html
    admin/templates/admin/change_list.html
    admin/templates/admin/coach_schema_widget.html
    admin/templates/admin/delete_selected_confirmation.html
    admin/templates/admin/edit_inline/tabular_with_checkboxes_in_head.html
    admin/templates/admin/gtfsconverter/form.html
    admin/templates/admin/importinfo/afdbchangesfile/change_form.html
    admin/templates/admin/importinfo/afotherschedulefile/change_form.html
    admin/templates/admin/importinfo/afschedulefile/change_list.html
    admin/templates/admin/importinfo/afsubwayfile/change_form.html
    admin/templates/admin/importinfo/afsubwayfile/change_list.html
    admin/templates/admin/importinfo/afupdatefile/change_form.html
    admin/templates/admin/importinfo/busstationimportfile/change_form.html
    admin/templates/admin/importinfo/mappingcontext/change_form.html
    admin/templates/admin/importinfo/originalthreaddata/change_form.html
    admin/templates/admin/importinfo/packagedirectionsslice/change_form.html
    admin/templates/admin/importinfo/packagedirectionsslice/compare.html
    admin/templates/admin/importinfo/stationmapping/change_form.html
    admin/templates/admin/importinfo/tarifffile/change_form.html
    admin/templates/admin/importinfo/trianglebusimportpackage/change_form.html
    admin/templates/admin/importinfo/twostageimportpackage/change_form.html
    admin/templates/admin/importinfo/twostageimportthread/change_form.html
    admin/templates/admin/includes/fieldset.html
    admin/templates/admin/includes/fieldset_link.html
    admin/templates/admin/index.html
    admin/templates/admin/log_list.html
    admin/templates/admin/maintenance.html
    admin/templates/admin/order/base_partner/history.html
    admin/templates/admin/order/dohopvendor/logos_view.html
    admin/templates/admin/order/partner/change_form.html
    admin/templates/admin/order/partner/track.html
    admin/templates/admin/order/partnerreview/change_list.html
    admin/templates/admin/order/partnerreview/stat.html
    admin/templates/admin/quick_tree.html
    admin/templates/admin/quick_tree_add_obj.html
    admin/templates/admin/quick_tree_nav.html
    admin/templates/admin/red/package/change_form.html
    admin/templates/admin/sindbad_stats.html
    admin/templates/admin/staticpages/staticpage/change_list.html
    admin/templates/admin/submit_line.html
    admin/templates/admin/suburban_change_notices/noticeemailtemplate/change_form.html
    admin/templates/admin/suburban_change_notices/noticeemailtemplate/send_mass_mail_confirmation.html
    admin/templates/admin/tkvc_converter.html
    admin/templates/admin/upload_railway_file.html
    admin/templates/admin/upload_schedule_file.html
    admin/templates/admin/urban/package/change_form.html
    admin/templates/admin/www/company/change_form.html
    admin/templates/admin/www/companyoffice/change_form.html
    admin/templates/admin/www/country/change_form.html
    admin/templates/admin/www/direction/change_form.html
    admin/templates/admin/www/direction/change_list.html
    admin/templates/admin/www/district/change_form.html
    admin/templates/admin/www/externaldirection/change_form.html
    admin/templates/admin/www/externaldirection/change_list.html
    admin/templates/admin/www/externaldirection/edit_schema.html
    admin/templates/admin/www/load_zip_file_form.html
    admin/templates/admin/www/region/change_form.html
    admin/templates/admin/www/regionwhitelist/change_form.html
    admin/templates/admin/www/route/change_form.html
    admin/templates/admin/www/rthread/change_form.html
    admin/templates/admin/www/settlement/change_form.html
    admin/templates/admin/www/settlementimage/change_list.html
    admin/templates/admin/www/settlementimage/change_list_results.html
    admin/templates/admin/www/settlementimage/image_search_popup.html
    admin/templates/admin/www/station/change_form.html
    admin/templates/admin/www/station/change_list.html
    admin/templates/admin/www/suburbanzone/change_form.html
    admin/templates/admin/www/suburbanzone/change_list.html
    admin/templates/admin/www/trainpseudostationmap/change_list.html
    admin/templates/admin/www/trainpseudostationmap/load_map.html
    admin/templates/filebrowser/detail.html
    leaflets/templates/admin/leaflets/leaflet.html
    stats/templates/flexiblestats_index.html
    stats/templates/servicestats_index.html
    stats/templates/stats/dynamicstats_index.html
    stats/templates/stats/top_positions.html
    www/templates/partner_stat.xml
)

END()

RECURSE_FOR_TESTS(
    tests
)

RECURSE(
    bin
)
